/**
 * 关注微信订阅号相关接口
 */
// const base = require('./base');

module.exports = function (base) {
    return {
        // 搜索微信账号
        searchWeiXinAccount(kw, args = {}) {
            args.kw = kw;
            const _sign = base.sign(args);
            return base.get('/index/search', _sign.string);
        },
        // 根据url搜索微信号
        searchWeiXinAccountByUrl(args = {}) {
            const _sign = base.sign(args);
            return base.get('/follow/query', _sign.string);
        },

        addWeiXinFollow(token, originId, groupId) {
            const _sign = base.sign({
                token,
                wx_orgin_id: originId,
                group_id: groupId || 0
            });
            return base.post('/follow/searchFollow', _sign.string);
        },
        removeWeiXinFollow(token, ids) {
            const _sign = base.sign({
                token,
                id: ids.join(',')
            });
            return base.post('/follow/unfollow', _sign.string);
        },
        addWeiXinFollowGroup(token, name) {
            const _sign = base.sign({
                token,
                name
            });
            return base.post('/follow/groupAdd', _sign.string);
        },
        getWeiXinFollowGroup(token) {
            const _sign = base.sign({
                token
            });
            return base.post('/follow/groups', _sign.string);
        },

        updateWeiXinFollowGroupName(token, id, name) {
            const _sign = base.sign({
                token,
                id,
                name
            });
            return base.post('/follow/groupModify', _sign.string);
        },
        delWeiXinFollowGroupName(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/follow/groupDel', _sign.string);
        },
        getRecommendAccountList(category, args = {}) {
            args.category = category;
            const _sign = base.sign(args);
            return base.get('/follow/recommend', _sign.string);
        },
        saveWeiXinFollowArticles(data) {
            const _sign = base.sign({
                t: 'following',
                d: data
            });
            return base.postJson('/client/saveback', _sign.data);
        },
        // 还未测试
        moveWeiXinFollowToGroup(token, destId, ids) {
            const _sign = base.sign({
                token,
                dest_id: destId,
                gzh_ids: ids.join(',')
            });
            return base.post('/follow/groupMove', _sign.string);
        },
        // sogou抓取的相关接口 start
        getfollowedAccountName(token, type) {
            const _sign = base.sign({
                token,
                type: type || 'all'
            });
            // 测试
            // return new Promise((resolve) => {
            //     resolve({
            //         data: [{
            //             name:"伊童领袖汇",uin:"2391042571",wx_alias:""
            //         }]
            //     })
            // })
            return base.get('/follow/getfollowedAccountName', _sign.string);
        },
        reportFailedAccount(token, tasks) {
            function encode(s) {
                return escape(s).replace(/%(u[0-9A-F]{4})|(%[0-9A-F]{2})/gm, function ($0, $1, $2) {
                    return $1 && '\\' + $1.toLowerCase() || unescape($2);
                });
            }
            const _sign = base.sign({
                token,
                d: encode(JSON.stringify(tasks)) //     d: json encode 列表
            });
            return base.post('/follow/reportFailedAccount', _sign.string);
        },
        // sogou抓取的相关接口 end
    };
};
