'use strict';

const router = require('./modules/mrouter')();
const ctrl = require('./controller');

router.on('/test', function (ctx, next) {
    ctx.body = 'test ok!';
    return next();
});

// 获取初始化的state
router.on('/app/initialState', [
    ctrl.config.appData
]);
router.on('/app/checkUpdate', [
    ctrl.app.checkUpdate
]);
router.on('/app/clearWebViewCache', [
    ctrl.app.clearWebViewCache
]);
router.on('/app/clearCache', [
    ctrl.app.clearCache
]);
// 初始化进度控制

// 配置数据
router.on('/config/appData', ctrl.config.appData);
router.on('/config/saveConfig', ctrl.config.saveConfig);
router.on('/config/reset', ctrl.config.reset);

// 任务系统
const task = ctrl.task;
router.on('/task/add', task.add);
router.on('/task/update', task.update);
router.on('/task/updateTaskRecord', [
    task.updateTaskRecord,
    task.updateSougouTask
]);
router.on('/task/getTaskNotice', task.getTaskNotice);


// 文章同步
const sync = ctrl.sync;
router.on('/sync/checkArticle', sync.checkArticle);
router.on('/sync/oneAccount', [
    sync.syncPrepare,
    sync.template,
    sync.reflashWeiXinTicket,
    sync.syncDownloadImages,
    sync.syncUploadImages,
    sync.syncBaijiahaoCover,
    sync.syncQQCover,
    sync.syncTouTiaoCover,
    sync.syncSoHuCover,
    sync.syncYiDianCover,
    sync.syncOMQQCover,
    sync.syncWeiXinVoice,
    sync.syncJianShuVideo,
    sync.checkPlatformExist,
    sync.syncArticle
]);
router.on('/sync/getNeedSyncRecords', sync.getNeedSyncRecords);
router.on('/sync/saveSyncRecords', sync.saveSyncRecords);
router.on('/sync/getOneSyncRecord', sync.getOneSyncRecord);
router.on('/sync/getSyncRecords', sync.getSyncRecords);
router.on('/sync/cancelAll', sync.cancelAll);
// router.on('/sync/updateAccountStatus', sync.updateAccountStatus);
// router.on('/sync/cancelAallAccount', sync.cancelAallAccount);
// router.on('/sync/cancelAccounts', sync.cancelAccounts);
// router.on('/sync/filterHistory', sync.filterHistory);
// router.on('/sync/setToStop', sync.setToStop);
// router.on('/sync/getHistory', sync.getHistory);

// 账号管理
router.on('/account/initState', [
    ctrl.account.initState
]);
router.on('/account/save', [
    ctrl.account.parseCookie,
    ctrl.account.parseWeixinInfo,
    ctrl.account.parseQQInfo,
    // ctrl.account.parseJianShuInfo,
    ctrl.account.parseYiDianInfo,
    ctrl.account.save,
    ctrl.account.saveUsableAccount
]);
router.on('/account/migrationData', ctrl.account.migrationData);
router.on('/account/getAccount', ctrl.account.getAccount);
router.on('/account/getAccountList', ctrl.account.getAccountList);
router.on('/account/deleteAccount', ctrl.account.deleteAccount);
router.on('/account/deleteAllAccount', ctrl.account.deleteAllAccount);
router.on('/account/updateAccount', ctrl.account.updateAccount);
router.on('/account/saveToLocal', ctrl.account.saveToLocal);
router.on('/account/getWeiXinAuthorList', ctrl.account.getWeiXinAuthorList);
router.on('/account/getLoginStatusList', ctrl.account.getLoginStatusList);
router.on('/account/getBatchQrcode', ctrl.account.getBatchQrcode);
router.on('/account/checkBatchQrcode', ctrl.account.checkBatchQrcode);
router.on('/account/getUsableAccount', ctrl.account.getUsableAccount);
router.on('/account/saveUsableAccount', ctrl.account.saveUsableAccount);


// 文章管理
// router.on('/article/migrationData', ctrl.article.migrationData);
router.on('/article/hasV1Articles', ctrl.article.hasV1Articles);
router.on('/article/getV1Articles', ctrl.article.getV1Articles);
router.on('/article/importV1Articles', ctrl.article.importV1Articles);
router.on('/article/addArticle', ctrl.article.addArticle);
router.on('/article/getArticle', ctrl.article.getArticle);
router.on('/article/getArticles', ctrl.article.getArticles);
router.on('/article/getArticleList', ctrl.article.getArticleList);
router.on('/article/getArticleByServerId', ctrl.article.getArticleByServerId);
router.on('/article/searchByTitle', ctrl.article.searchByTitle);
router.on('/article/removeArticle', ctrl.article.removeArticle);
router.on('/article/removeArticleByLocalId', ctrl.article.removeArticleByLocalId);
router.on('/article/updateArticle', ctrl.article.updateArticle);
router.on('/article/replaceArticle', ctrl.article.replaceArticle);
router.on('/article/saveArticle', ctrl.article.saveArticle);
router.on('/article/saveArticleCloudId', ctrl.article.saveArticleCloudId);
router.on('/article/clearAll', ctrl.article.clearAll);
router.on('/article/getTempArticle', ctrl.article.getTempArticle);
router.on('/article/checkArticle', ctrl.article.checkArticle);

router.on('/article/fetch', [
    ctrl.articleFetch.send,
    ctrl.articleFetch.none
]);
// 注册文章抓取接口的子路由
router.on('/article/fetch/wxb', ctrl.articleFetch.wxb);
router.on('/article/fetch/weixin', ctrl.articleFetch.weixin);
router.on('/article/fetch/toutiao', ctrl.articleFetch.toutiao);
router.on('/article/fetch/baijiahao', ctrl.articleFetch.baijiahao);
router.on('/article/fetch/omqq', ctrl.articleFetch.omqq);
router.on('/article/fetch/weibo', ctrl.articleFetch.weibo);
router.on('/article/fetch/yidianzixun', ctrl.articleFetch.yidianzixun);
router.on('/article/fetch/uc', ctrl.articleFetch.uc);
router.on('/article/fetch/zhihu', ctrl.articleFetch.zhihu);
router.on('/article/fetch/jianshu', ctrl.articleFetch.jianshu);
router.on('/article/fetch/qq', ctrl.articleFetch.qq);
router.on('/article/fetch/sohu', ctrl.articleFetch.sohu);
// 多图文
router.on('/article/muti/getArticle', ctrl.mutiArticle.getArticle);
router.on('/article/muti/getArticles', ctrl.mutiArticle.getArticles);
router.on('/article/muti/getArticleList', ctrl.mutiArticle.getArticleList);
router.on('/article/muti/saveArticle', ctrl.mutiArticle.saveArticle);
router.on('/article/muti/removeArticle', ctrl.mutiArticle.removeArticle);
// 微信素材
router.on('/article/weixinMaterial/list', ctrl.weixinMaterial.list);
router.on('/article/weixinMaterial/del', ctrl.weixinMaterial.del);
router.on('/article/weixinMaterial/getPreviewUrl', ctrl.weixinMaterial.getPreviewUrl);
router.on('/article/weixinMaterial/getOneWeiXinMaterial', [
    ctrl.weixinMaterial.getPreviewUrl,
    ctrl.weixinMaterial.getOneWeiXinMaterial
]);
router.on('/article/weixinMaterial/getMultiWeiXinMaterial', ctrl.weixinMaterial.getMultiWeiXinMaterial);
router.on('/article/weixinMaterial/sendBatchMaterial', ctrl.weixinMaterial.sendBatchMaterial);
// qq素材
router.on('/article/qqMaterial/list', ctrl.qqMaterial.list);
router.on('/article/qqMaterial/del', ctrl.qqMaterial.del);
router.on('/article/qqMaterial/getMaterialById', ctrl.qqMaterial.getMaterialById);
router.on('/article/qqMaterial/batchSend', ctrl.qqMaterial.batchSend);


// 内容管理：素材
router.on('/material/getOneLocalSingelMaterial', ctrl.material.getOneLocalSingelMaterial);
router.on('/material/getOneLocalMutiMaterial', ctrl.material.getOneLocalMutiMaterial);
router.on('/material/getLocalSingelMaterials', [
    ctrl.article.getArticleList,
    ctrl.material.getLocalSingelMaterials,
]);
router.on('/material/getLocalMutiMaterials', [
    ctrl.mutiArticle.getArticleList,
    ctrl.material.getLocalMutiMaterials,
]);
router.on('/material/getCloudSingelMaterials', [
    ctrl.material.paseQuery,
    ctrl.material.getCloudSingelMaterials
]);
router.on('/material/getCloudMutiMaterials', [
    ctrl.material.paseQuery,
    ctrl.material.getCloudMutiMaterials
]);
router.on('/material/delCloudSingelMaterials', ctrl.material.delCloudSingelMaterials);
router.on('/material/downloadCloudSingelMaterials', ctrl.material.downloadCloudSingelMaterials);
router.on('/material/delCloudMutiMaterials', ctrl.material.delCloudMutiMaterials);
router.on('/material/downloadCloudMutiMaterials', ctrl.material.downloadCloudMutiMaterials);
router.on('/material/downloadCloudMutiItem', ctrl.material.downloadCloudMutiItem);
router.on('/material/uploadSingleMaterial', ctrl.material.uploadSingleMaterial);
router.on('/material/uploadMutiMaterial', ctrl.material.uploadMutiMaterial);

// 文章合成器
router.on('/compose/addArticle', ctrl.compose.addArticle);
router.on('/compose/getArticleList', ctrl.compose.getArticleList);
router.on('/compose/removeArticle', ctrl.compose.removeArticle);
router.on('/compose/done', ctrl.compose.done);
router.on('/compose/updateArticle', ctrl.compose.updateArticle);


// 文章资源
router.on('/sourceArticle/getArticleCategories', ctrl.sourceArticle.getArticleCategories);
router.on('/sourceArticle/getArticleTop', ctrl.sourceArticle.getArticleTop);
router.on('/sourceArticle/getArticleHot', ctrl.sourceArticle.getArticleHot);
router.on('/sourceArticle/searchArticle', ctrl.sourceArticle.searchArticle);
router.on('/sourceArticle/searchgzhAccount', ctrl.sourceArticle.searchgzhAccount);
router.on('/sourceArticle/followgzhAccount', ctrl.sourceArticle.followgzhAccount);
router.on('/sourceArticle/MyfollowArticles', ctrl.sourceArticle.MyfollowArticles);
router.on('/sourceArticle/getMyFollowAccount', ctrl.sourceArticle.getMyFollowAccount);
router.on('/sourceArticle/getMyFollowAccountGroup', ctrl.sourceArticle.getMyFollowAccountGroup);
router.on('/sourceArticle/getUserKeywords', ctrl.sourceArticle.getUserKeywords);
router.on('/sourceArticle/addKeywords', ctrl.sourceArticle.addKeywords);
router.on('/sourceArticle/updateKeyword', ctrl.sourceArticle.updateKeyword);
router.on('/sourceArticle/deleteKeyword', ctrl.sourceArticle.deleteKeyword);
router.on('/sourceArticle/keywordsFollowArticles', ctrl.sourceArticle.keywordsFollowArticles);
router.on('/sourceArticle/downloadWeiXinArticle', ctrl.sourceArticle.downloadWeiXinArticle);
router.on('/sourceArticle/weixinFollow/removeFollow', ctrl.sourceArticle.removeWeiXinFollow);
router.on('/sourceArticle/weixinFollow/newGroup', ctrl.sourceArticle.newWeiXinFollowGroup);
router.on('/sourceArticle/weixinFollow/updateGroup', ctrl.sourceArticle.updateWeiXinFollowGroupName);
router.on('/sourceArticle/weixinFollow/delGroup', ctrl.sourceArticle.delWeiXinFollowGroupName);
router.on('/sourceArticle/weixinFollow/moveToGroup', ctrl.sourceArticle.moveWeiXinFollowToGroup);
router.on('/sourceArticle/searchgzhAccountByUrl', ctrl.sourceArticle.searchgzhAccountByUrl);
router.on('/sourceArticle/getArticleDetail', ctrl.sourceArticle.getArticleDetail);
router.on('/sourceArticle/getNewPublicArticleTop', ctrl.sourceArticle.getNewPublicArticleTop);
router.on('/sourceArticle/startWeiXinSpider', ctrl.sourceArticle.startWeiXinSpider);
router.on('/sourceArticle/getRecommendAccount', ctrl.sourceArticle.getRecommendAccount);


// 我的收藏
router.on('/articleSource/getFavoriteGroup', ctrl.articleFavorite.getFavoriteGroup);
router.on('/articleSource/updateFavoriteGroup', ctrl.articleFavorite.updateFavoriteGroup);
router.on('/articleSource/addFavoriteGroup', ctrl.articleFavorite.addFavoriteGroup);
router.on('/articleSource/delFavoriteGroup', ctrl.articleFavorite.delFavoriteGroup);
router.on('/articleSource/getFavoriteList', ctrl.articleFavorite.getFavoriteList);
router.on('/articleSource/addFavorite', ctrl.articleFavorite.addFavorite);
router.on('/articleSource/delFavorite', ctrl.articleFavorite.delFavorite);
router.on('/articleSource/moveFavoriteToGroup', ctrl.articleFavorite.moveFavoriteToGroup);


// 模版管理
router.on('/templateSetting/getTemplate', ctrl.templateSetting.getTemplate);
router.on('/templateSetting/setTemplate', ctrl.templateSetting.setTemplate);

// 定时群发管理

router.on('/timingGroup/getTimingGroupList', ctrl.timingGroup.getTimingGroupList);
router.on('/timingGroup/getSendTimerAcountList', ctrl.timingGroup.getSendTimerAcountList);
router.on('/timingGroup/addSendTimer', ctrl.timingGroup.addSendTimer);
router.on('/timingGroup/updateSendTimer', ctrl.timingGroup.updateSendTimer);
router.on('/timingGroup/removeSendTimer', ctrl.timingGroup.removeSendTimer);
router.on('/timingGroup/getWeiXinMaterial', ctrl.timingGroup.getWeiXinMaterial);

// 数据中心
router.on('/report/getReportData', [
    ctrl.report.getReportData,
    ctrl.report.weixinReportLoader
]);
router.on('/report/getOneAccountReport', [
    ctrl.report.getOneAccountReport,
    ctrl.report.weixinOneAccountUserReportLoader,
    ctrl.report.weixinOneAccountArticleReportLoader
]);
// router.on('/report/all', [ctrl.report.preCheck, ctrl.report.all]);
// router.on('/report/detail', [ctrl.report.preCheck, ctrl.report.detail]);
// router.on('/report/homeAll', [
//     ctrl.report.preCheck,
//     ctrl.report.detail,
//     ctrl.report.all,
//     ctrl.report.extend
// ]);
// // 刷新某些账号报表数据(去缓存)
// router.on('/report/reflashAccount', [
//     ctrl.report.preCheck,
//     ctrl.report.removeCache,
//     ctrl.report.detail,
//     ctrl.report.all,
//     ctrl.report.extend
// ]);

// 编辑器辅助
router.on('/editor/getImageInfo', ctrl.editor.getImageInfo);
router.on('/editor/addVoice', ctrl.editor.addVoice);
router.on('/editor/saveLocalImage', ctrl.editor.saveLocalImage);
router.on('/editor/saveNetworkImageToLocal', [
    ctrl.editor.saveNetworkImageToLocal,
    ctrl.editor.saveLocalImage
]);
router.on('/editor/convertOnlyVideo', ctrl.editor.convertOnlyVideo);
router.on('/editor/addImage', ctrl.editor.addImage);
router.on('/editor/searchImage', ctrl.editor.searchImage);
router.on('/editor/searchMusic', ctrl.editor.searchMusic);
router.on('/editor/fetchVideo', [
    ctrl.editorVideo.fetchYoukuVideo,
    ctrl.editorVideo.fetchQQVideo,
    ctrl.editorVideo.fetchTudouVideo,
    ctrl.editorVideo.fetchMiaopaiVideo,
    ctrl.editorVideo.fetchSohuVideo,
    ctrl.editorVideo.fetchIqiyi,
    ctrl.editorVideo.fetchSina,
    ctrl.editorVideo.noVideo
]);
router.on('/editor/getPreviewUrl', [
    ctrl.editor.getPreviewUrl
]);
router.on('/editor/readPreviewUrl', [
    ctrl.editor.readPreviewUrl
]);
router.on('/editor/getSystemStyle', ctrl.editorStyle.getSystemStyle);
router.on('/editor/getMyStyleList', ctrl.editorStyle.getMyStyleList);
router.on('/editor/getStyleTags', ctrl.editorStyle.getStyleTags);
router.on('/editor/getStyleTagList', ctrl.editorStyle.getStyleTagList);
router.on('/editor/saveMyStyle', ctrl.editorStyle.saveMyStyle);
router.on('/editor/deleteMyStyle', ctrl.editorStyle.deleteMyStyle);
router.on('/editor/updateStyleTag', ctrl.editorStyle.updateStyleTag);
router.on('/editor/deleteStyleTag', ctrl.editorStyle.deleteStyleTag);
router.on('/editor/collectStyle', ctrl.editorStyle.collectStyle);
router.on('/editor/getMySpaceImages', ctrl.editor.getMySpaceImages);
router.on('/editor/previewSendPhone', ctrl.editor.previewSendPhone);

// 图片
router.on('/image/addImage', ctrl.image.addImage);
router.on('/image/getImageByArticle', ctrl.image.getImageByArticle);
router.on('/image/getType', ctrl.image.getType);

// 记录错误日志
router.on('/log/push', ctrl.log.push);
router.on('/log/send', ctrl.log.send);

// 埋点
router.on('/monitor/save', ctrl.monitor.save);
router.on('/monitor/send', ctrl.monitor.send);
router.on('/monitor/close', [
    ctrl.monitor.save,
    ctrl.monitor.send
]);

// 搜狗文章抓取
router.on('/sogouSpider/start', ctrl.sogou.start);
router.on('/sogouSpider/getStatus', ctrl.sogou.getStatus);
router.on('/sogouSpider/stop', ctrl.sogou.stop);

// 临时数据
router.on('/temp/save', ctrl.temp.save);
router.on('/temp/get', ctrl.temp.get);
router.on('/temp/delete', ctrl.temp.delete);

module.exports = router;
