/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.updater.PkgItem;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.core.PkgCategory;
import com.android.sdkuilib.internal.repository.core.PkgCategoryApi;
import com.android.sdkuilib.internal.repository.core.PkgContentProvider;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.ui.AddonSitesDialog;
import com.android.sdkuilib.internal.repository.ui.PackagesPageImpl;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public final class PackagesPage
extends Composite
implements ISdkChangeListener {
    private final Map<MenuAction, MenuItem> mMenuActions = new HashMap<MenuAction, MenuItem>();
    private final PackagesPageImpl mImpl;
    private final SdkUpdaterWindow.SdkInvocationContext mContext;
    private boolean mDisplayArchives = false;
    private boolean mOperationPending;
    private Composite mGroupPackages;
    private Text mTextSdkOsPath;
    private Button mCheckFilterObsolete;
    private Button mCheckFilterInstalled;
    private Button mCheckFilterNew;
    private Composite mGroupOptions;
    private Composite mGroupSdk;
    private Button mButtonDelete;
    private Button mButtonInstall;
    private Font mTreeFontItalic;
    private TreeColumn mTreeColumnName;
    private CheckboxTreeViewer mTreeViewer;

    public PackagesPage(Composite parent, int swtStyle, SwtUpdaterData swtUpdaterData, SdkUpdaterWindow.SdkInvocationContext context) {
        super(parent, swtStyle);
        this.mImpl = new PackagesPageImpl(swtUpdaterData){

            @Override
            protected boolean isUiDisposed() {
                return PackagesPage.this.mGroupPackages == null || PackagesPage.this.mGroupPackages.isDisposed();
            }

            @Override
            protected void syncExec(Runnable runnable) {
                if (!this.isUiDisposed()) {
                    PackagesPage.this.mGroupPackages.getDisplay().syncExec(runnable);
                }
            }

            @Override
            protected void syncViewerSelection() {
                PackagesPage.this.syncViewerSelection();
            }

            @Override
            protected void refreshViewerInput() {
                PackagesPage.this.refreshViewerInput();
            }

            @Override
            protected Font getTreeFontItalic() {
                return PackagesPage.this.mTreeFontItalic;
            }

            @Override
            protected void loadPackages(boolean useLocalCache, boolean overrideExisting) {
                PackagesPage.this.loadPackages(useLocalCache, overrideExisting);
            }
        };
        this.mContext = context;
        this.createContents(this);
        this.postCreate();
    }

    public void performFirstLoad() {
        this.mImpl.performFirstLoad();
    }

    private void createContents(Composite parent) {
        GridLayoutBuilder.create(parent).noMargins().columns(2);
        this.mGroupSdk = new Composite(parent, 0);
        GridDataBuilder.create((Control)this.mGroupSdk).hFill().vCenter().hGrab().hSpan(2);
        GridLayoutBuilder.create(this.mGroupSdk).columns(2);
        Label label1 = new Label(this.mGroupSdk, 0);
        label1.setText("SDK Path:");
        this.mTextSdkOsPath = new Text(this.mGroupSdk, 0);
        GridDataBuilder.create((Control)this.mTextSdkOsPath).hFill().vCenter().hGrab();
        this.mTextSdkOsPath.setEnabled(false);
        Group groupPackages = new Group(parent, 0);
        this.mGroupPackages = groupPackages;
        GridDataBuilder.create((Control)this.mGroupPackages).fill().grab().hSpan(2);
        groupPackages.setText("Packages");
        GridLayoutBuilder.create((Composite)groupPackages).columns(1);
        this.mTreeViewer = new CheckboxTreeViewer((Composite)groupPackages, 2048);
        this.mImpl.setITreeViewer(new PackagesPageImpl.ICheckboxTreeViewer(){

            @Override
            public Object getInput() {
                return PackagesPage.this.mTreeViewer.getInput();
            }

            @Override
            public void setInput(List<PkgCategory> cats) {
                PackagesPage.this.mTreeViewer.setInput(cats);
            }

            @Override
            public void setContentProvider(PkgContentProvider pkgContentProvider) {
                PackagesPage.this.mTreeViewer.setContentProvider(pkgContentProvider);
            }

            @Override
            public void refresh() {
                PackagesPage.this.mTreeViewer.refresh();
            }

            @Override
            public Object[] getCheckedElements() {
                return PackagesPage.this.mTreeViewer.getCheckedElements();
            }
        });
        this.mTreeViewer.addFilter(new ViewerFilter(){

            @Override
            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return PackagesPage.this.filterViewerItem(element);
            }
        });
        this.mTreeViewer.addCheckStateListener(new ICheckStateListener(){

            @Override
            public void checkStateChanged(CheckStateChangedEvent event) {
                PackagesPage.this.onTreeCheckStateChanged(event);
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                PackagesPage.this.onTreeDoubleClick(event);
            }
        });
        Tree tree = this.mTreeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        GridDataBuilder.create((Control)tree).fill().grab();
        TreeViewerColumn columnName = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        this.mTreeColumnName = columnName.getColumn();
        this.mTreeColumnName.setText("Name");
        this.mTreeColumnName.setWidth(340);
        TreeViewerColumn columnApi = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn2 = columnApi.getColumn();
        treeColumn2.setText("API");
        treeColumn2.setAlignment(0x1000000);
        treeColumn2.setWidth(50);
        TreeViewerColumn columnRevision = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn3 = columnRevision.getColumn();
        treeColumn3.setText("Rev.");
        treeColumn3.setToolTipText("Revision currently installed");
        treeColumn3.setAlignment(0x1000000);
        treeColumn3.setWidth(50);
        TreeViewerColumn columnStatus = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn4 = columnStatus.getColumn();
        treeColumn4.setText("Status");
        treeColumn4.setAlignment(16384);
        treeColumn4.setWidth(190);
        this.mImpl.setIColumns(this.wrapColumn(columnName), this.wrapColumn(columnApi), this.wrapColumn(columnRevision), this.wrapColumn(columnStatus));
        this.mGroupOptions = new Composite((Composite)groupPackages, 0);
        GridDataBuilder.create((Control)this.mGroupOptions).hFill().vCenter().hGrab();
        GridLayoutBuilder.create(this.mGroupOptions).columns(7).noMargins();
        Label label3 = new Label(this.mGroupOptions, 0);
        label3.setText("Show:");
        this.mCheckFilterNew = new Button(this.mGroupOptions, 32);
        this.mCheckFilterNew.setText("Updates/New");
        this.mCheckFilterNew.setToolTipText("Show Updates and New");
        this.mCheckFilterNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterNew.setSelection(true);
        this.mCheckFilterInstalled = new Button(this.mGroupOptions, 32);
        this.mCheckFilterInstalled.setToolTipText("Show Installed");
        this.mCheckFilterInstalled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterInstalled.setSelection(true);
        this.mCheckFilterInstalled.setText("Installed");
        new Label(this.mGroupOptions, 0);
        Link linkSelectNew = new Link(this.mGroupOptions, 0);
        String strLinkNew = "New";
        String strLinkUpdates = "Updates";
        linkSelectNew.setText(String.format("Select <a>%1$s</a> or <a>%2$s</a>", "New", "Updates"));
        linkSelectNew.setToolTipText("Selects all items that are either new or updates.");
        GridDataBuilder.create((Control)linkSelectNew).hFill();
        linkSelectNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean selectNew = e.text == null || e.text.equals("New");
                PackagesPage.this.onSelectNewUpdates(selectNew, !selectNew, false);
            }
        });
        Label placeholder = new Label(this.mGroupOptions, 0);
        GridDataBuilder.create((Control)placeholder).hFill().hGrab();
        this.mButtonInstall = new Button(this.mGroupOptions, 0);
        this.mButtonInstall.setText("");
        this.mButtonInstall.setToolTipText("Install one or more packages");
        GridDataBuilder.create((Control)this.mButtonInstall).vCenter().wHint(150);
        this.mButtonInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesPage.this.onButtonInstall();
            }
        });
        new Label(this.mGroupOptions, 0);
        this.mCheckFilterObsolete = new Button(this.mGroupOptions, 32);
        this.mCheckFilterObsolete.setText("Obsolete");
        this.mCheckFilterObsolete.setToolTipText("Also show obsolete packages");
        this.mCheckFilterObsolete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterObsolete.setSelection(false);
        new Label(this.mGroupOptions, 0);
        new Label(this.mGroupOptions, 0);
        Link linkDeselect = new Link(this.mGroupOptions, 0);
        linkDeselect.setText("<a>Deselect All</a>");
        linkDeselect.setToolTipText("Deselects all the currently selected items");
        GridDataBuilder.create((Control)linkDeselect).hFill();
        linkDeselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                PackagesPage.this.onDeselectAll();
            }
        });
        placeholder = new Label(this.mGroupOptions, 0);
        GridDataBuilder.create((Control)placeholder).hFill().hGrab();
        this.mButtonDelete = new Button(this.mGroupOptions, 0);
        this.mButtonDelete.setText("");
        this.mButtonDelete.setToolTipText("Delete one ore more installed packages");
        GridDataBuilder.create((Control)this.mButtonDelete).vCenter().wHint(150);
        this.mButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesPage.this.onButtonDelete();
            }
        });
    }

    private PackagesPageImpl.ITreeViewerColumn wrapColumn(final TreeViewerColumn column) {
        return new PackagesPageImpl.ITreeViewerColumn(){

            @Override
            public void setLabelProvider(ColumnLabelProvider labelProvider) {
                column.setLabelProvider(labelProvider);
            }
        };
    }

    private Image getImage(String filename) {
        ImageFactory imgFactory;
        if (this.mImpl.mSwtUpdaterData != null && (imgFactory = this.mImpl.mSwtUpdaterData.getImageFactory()) != null) {
            return imgFactory.getImageByName(filename);
        }
        return null;
    }

    public void registerMenuAction(final MenuAction action, MenuItem item) {
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = null;
                switch (action) {
                    case RELOAD: {
                        PackagesPage.this.mImpl.fullReload();
                        break;
                    }
                    case SHOW_ADDON_SITES: {
                        AddonSitesDialog d = new AddonSitesDialog(PackagesPage.this.getShell(), ((PackagesPage)PackagesPage.this).mImpl.mSwtUpdaterData);
                        if (!d.open()) break;
                        PackagesPage.this.mImpl.loadPackages();
                        break;
                    }
                    case TOGGLE_SHOW_ARCHIVES: {
                        PackagesPage.this.mDisplayArchives = !PackagesPage.this.mDisplayArchives;
                        ((PkgContentProvider)PackagesPage.this.mTreeViewer.getContentProvider()).setDisplayArchives(PackagesPage.this.mDisplayArchives);
                        PackagesPage.this.mTreeViewer.setInput(null);
                        PackagesPage.this.refreshViewerInput();
                        PackagesPage.this.syncViewerSelection();
                        break;
                    }
                    case TOGGLE_SHOW_INSTALLED_PKG: {
                        button = PackagesPage.this.mCheckFilterInstalled;
                        break;
                    }
                    case TOGGLE_SHOW_OBSOLETE_PKG: {
                        button = PackagesPage.this.mCheckFilterObsolete;
                        break;
                    }
                    case TOGGLE_SHOW_UPDATE_NEW_PKG: {
                        button = PackagesPage.this.mCheckFilterNew;
                    }
                }
                if (button != null && !button.isDisposed()) {
                    boolean value = button.getSelection();
                    if (!value && (button.getStyle() & 0x10) != 0) {
                        for (Control child : button.getParent().getChildren()) {
                            if (!(child instanceof Button) || child == button || (child.getStyle() & 0x10) == 0) continue;
                            ((Button)child).setSelection(value);
                        }
                    }
                    button.setSelection(!value);
                    button.notifyListeners(13, new Event());
                }
                PackagesPage.this.updateMenuCheckmarks();
            }
        });
        this.mMenuActions.put(action, item);
    }

    private void updateMenuCheckmarks() {
        for (Map.Entry<MenuAction, MenuItem> entry : this.mMenuActions.entrySet()) {
            MenuAction action = entry.getKey();
            MenuItem item = entry.getValue();
            if (action.getMenuStyle() == 0) continue;
            boolean value = false;
            Button button = null;
            switch (action) {
                case TOGGLE_SHOW_ARCHIVES: {
                    value = this.mDisplayArchives;
                    break;
                }
                case TOGGLE_SHOW_INSTALLED_PKG: {
                    button = this.mCheckFilterInstalled;
                    break;
                }
                case TOGGLE_SHOW_OBSOLETE_PKG: {
                    button = this.mCheckFilterObsolete;
                    break;
                }
                case TOGGLE_SHOW_UPDATE_NEW_PKG: {
                    button = this.mCheckFilterNew;
                    break;
                }
            }
            if (button != null && !button.isDisposed()) {
                value = button.getSelection();
            }
            if (item.isDisposed()) continue;
            item.setSelection(value);
        }
    }

    private void postCreate() {
        this.mImpl.postCreate();
        if (this.mImpl.mSwtUpdaterData != null) {
            this.mTextSdkOsPath.setText(this.mImpl.mSwtUpdaterData.getOsSdkRoot());
        }
        ((PkgContentProvider)this.mTreeViewer.getContentProvider()).setDisplayArchives(this.mDisplayArchives);
        ColumnViewerToolTipSupport.enableFor(this.mTreeViewer, 2);
        Tree tree = this.mTreeViewer.getTree();
        FontData fontData = tree.getFont().getFontData()[0];
        fontData.setStyle(2);
        this.mTreeFontItalic = new Font((Device)tree.getDisplay(), fontData);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PackagesPage.this.mTreeFontItalic.dispose();
                PackagesPage.this.mTreeFontItalic = null;
            }
        });
    }

    private void loadPackages(boolean useLocalCache, boolean overrideExisting) {
        if (this.mImpl.mSwtUpdaterData == null) {
            return;
        }
        if (this.mTreeColumnName.isDisposed()) {
            return;
        }
        this.mTreeColumnName.setImage(this.getImage("platform_pkg_16.png"));
        this.mImpl.loadPackagesImpl(useLocalCache, overrideExisting);
    }

    private void refreshViewerInput() {
        if (!this.mGroupPackages.isDisposed()) {
            try {
                this.mImpl.setViewerInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.expandInitial(this.mTreeViewer.getInput());
            this.updateButtonsState();
            this.updateMenuCheckmarks();
        }
    }

    private boolean filterViewerItem(Object treeElement) {
        PkgCategory cat;
        if (treeElement instanceof PkgCategory && !(cat = (PkgCategory)treeElement).getItems().isEmpty()) {
            for (PkgItem item : cat.getItems()) {
                if (!this.filterViewerItem(item)) continue;
                return true;
            }
            return false;
        }
        if (treeElement instanceof PkgItem) {
            PkgItem item = (PkgItem)treeElement;
            if (!this.mCheckFilterObsolete.getSelection() && item.isObsolete()) {
                return false;
            }
            if (!this.mCheckFilterInstalled.getSelection() && item.getState() == PkgItem.PkgState.INSTALLED) {
                return false;
            }
            if (!this.mCheckFilterNew.getSelection() && (item.getState() == PkgItem.PkgState.NEW || item.hasUpdatePkg())) {
                return false;
            }
        }
        return true;
    }

    private void expandInitial(Object elem) {
        if (elem == null) {
            return;
        }
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            boolean enablePreviews = this.mImpl.mSwtUpdaterData.getSettingsController().getSettings().getEnablePreviews();
            this.mTreeViewer.setExpandedState(elem, true);
            block0: for (Object pkg : ((ITreeContentProvider)this.mTreeViewer.getContentProvider()).getChildren(elem)) {
                if (!(pkg instanceof PkgCategory)) continue;
                PkgCategory cat = (PkgCategory)pkg;
                if (cat.getKey().equals(PkgCategoryApi.KEY_TOOLS) || enablePreviews && cat.getKey().equals(PkgCategoryApi.KEY_TOOLS_PREVIEW)) {
                    this.expandInitial(pkg);
                    continue;
                }
                for (PkgItem item : cat.getItems()) {
                    if (item.getState() != PkgItem.PkgState.INSTALLED) continue;
                    this.expandInitial(pkg);
                    continue block0;
                }
            }
        }
    }

    private void onTreeCheckStateChanged(CheckStateChangedEvent event) {
        boolean checked = event.getChecked();
        Object elem = event.getElement();
        assert (event.getSource() == this.mTreeViewer);
        this.checkAndExpandItem(elem, checked, true, true);
        this.updateButtonsState();
    }

    private void onTreeDoubleClick(DoubleClickEvent event) {
        assert (event.getSource() == this.mTreeViewer);
        ISelection sel = event.getSelection();
        if (sel.isEmpty() || !(sel instanceof ITreeSelection)) {
            return;
        }
        ITreeSelection tsel = (ITreeSelection)sel;
        Object elem = tsel.getFirstElement();
        if (elem == null) {
            return;
        }
        ITreeContentProvider provider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        Object[] children = provider.getElements(elem);
        if (children == null) {
            return;
        }
        if (children.length > 0) {
            if (this.mTreeViewer.getExpandedState(elem)) {
                this.mTreeViewer.collapseToLevel(elem, 1);
            } else {
                this.mTreeViewer.expandToLevel(elem, 1);
            }
        } else {
            this.checkAndExpandItem(elem, !this.mTreeViewer.getChecked(elem), false, true);
            this.updateButtonsState();
        }
    }

    private void checkAndExpandItem(Object elem, boolean checked, boolean fixChildren, boolean fixParent) {
        Object parent;
        ITreeContentProvider provider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        if (checked != this.mTreeViewer.getChecked(elem)) {
            this.mTreeViewer.setChecked(elem, checked);
        }
        if (elem instanceof PkgItem) {
            ((PkgItem)elem).setChecked(checked);
        }
        if (!checked) {
            Object parent2;
            if (fixChildren) {
                this.mTreeViewer.setSubtreeChecked(elem, checked);
                for (Object child : provider.getChildren(elem)) {
                    this.checkAndExpandItem(child, checked, fixChildren, false);
                }
            }
            if (fixParent && (parent2 = provider.getParent(elem)) != null && this.mTreeViewer.getChecked(parent2)) {
                this.mTreeViewer.setChecked(parent2, false);
            }
            return;
        }
        if (fixChildren) {
            if (elem instanceof PkgCategory || elem instanceof PkgItem) {
                Object[] children;
                for (Object child : children = provider.getChildren(elem)) {
                    this.checkAndExpandItem(child, true, fixChildren, false);
                }
                if (elem instanceof PkgCategory) {
                    if (children.length > 0) {
                        this.checkAndExpandItem(children[0], true, false, true);
                    } else {
                        this.mTreeViewer.setChecked(elem, false);
                    }
                }
            } else if (elem instanceof Package) {
                this.selectCompatibleArchives(elem, provider);
            }
        }
        if (fixParent && checked && elem instanceof PkgItem && !this.mTreeViewer.getChecked(parent = provider.getParent(elem))) {
            Object[] children = provider.getChildren(parent);
            boolean allChecked = children.length > 0;
            for (Object e : children) {
                if (this.mTreeViewer.getChecked(e)) continue;
                allChecked = false;
                break;
            }
            if (allChecked) {
                this.mTreeViewer.setChecked(parent, true);
            }
        }
    }

    private void selectCompatibleArchives(Object pkg, ITreeContentProvider provider) {
        for (Object archive : provider.getChildren(pkg)) {
            if (!(archive instanceof Archive)) continue;
            this.mTreeViewer.setChecked(archive, ((Archive)archive).isCompatible());
        }
    }

    private void onSelectNewUpdates(boolean selectNew, boolean selectUpdates, boolean selectTop) {
        this.mImpl.onSelectNewUpdates(selectNew, selectUpdates, selectTop);
    }

    private void onDeselectAll() {
        this.mImpl.onDeselectAll();
        this.syncViewerSelection();
    }

    private void syncViewerSelection() {
        ITreeContentProvider provider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        Object input = this.mTreeViewer.getInput();
        if (input != null) {
            for (Object cat : provider.getElements(input)) {
                Object[] children = provider.getElements(cat);
                boolean allChecked = children.length > 0;
                for (Object child : children) {
                    if (!(child instanceof PkgItem)) continue;
                    PkgItem item = (PkgItem)child;
                    boolean checked = item.isChecked();
                    allChecked &= checked;
                    if (checked == this.mTreeViewer.getChecked(item)) continue;
                    if (checked && !this.mTreeViewer.getExpandedState(cat)) {
                        this.mTreeViewer.setExpandedState(cat, true);
                    }
                    this.checkAndExpandItem(item, checked, true, false);
                }
                if (allChecked == this.mTreeViewer.getChecked(cat)) continue;
                this.mTreeViewer.setChecked(cat, allChecked);
            }
        }
        this.updateButtonsState();
    }

    private void beginOperationPending() {
        this.mOperationPending = true;
        this.updateButtonsState();
    }

    private void endOperationPending() {
        this.mOperationPending = false;
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        int numPackages;
        if (!this.mButtonInstall.isDisposed()) {
            numPackages = this.getArchivesForInstall(null);
            this.mButtonInstall.setEnabled(numPackages > 0 && !this.mOperationPending);
            this.mButtonInstall.setText(numPackages == 0 ? "Install packages..." : (numPackages == 1 ? "Install 1 package..." : String.format("Install %d packages...", numPackages)));
        }
        if (!this.mButtonDelete.isDisposed()) {
            numPackages = this.getArchivesToDelete(null, null);
            this.mButtonDelete.setEnabled(numPackages > 0 && !this.mOperationPending);
            this.mButtonDelete.setText(numPackages == 0 ? "Delete packages..." : (numPackages == 1 ? "Delete 1 package..." : String.format("Delete %d packages...", numPackages)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onButtonInstall() {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        this.getArchivesForInstall(archives);
        if (this.mImpl.mSwtUpdaterData != null) {
            boolean needsRefresh = false;
            try {
                this.beginOperationPending();
                List<Archive> installed = this.mImpl.mSwtUpdaterData.updateOrInstallAll_WithGUI(archives, this.mCheckFilterObsolete.getSelection(), this.mContext == SdkUpdaterWindow.SdkInvocationContext.IDE ? 1 : 2);
                needsRefresh = installed != null && !installed.isEmpty();
            }
            finally {
                this.endOperationPending();
                if (needsRefresh) {
                    this.mImpl.localReload();
                }
            }
        }
    }

    private int getArchivesForInstall(List<Archive> outArchives) {
        boolean checkIsCompatible;
        if (this.mTreeViewer == null || this.mTreeViewer.getTree() == null || this.mTreeViewer.getTree().isDisposed()) {
            return 0;
        }
        Object[] checked = this.mTreeViewer.getCheckedElements();
        if (checked == null) {
            return 0;
        }
        int count = 0;
        boolean bl = checkIsCompatible = System.getenv("ANDROID_SDK_IGNORE_COMPAT") == null;
        if (this.mDisplayArchives) {
            for (Object c : checked) {
                Archive a;
                if (!(c instanceof Archive) || (a = (Archive)c) == null || checkIsCompatible && !a.isCompatible()) continue;
                ++count;
                if (outArchives == null) continue;
                outArchives.add((Archive)c);
            }
        } else {
            for (Object c : checked) {
                Package p = null;
                if (c instanceof Package) {
                    p = (Package)c;
                } else if (c instanceof PkgItem) {
                    p = ((PkgItem)c).getMainPackage();
                    PkgItem pi = (PkgItem)c;
                    if (pi.getState() == PkgItem.PkgState.INSTALLED) {
                        p = pi.getUpdatePkg();
                    } else if (pi.getState() == PkgItem.PkgState.NEW) {
                        p = pi.getMainPackage();
                    }
                }
                if (p == null) continue;
                for (Archive a : p.getArchives()) {
                    if (a == null || checkIsCompatible && !a.isCompatible()) continue;
                    ++count;
                    if (outArchives == null) continue;
                    outArchives.add(a);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onButtonDelete() {
        String title = "Delete SDK Package";
        StringBuilder msg = new StringBuilder("Are you sure you want to delete:");
        final ArrayList<Archive> archives = new ArrayList<Archive>();
        this.getArchivesToDelete(msg, archives);
        if (!archives.isEmpty()) {
            msg.append("\n").append("This cannot be undone.");
            if (MessageDialog.openQuestion(this.getShell(), "Delete SDK Package", msg.toString())) {
                try {
                    this.beginOperationPending();
                    this.mImpl.mSwtUpdaterData.getTaskFactory().start("Delete Package", new ITask(){

                        @Override
                        public void run(ITaskMonitor monitor) {
                            monitor.setProgressMax(archives.size() + 1);
                            for (Archive a : archives) {
                                monitor.setDescription("Deleting '%1$s' (%2$s)", a.getParentPackage().getShortDescription(), a.getLocalOsPath());
                                a.deleteLocal();
                                monitor.incProgress(1);
                                if (!monitor.isCancelRequested()) continue;
                                break;
                            }
                            monitor.incProgress(1);
                            monitor.setDescription("Done", new Object[0]);
                        }
                    });
                }
                finally {
                    this.endOperationPending();
                    this.mImpl.localReload();
                }
            }
        }
    }

    private int getArchivesToDelete(StringBuilder outMsg, List<Archive> outArchives) {
        if (this.mTreeViewer == null || this.mTreeViewer.getTree() == null || this.mTreeViewer.getTree().isDisposed()) {
            return 0;
        }
        Object[] checked = this.mTreeViewer.getCheckedElements();
        if (checked == null) {
            return 0;
        }
        int count = 0;
        if (this.mDisplayArchives) {
            for (Object c : checked) {
                Archive a;
                if (!(c instanceof Archive) || (a = (Archive)c) == null || !a.isLocal()) continue;
                ++count;
                if (outMsg != null) {
                    String osPath = a.getLocalOsPath();
                    File dir = new File(osPath);
                    Package p = a.getParentPackage();
                    if (p != null && dir.isDirectory()) {
                        outMsg.append("\n - ").append(p.getShortDescription());
                    }
                }
                if (outArchives == null) continue;
                outArchives.add(a);
            }
        } else {
            for (Object c : checked) {
                PkgItem pi;
                PkgItem.PkgState state;
                if (!(c instanceof PkgItem) || (state = (pi = (PkgItem)c).getState()) != PkgItem.PkgState.INSTALLED) continue;
                Package p = pi.getMainPackage();
                for (Archive a : p.getArchives()) {
                    String osPath;
                    File dir;
                    if (a == null || !a.isLocal()) continue;
                    ++count;
                    if (outMsg != null && (dir = new File(osPath = a.getLocalOsPath())).isDirectory()) {
                        outMsg.append("\n - ").append(p.getShortDescription());
                    }
                    if (outArchives == null) continue;
                    outArchives.add(a);
                }
            }
        }
        return count;
    }

    @Override
    public void onSdkLoaded() {
        this.onSdkReload();
    }

    @Override
    public void onSdkReload() {
        this.mImpl.loadPackages();
    }

    @Override
    public void preInstallHook() {
    }

    @Override
    public void postInstallHook() {
    }

    static enum MenuAction {
        RELOAD(0, "Reload"),
        SHOW_ADDON_SITES(0, "Manage Add-on Sites..."),
        TOGGLE_SHOW_ARCHIVES(32, "Show Archives Details"),
        TOGGLE_SHOW_INSTALLED_PKG(32, "Show Installed Packages"),
        TOGGLE_SHOW_OBSOLETE_PKG(32, "Show Obsolete Packages"),
        TOGGLE_SHOW_UPDATE_NEW_PKG(32, "Show Updates/New Packages");

        private final int mMenuStyle;
        private final String mMenuTitle;

        private MenuAction(int menuStyle, String menuTitle) {
            this.mMenuStyle = menuStyle;
            this.mMenuTitle = menuTitle;
        }

        public int getMenuStyle() {
            return this.mMenuStyle;
        }

        public String getMenuTitle() {
            return this.mMenuTitle;
        }
    }
}

