/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdkuilib.internal.widgets.IMessageBoxLogger;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AvdCreationPresenter {
    @NonNull
    private IWidgetAdapter mWidgets;
    private AvdManager mAvdManager;
    private ILogger mSdkLog;
    private AvdInfo mAvdInfo;
    private final TreeMap<String, IAndroidTarget> mCurrentTargets = new TreeMap();
    private static final AvdSkinChoice SKIN_DYNAMIC = new AvdSkinChoice(SkinType.DYNAMIC, "Skin with dynamic hardware controls");
    private static final AvdSkinChoice SKIN_NONE = new AvdSkinChoice(SkinType.NONE, "No skin");
    private final List<Device> mComboDevices = new ArrayList<Device>();
    private final List<AvdSkinChoice> mComboSkins = new ArrayList<AvdSkinChoice>();
    private final List<ISystemImage> mComboSystemImages = new ArrayList<ISystemImage>();
    private final List<IAndroidTarget> mComboTargets = new ArrayList<IAndroidTarget>();
    private Device mInitWithDevice;
    private AvdInfo mCreatedAvd;
    private static final String NEXUS = "Nexus";
    private static final String GENERIC = "Generic";
    private static Pattern PATTERN = Pattern.compile("(\\d+\\.?\\d*)in (.+?)( \\(.*Nexus.*\\))?");

    public AvdCreationPresenter(@NonNull AvdManager avdManager, @NonNull ILogger log, @Nullable AvdInfo editAvdInfo) {
        this.mAvdManager = avdManager;
        this.mSdkLog = log;
        this.mAvdInfo = editAvdInfo;
    }

    public AvdInfo getCreatedAvd() {
        return this.mCreatedAvd;
    }

    public void setWidgetAdapter(@NonNull IWidgetAdapter widgetAdapter) {
        this.mWidgets = widgetAdapter;
    }

    public void selectInitialDevice(@NonNull Device device) {
        this.mInitWithDevice = device;
    }

    public void onViewInit() {
        this.mWidgets.setTitle(this.mAvdInfo == null ? "Create new Android Virtual Device (AVD)" : "Edit Android Virtual Device (AVD)");
        this.initializeDevices();
        this.mComboSkins.add(SKIN_DYNAMIC);
        this.mComboSkins.add(SKIN_NONE);
        Collections.sort(this.mComboSkins);
        this.mWidgets.addComboItem(Ctrl.COMBO_SKIN, this.mComboSkins.get(0).getLabel());
        this.mWidgets.addComboItem(Ctrl.COMBO_SKIN, this.mComboSkins.get(1).getLabel());
        this.preloadTargetCombo();
        this.toggleCameras();
        this.enableSdCardWidgets(true);
        if (this.mAvdInfo != null) {
            this.fillExistingAvdInfo(this.mAvdInfo);
        } else if (this.mInitWithDevice != null) {
            this.fillInitialDeviceInfo(this.mInitWithDevice);
        }
        this.validatePage();
    }

    private void initializeDevices() {
        LocalSdk localSdk = this.mAvdManager.getLocalSdk();
        File location = localSdk.getLocation();
        if (location != null) {
            DeviceManager deviceManager = DeviceManager.createInstance(location, this.mSdkLog);
            Collection<Device> deviceList = deviceManager.getDevices(DeviceManager.ALL_DEVICES);
            ArrayList<Device> nexus = new ArrayList<Device>(deviceList.size());
            ArrayList<Device> other = new ArrayList<Device>(deviceList.size());
            for (Device device : deviceList) {
                if (AvdCreationPresenter.isNexus(device) && !AvdCreationPresenter.isGeneric(device)) {
                    nexus.add(device);
                    continue;
                }
                other.add(device);
            }
            Collections.reverse(other);
            Collections.sort(nexus, new Comparator<Device>(){

                @Override
                public int compare(Device device1, Device device2) {
                    return AvdCreationPresenter.nexusRank(device2) - AvdCreationPresenter.nexusRank(device1);
                }
            });
            this.mComboDevices.clear();
            this.mComboDevices.addAll(nexus);
            this.mComboDevices.addAll(other);
            String[] labels = new String[this.mComboDevices.size()];
            int n = this.mComboDevices.size();
            for (int i = 0; i < n; ++i) {
                Device device = this.mComboDevices.get(i);
                labels[i] = AvdCreationPresenter.isNexus(device) && !AvdCreationPresenter.isGeneric(device) ? AvdCreationPresenter.getNexusLabel(device) : AvdCreationPresenter.getGenericLabel(device);
            }
            this.mWidgets.setComboItems(Ctrl.COMBO_DEVICE, labels);
        }
    }

    @Nullable
    private Device getSelectedDevice() {
        int index = this.mWidgets.getComboIndex(Ctrl.COMBO_DEVICE);
        if (index != -1 && index < this.mComboDevices.size()) {
            return this.mComboDevices.get(index);
        }
        return null;
    }

    private void selectDevice(String manufacturer, String name) {
        int n = this.mComboDevices.size();
        for (int i = 0; i < n; ++i) {
            Device device = this.mComboDevices.get(i);
            if (!device.getManufacturer().equals(manufacturer) || !device.getName().equals(name)) continue;
            this.mWidgets.selectComboIndex(Ctrl.COMBO_DEVICE, i);
            break;
        }
    }

    private void selectDevice(Device device) {
        int n = this.mComboDevices.size();
        for (int i = 0; i < n; ++i) {
            if (!this.mComboDevices.get(i).equals(device)) continue;
            this.mWidgets.selectComboIndex(Ctrl.COMBO_DEVICE, i);
            break;
        }
    }

    void onDeviceComboChanged() {
        Device currentDevice = this.getSelectedDevice();
        if (currentDevice != null) {
            this.fillDeviceProperties(currentDevice);
        }
        this.toggleCameras();
        this.validatePage();
    }

    void onAvdNameModified() {
        String name = this.mWidgets.getText(Ctrl.TEXT_AVD_NAME).trim();
        if (this.mAvdInfo == null || !name.equals(this.mAvdInfo.getName())) {
            Pair<AvdManager.AvdConflict, String> conflict = this.mAvdManager.isAvdNameConflicting(name);
            if (conflict.getFirst() != AvdManager.AvdConflict.NO_CONFLICT) {
                if (!this.mWidgets.isEnabled(Ctrl.CHECK_FORCE_CREATION)) {
                    this.mWidgets.setEnabled(Ctrl.CHECK_FORCE_CREATION, true);
                    this.mWidgets.setChecked(Ctrl.CHECK_FORCE_CREATION, false);
                }
            } else {
                this.mWidgets.setEnabled(Ctrl.CHECK_FORCE_CREATION, false);
                this.mWidgets.setChecked(Ctrl.CHECK_FORCE_CREATION, false);
            }
        } else {
            this.mWidgets.setEnabled(Ctrl.CHECK_FORCE_CREATION, false);
            this.mWidgets.setChecked(Ctrl.CHECK_FORCE_CREATION, false);
        }
        this.validatePage();
    }

    private void fillDeviceProperties(Device device) {
        Hardware hw = device.getDefaultHardware();
        Long ram = hw.getRam().getSizeAsUnit(Storage.Unit.MiB);
        this.mWidgets.setText(Ctrl.TEXT_RAM, Long.toString(ram));
        Screen s = hw.getScreen();
        ScreenSize size = s.getSize();
        Density density = s.getPixelDensity();
        int vmHeapSize = 32;
        if (size.equals((Object)ScreenSize.XLARGE)) {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 32;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 64;
                    break;
                }
                case XHIGH: 
                case XXHIGH: 
                case XXXHIGH: {
                    vmHeapSize = 128;
                    break;
                }
            }
        } else {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 16;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 32;
                    break;
                }
                case XHIGH: 
                case XXHIGH: 
                case XXXHIGH: {
                    vmHeapSize = 64;
                    break;
                }
            }
        }
        this.mWidgets.setText(Ctrl.TEXT_VM_HEAP, Integer.toString(vmHeapSize));
        boolean reloadTabAbiCombo = false;
        List<Software> allSoftware = device.getAllSoftware();
        if (allSoftware != null && !allSoftware.isEmpty()) {
            Software first = allSoftware.get(0);
            int min = first.getMinSdkLevel();
            int max = first.getMaxSdkLevel();
            for (int i = 1; i < allSoftware.size(); ++i) {
                min = Math.min(min, first.getMinSdkLevel());
                max = Math.max(max, first.getMaxSdkLevel());
            }
            if (this.mCurrentTargets != null) {
                int bestApiLevel = Integer.MAX_VALUE;
                IAndroidTarget bestTarget = null;
                for (IAndroidTarget target : this.mCurrentTargets.values()) {
                    int apiLevel;
                    if (!target.isPlatform() || (apiLevel = target.getVersion().getApiLevel()) < min || apiLevel > max || bestTarget != null && apiLevel >= bestApiLevel) continue;
                    bestTarget = target;
                    bestApiLevel = apiLevel;
                }
                if (bestTarget != null) {
                    this.selectTarget(bestTarget);
                    reloadTabAbiCombo = true;
                }
            }
        }
        if (!reloadTabAbiCombo) {
            String deviceTagId = device.getTagId();
            Pair<IdDisplay, String> currTagAbi = this.getSelectedTagAbi();
            if (!(deviceTagId == null || currTagAbi != null && deviceTagId.equals(((IdDisplay)currTagAbi.getFirst()).getId()))) {
                reloadTabAbiCombo = true;
            }
        }
        if (reloadTabAbiCombo) {
            this.reloadTagAbiCombo();
        }
    }

    private void toggleCameras() {
        this.mWidgets.setEnabled(Ctrl.COMBO_FRONT_CAM, false);
        this.mWidgets.setEnabled(Ctrl.COMBO_BACK_CAM, false);
        Device d = this.getSelectedDevice();
        if (d != null) {
            for (Camera c : d.getDefaultHardware().getCameras()) {
                if (CameraLocation.FRONT.equals((Object)c.getLocation())) {
                    this.mWidgets.setEnabled(Ctrl.COMBO_FRONT_CAM, true);
                }
                if (!CameraLocation.BACK.equals((Object)c.getLocation())) continue;
                this.mWidgets.setEnabled(Ctrl.COMBO_BACK_CAM, true);
            }
        }
    }

    private void preloadTargetCombo() {
        String selected = null;
        int index = this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET);
        if (index >= 0) {
            selected = this.mWidgets.getComboItem(Ctrl.COMBO_TARGET, index);
        }
        this.mCurrentTargets.clear();
        this.mWidgets.setComboItems(Ctrl.COMBO_TARGET, null);
        boolean found = false;
        index = -1;
        this.mComboTargets.clear();
        LocalSdk localSdk = this.mAvdManager.getLocalSdk();
        if (localSdk != null) {
            for (IAndroidTarget target : localSdk.getTargets()) {
                String name = target.isPlatform() ? String.format("%s - API Level %s", target.getName(), target.getVersion().getApiString()) : String.format("%s (%s) - API Level %s", target.getName(), target.getVendor(), target.getVersion().getApiString());
                this.mCurrentTargets.put(name, target);
                this.mWidgets.addComboItem(Ctrl.COMBO_TARGET, name);
                this.mComboTargets.add(target);
                if (found) continue;
                ++index;
                found = name.equals(selected);
            }
        }
        this.mWidgets.setEnabled(Ctrl.COMBO_TARGET, this.mCurrentTargets.size() > 0);
        if (found) {
            this.mWidgets.selectComboIndex(Ctrl.COMBO_TARGET, index);
        }
        this.reloadTagAbiCombo();
    }

    private void selectTarget(IAndroidTarget target) {
        int n = this.mComboTargets.size();
        for (int i = 0; i < n; ++i) {
            if (target != this.mComboTargets.get(i)) continue;
            this.mWidgets.selectComboIndex(Ctrl.COMBO_TARGET, i);
            break;
        }
    }

    private IAndroidTarget getSelectedTarget() {
        int index = this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET);
        if (index != -1 && index < this.mComboTargets.size()) {
            return this.mComboTargets.get(index);
        }
        return null;
    }

    void reloadTagAbiCombo() {
        int index = this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET);
        if (index >= 0) {
            Device currDevice;
            String deviceTagId;
            String targetName = this.mWidgets.getComboItem(Ctrl.COMBO_TARGET, index);
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            ISystemImage[] systemImages = this.getSystemImages(target);
            String selected = null;
            index = this.mWidgets.getComboIndex(Ctrl.COMBO_TAG_ABI);
            if (index >= 0 && this.mWidgets.getComboSize(Ctrl.COMBO_TAG_ABI) > 1) {
                selected = this.mWidgets.getComboItem(Ctrl.COMBO_TAG_ABI, index);
            }
            String string = deviceTagId = (currDevice = this.getSelectedDevice()) == null ? null : currDevice.getTagId();
            if (deviceTagId != null && (deviceTagId.isEmpty() || SystemImage.DEFAULT_TAG.equals(deviceTagId))) {
                deviceTagId = null;
            }
            this.mWidgets.setComboItems(Ctrl.COMBO_TAG_ABI, null);
            this.mComboSystemImages.clear();
            boolean found = false;
            for (int i = 0; i < systemImages.length; ++i) {
                ISystemImage systemImage = systemImages[i];
                if (deviceTagId != null && !deviceTagId.equals(systemImage.getTag().getId())) continue;
                this.mComboSystemImages.add(systemImage);
                String prettyAbiType = AvdInfo.getPrettyAbiType(systemImage);
                this.mWidgets.addComboItem(Ctrl.COMBO_TAG_ABI, prettyAbiType);
                if (found || !(found = prettyAbiType.equals(selected))) continue;
                this.mWidgets.selectComboIndex(Ctrl.COMBO_TAG_ABI, i);
            }
            this.mWidgets.setEnabled(Ctrl.COMBO_TAG_ABI, !this.mComboSystemImages.isEmpty());
            if (this.mComboSystemImages.isEmpty()) {
                this.mWidgets.addComboItem(Ctrl.COMBO_TAG_ABI, "No system images installed for this target.");
                this.mWidgets.selectComboIndex(Ctrl.COMBO_TAG_ABI, 0);
            } else if (this.mComboSystemImages.size() == 1) {
                this.mWidgets.selectComboIndex(Ctrl.COMBO_TAG_ABI, 0);
            }
        }
        this.reloadSkinCombo();
    }

    void reloadSkinCombo() {
        AvdSkinChoice selected = this.getSelectedSkinChoice();
        Iterator<AvdSkinChoice> it = this.mComboSkins.iterator();
        while (it.hasNext()) {
            AvdSkinChoice choice = it.next();
            if (!choice.hasPath()) continue;
            it.remove();
        }
        IAndroidTarget target = this.getSelectedTarget();
        if (target != null) {
            ISystemImage sysImg = this.getSelectedSysImg();
            HashSet<File> sysImgSkins = new HashSet<File>();
            if (sysImg != null) {
                sysImgSkins.addAll(Arrays.asList(sysImg.getSkins()));
            }
            String sdkSysImgPath = new File(this.mAvdManager.getLocalSdk().getLocation(), "system-images").getAbsolutePath();
            for (File skin : target.getSkins()) {
                String label = skin.getName();
                String skinPath = skin.getAbsolutePath();
                if (skinPath.startsWith(sdkSysImgPath)) {
                    if (sysImg == null || !sysImgSkins.contains(skin)) continue;
                    if (!SystemImage.DEFAULT_TAG.equals(sysImg.getTag().getId())) {
                        String display = sysImg.getTag().getDisplay();
                        String azDisplay = display.toLowerCase(Locale.US).replaceAll("[^a-z]", "");
                        String azLabel = label.toLowerCase(Locale.US).replaceAll("[^a-z]", "");
                        if (!azLabel.contains(azDisplay)) {
                            label = String.format("%s (%s)", label, display);
                        }
                    }
                }
                AvdSkinChoice sc = new AvdSkinChoice(SkinType.FROM_TARGET, label, skin);
                this.mComboSkins.add(sc);
            }
        }
        Collections.sort(this.mComboSkins);
        this.mWidgets.setComboItems(Ctrl.COMBO_SKIN, null);
        for (int i = 0; i < this.mComboSkins.size(); ++i) {
            AvdSkinChoice choice = this.mComboSkins.get(i);
            this.mWidgets.addComboItem(Ctrl.COMBO_SKIN, choice.getLabel());
            if (choice != selected) continue;
            this.mWidgets.selectComboIndex(Ctrl.COMBO_SKIN, i);
        }
    }

    void enableSdCardWidgets(boolean sizeMode) {
        this.mWidgets.setEnabled(Ctrl.TEXT_SDCARD_SIZE, sizeMode);
        this.mWidgets.setEnabled(Ctrl.COMBO_SDCARD_SIZE, sizeMode);
        this.mWidgets.setEnabled(Ctrl.TEXT_SDCARD_FILE, !sizeMode);
        this.mWidgets.setEnabled(Ctrl.BUTTON_BROWSE_SDCARD, !sizeMode);
    }

    void onBrowseSdCard() {
        String fileName = this.mWidgets.openFileDialog("Choose SD Card image file.");
        if (fileName != null) {
            this.mWidgets.setText(Ctrl.TEXT_SDCARD_FILE, fileName);
        }
        this.validatePage();
    }

    void validatePage() {
        AvdSkinChoice skinChoice;
        ISystemImage[] sis;
        String error = null;
        ArrayList<String> warnings = new ArrayList<String>();
        boolean valid = true;
        String avdName = this.mWidgets.getText(Ctrl.TEXT_AVD_NAME);
        if (avdName.isEmpty()) {
            error = "AVD Name cannot be empty";
            this.setPageValid(false, error, null);
            return;
        }
        if (!AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
            error = String.format("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.getComboIndex(Ctrl.COMBO_DEVICE) < 0) {
            error = "No device selected";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET) < 0) {
            error = "No target selected";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mComboSystemImages.isEmpty()) {
            error = "No CPU/ABI system image available for this target";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.getSelectedTagAbi() == null) {
            error = "No CPU/ABI system image selected";
            this.setPageValid(false, error, null);
            return;
        }
        String targetName = this.mWidgets.getComboItem(Ctrl.COMBO_TARGET, this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET));
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target != null && !target.isPlatform() && (sis = target.getSystemImages()) != null && sis.length > 0) {
            Pair<IdDisplay, String> tagAbi = this.getSelectedTagAbi();
            IdDisplay tag = (IdDisplay)tagAbi.getFirst();
            String abiType = (String)tagAbi.getSecond();
            if (abiType != null && !abiType.isEmpty() && target.getParent().getSystemImage(tag, abiType) == null) {
                warnings.add(String.format("This AVD may not work unless you install the %1$s system image for %2$s (%3$s) first.", AvdInfo.getPrettyAbiType(tag, abiType), target.getParent().getName(), target.getParent().getVersion().toString()));
            }
        }
        if ((skinChoice = this.getSelectedSkinChoice()) == null) {
            error = "No skin selected";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.getText(Ctrl.TEXT_RAM).isEmpty()) {
            error = "Mising RAM value";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.getText(Ctrl.TEXT_VM_HEAP).isEmpty()) {
            error = "Mising VM Heap value";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.getText(Ctrl.TEXT_DATA_PART).isEmpty() || this.mWidgets.getComboIndex(Ctrl.COMBO_DATA_PART_SIZE) < 0) {
            error = "Invalid Data partition size.";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mWidgets.isChecked(Ctrl.RADIO_SDCARD_SIZE)) {
            if (!this.mWidgets.getText(Ctrl.TEXT_SDCARD_SIZE).isEmpty() && this.mWidgets.getComboIndex(Ctrl.COMBO_SDCARD_SIZE) >= 0) {
                try {
                    long sdSize = Long.parseLong(this.mWidgets.getText(Ctrl.TEXT_SDCARD_SIZE));
                    int sizeIndex = this.mWidgets.getComboIndex(Ctrl.COMBO_SDCARD_SIZE);
                    if (sizeIndex >= 0) {
                        sdSize <<= 10 * (1 + sizeIndex);
                    }
                    if (sdSize < 0x900000L || sdSize > 0xFFC0000000L) {
                        valid = false;
                        error = "SD Card size is invalid. Range is 9 MiB..1023 GiB.";
                    }
                }
                catch (NumberFormatException e) {
                    valid = false;
                    error = " SD Card size must be a valid integer between 9 MiB and 1023 GiB";
                }
            }
        } else if (this.mWidgets.getText(Ctrl.TEXT_SDCARD_FILE).isEmpty() || !new File(this.mWidgets.getText(Ctrl.TEXT_SDCARD_FILE)).isFile()) {
            valid = false;
            error = "SD Card path isn't valid.";
        }
        if (!valid) {
            this.setPageValid(valid, error, null);
            return;
        }
        if (this.mWidgets.isEnabled(Ctrl.CHECK_FORCE_CREATION) && !this.mWidgets.isChecked(Ctrl.CHECK_FORCE_CREATION)) {
            valid = false;
            error = String.format("The AVD name '%s' is already used.\nCheck \"Override the existing AVD\" to delete the existing one.", this.mWidgets.getText(Ctrl.TEXT_AVD_NAME));
        }
        if (this.mAvdInfo != null && !this.mAvdInfo.getName().equals(this.mWidgets.getText(Ctrl.TEXT_AVD_NAME))) {
            warnings.add(String.format("The AVD '%1$s' will be duplicated into '%2$s'.", this.mAvdInfo.getName(), this.mWidgets.getText(Ctrl.TEXT_AVD_NAME)));
        }
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            long ramSize = 0L;
            try {
                ramSize = Long.parseLong(this.mWidgets.getText(Ctrl.TEXT_RAM));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (ramSize > 768L) {
                warnings.add("On Windows, emulating RAM greater than 768M may fail depending on the system load. Try progressively smaller values of RAM if the emulator fails to launch.");
            }
        }
        if (this.mWidgets.isChecked(Ctrl.CHECK_GPU_EMUL) && this.mWidgets.isChecked(Ctrl.CHECK_SNAPSHOT)) {
            valid = false;
            error = "GPU Emulation and Snapshot cannot be used simultaneously";
        }
        String warning = Joiner.on((char)'\n').join(warnings);
        this.setPageValid(valid, error, warning);
    }

    private void setPageValid(boolean valid, String error, String warning) {
        this.mWidgets.setEnabled(Ctrl.BUTTON_OK, valid);
        if (error != null && !error.isEmpty()) {
            this.mWidgets.setImage(Ctrl.ICON_STATUS, "reject_icon16.png");
            this.mWidgets.setText(Ctrl.TEXT_STATUS, error);
        } else if (warning != null && !warning.isEmpty()) {
            this.mWidgets.setImage(Ctrl.ICON_STATUS, "warning_icon16.png");
            this.mWidgets.setText(Ctrl.TEXT_STATUS, warning);
        } else {
            this.mWidgets.setImage(Ctrl.ICON_STATUS, null);
            this.mWidgets.setText(Ctrl.TEXT_STATUS, " \n ");
        }
        this.mWidgets.repack();
    }

    boolean createAvd() {
        boolean success;
        AvdInfo avdInfo;
        String suffix;
        String avdName = this.mWidgets.getText(Ctrl.TEXT_AVD_NAME);
        if (avdName == null || avdName.isEmpty()) {
            return false;
        }
        String targetName = this.mWidgets.getComboItem(Ctrl.COMBO_TARGET, this.mWidgets.getComboIndex(Ctrl.COMBO_TARGET));
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return false;
        }
        Pair<IdDisplay, String> tagAbi = this.getSelectedTagAbi();
        if (tagAbi == null) {
            return false;
        }
        IdDisplay tag = (IdDisplay)tagAbi.getFirst();
        String abiType = (String)tagAbi.getSecond();
        String sdName = null;
        if (this.mWidgets.isChecked(Ctrl.RADIO_SDCARD_SIZE)) {
            String value = this.mWidgets.getText(Ctrl.TEXT_SDCARD_SIZE).trim();
            if (value.length() > 0) {
                sdName = value;
                switch (this.mWidgets.getComboIndex(Ctrl.COMBO_SDCARD_SIZE)) {
                    case 0: {
                        sdName = sdName + "K";
                        break;
                    }
                    case 1: {
                        sdName = sdName + "M";
                        break;
                    }
                    case 2: {
                        sdName = sdName + "G";
                        break;
                    }
                    default: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
            }
        } else {
            sdName = this.mWidgets.getText(Ctrl.TEXT_SDCARD_FILE).trim();
        }
        Device device = this.getSelectedDevice();
        if (device == null) {
            return false;
        }
        File skinFolder = null;
        String skinName = null;
        AvdSkinChoice skinChoice = this.getSelectedSkinChoice();
        if (skinChoice == null) {
            return false;
        }
        if (skinChoice.hasPath()) {
            skinFolder = skinChoice.getPath();
        } else {
            Screen s = device.getDefaultHardware().getScreen();
            skinName = s.getXDimension() + "x" + s.getYDimension();
        }
        ILogger log = this.mSdkLog;
        if (log == null || log instanceof MessageBoxLog) {
            log = this.mWidgets.newDelayedMessageBoxLog(String.format("Result of creating AVD '%s':", avdName), false);
        }
        Map<String, String> hwProps = DeviceManager.getHardwareProperties(device);
        if (this.mWidgets.isChecked(Ctrl.CHECK_GPU_EMUL)) {
            hwProps.put("hw.gpu.enabled", "yes");
        }
        File avdFolder = null;
        try {
            avdFolder = AvdInfo.getDefaultAvdFolder(this.mAvdManager, avdName);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return false;
        }
        hwProps.put("hw.ramSize", this.mWidgets.getText(Ctrl.TEXT_RAM));
        hwProps.put("vm.heapSize", this.mWidgets.getText(Ctrl.TEXT_VM_HEAP));
        switch (this.mWidgets.getComboIndex(Ctrl.COMBO_DATA_PART_SIZE)) {
            case 0: {
                suffix = "M";
                break;
            }
            case 1: {
                suffix = "G";
                break;
            }
            default: {
                suffix = "K";
            }
        }
        hwProps.put("disk.dataPartition.size", this.mWidgets.getText(Ctrl.TEXT_DATA_PART) + suffix);
        hwProps.put("hw.keyboard", this.mWidgets.isChecked(Ctrl.CHECK_KEYBOARD) ? "yes" : "no");
        hwProps.put("skin.dynamic", skinChoice.getType() == SkinType.DYNAMIC ? "yes" : "no");
        if (this.mWidgets.isEnabled(Ctrl.COMBO_FRONT_CAM)) {
            hwProps.put("hw.camera.front", this.mWidgets.getText(Ctrl.COMBO_FRONT_CAM).toLowerCase());
        }
        if (this.mWidgets.isEnabled(Ctrl.COMBO_BACK_CAM)) {
            hwProps.put("hw.camera.back", this.mWidgets.getText(Ctrl.COMBO_BACK_CAM).toLowerCase());
        }
        if (sdName != null) {
            hwProps.put("hw.sdCard", "yes");
        }
        this.mCreatedAvd = avdInfo = this.mAvdManager.createAvd(avdFolder, avdName, target, tag, abiType, skinFolder, skinName, sdName, hwProps, device.getBootProps(), this.mWidgets.isChecked(Ctrl.CHECK_SNAPSHOT), this.mWidgets.isChecked(Ctrl.CHECK_FORCE_CREATION), this.mAvdInfo != null, log);
        boolean bl = success = avdInfo != null;
        if (log instanceof IMessageBoxLogger) {
            ((IMessageBoxLogger)log).displayResult(success);
        }
        return success;
    }

    @Nullable
    private AvdSkinChoice getSelectedSkinChoice() {
        int choiceIndex = this.mWidgets.getComboIndex(Ctrl.COMBO_SKIN);
        if (choiceIndex >= 0 && choiceIndex < this.mComboSkins.size()) {
            return this.mComboSkins.get(choiceIndex);
        }
        return null;
    }

    @Nullable
    private Pair<IdDisplay, String> getSelectedTagAbi() {
        ISystemImage selected = this.getSelectedSysImg();
        if (selected != null) {
            return Pair.of((Object)selected.getTag(), (Object)selected.getAbiType());
        }
        return null;
    }

    @Nullable
    private ISystemImage getSelectedSysImg() {
        int abiIndex;
        if (!this.mComboSystemImages.isEmpty() && (abiIndex = this.mWidgets.getComboIndex(Ctrl.COMBO_TAG_ABI)) >= 0 && abiIndex < this.mComboSystemImages.size()) {
            return this.mComboSystemImages.get(abiIndex);
        }
        return null;
    }

    private void fillExistingAvdInfo(AvdInfo avd) {
        Map<String, String> props;
        this.mWidgets.setText(Ctrl.TEXT_AVD_NAME, avd.getName());
        this.selectDevice(avd.getDeviceManufacturer(), avd.getDeviceName());
        this.toggleCameras();
        IAndroidTarget target = avd.getTarget();
        if (target != null && !this.mCurrentTargets.isEmpty()) {
            int n = this.mWidgets.getComboSize(Ctrl.COMBO_TARGET);
            for (int i = 0; i < n; ++i) {
                if (!target.equals(this.mCurrentTargets.get(this.mWidgets.getComboItem(Ctrl.COMBO_TARGET, i)))) continue;
                this.mWidgets.selectComboIndex(Ctrl.COMBO_TARGET, i);
                this.reloadTagAbiCombo();
                break;
            }
        }
        ISystemImage[] systemImages = this.getSystemImages(target);
        if (target != null && systemImages.length > 0) {
            this.mWidgets.setEnabled(Ctrl.COMBO_TAG_ABI, systemImages.length > 1);
            String abiType = AvdInfo.getPrettyAbiType(avd.getTag(), avd.getAbiType());
            int n = this.mWidgets.getComboSize(Ctrl.COMBO_TAG_ABI);
            for (int i = 0; i < n; ++i) {
                if (!abiType.equals(this.mWidgets.getComboItem(Ctrl.COMBO_TAG_ABI, i))) continue;
                this.mWidgets.selectComboIndex(Ctrl.COMBO_TAG_ABI, i);
                this.reloadSkinCombo();
                break;
            }
        }
        if ((props = avd.getProperties()) != null) {
            String[] values;
            long sdcardSize;
            String cameraBack;
            String cameraFront;
            int i;
            String dataPartitionSize;
            String vmHeapSize;
            String ramSize;
            String gpuEmulation;
            String snapshots = props.get("snapshot.present");
            if (snapshots != null && snapshots.length() > 0) {
                this.mWidgets.setChecked(Ctrl.CHECK_SNAPSHOT, snapshots.equals("true"));
            }
            this.mWidgets.setChecked(Ctrl.CHECK_GPU_EMUL, (gpuEmulation = props.get("hw.gpu.enabled")) != null && gpuEmulation.equals("yes"));
            String sdcard = props.get("sdcard.path");
            if (sdcard != null && sdcard.length() > 0) {
                this.enableSdCardWidgets(false);
                this.mWidgets.setChecked(Ctrl.RADIO_SDCARD_SIZE, false);
                this.mWidgets.setChecked(Ctrl.RADIO_SDCARD_FILE, true);
                this.mWidgets.setText(Ctrl.TEXT_SDCARD_FILE, sdcard);
            }
            if ((ramSize = props.get("hw.ramSize")) != null) {
                this.mWidgets.setText(Ctrl.TEXT_RAM, ramSize);
            }
            if ((vmHeapSize = props.get("vm.heapSize")) != null) {
                this.mWidgets.setText(Ctrl.TEXT_VM_HEAP, vmHeapSize);
            }
            if ((dataPartitionSize = props.get("disk.dataPartition.size")) != null) {
                this.mWidgets.setText(Ctrl.TEXT_DATA_PART, dataPartitionSize.substring(0, dataPartitionSize.length() - 1));
                switch (dataPartitionSize.charAt(dataPartitionSize.length() - 1)) {
                    case 'M': {
                        this.mWidgets.selectComboIndex(Ctrl.COMBO_DATA_PART_SIZE, 0);
                        break;
                    }
                    case 'G': {
                        this.mWidgets.selectComboIndex(Ctrl.COMBO_DATA_PART_SIZE, 1);
                        break;
                    }
                    default: {
                        this.mWidgets.selectComboIndex(Ctrl.COMBO_DATA_PART_SIZE, -1);
                    }
                }
            }
            this.mWidgets.setChecked(Ctrl.CHECK_KEYBOARD, "yes".equalsIgnoreCase(props.get("hw.keyboard")));
            SkinType defaultSkinType = SkinType.NONE;
            String skinIniPath = props.get("skin.path");
            if (skinIniPath != null) {
                File skinFolder = new File(this.mAvdManager.getLocalSdk().getLocation(), skinIniPath);
                for (i = 0; i < this.mComboSkins.size(); ++i) {
                    if (!this.mComboSkins.get(i).hasPath() || !skinFolder.equals(this.mComboSkins.get(i).getPath())) continue;
                    this.mWidgets.selectComboIndex(Ctrl.COMBO_SKIN, i);
                    defaultSkinType = null;
                    break;
                }
            }
            if (defaultSkinType != null) {
                if ("yes".equalsIgnoreCase(props.get("skin.dynamic"))) {
                    defaultSkinType = SkinType.DYNAMIC;
                }
                for (int i2 = 0; i2 < this.mComboSkins.size(); ++i2) {
                    if (this.mComboSkins.get(i2).getType() != defaultSkinType) continue;
                    this.mWidgets.selectComboIndex(Ctrl.COMBO_SKIN, i2);
                    break;
                }
            }
            if ((cameraFront = props.get("hw.camera.front")) != null) {
                int n = this.mWidgets.getComboSize(Ctrl.COMBO_FRONT_CAM);
                for (i = 0; i < n; ++i) {
                    String item = this.mWidgets.getComboItem(Ctrl.COMBO_FRONT_CAM, i);
                    if (!item.toLowerCase().equals(cameraFront)) continue;
                    this.mWidgets.selectComboIndex(Ctrl.COMBO_FRONT_CAM, i);
                    break;
                }
            }
            if ((cameraBack = props.get("hw.camera.back")) != null) {
                int n = this.mWidgets.getComboSize(Ctrl.COMBO_BACK_CAM);
                for (int i3 = 0; i3 < n; ++i3) {
                    String item = this.mWidgets.getComboItem(Ctrl.COMBO_BACK_CAM, i3);
                    if (!item.toLowerCase().equals(cameraBack)) continue;
                    this.mWidgets.selectComboIndex(Ctrl.COMBO_BACK_CAM, i3);
                    break;
                }
            }
            if ((sdcard = props.get("sdcard.size")) != null && sdcard.length() > 0 && (sdcardSize = AvdManager.parseSdcardSize(sdcard, values = new String[2])) != -2L) {
                this.enableSdCardWidgets(true);
                this.mWidgets.setChecked(Ctrl.RADIO_SDCARD_FILE, false);
                this.mWidgets.setChecked(Ctrl.RADIO_SDCARD_SIZE, true);
                this.mWidgets.setText(Ctrl.TEXT_SDCARD_SIZE, values[0]);
                String suffix = values[1];
                int n = this.mWidgets.getComboSize(Ctrl.COMBO_SDCARD_SIZE);
                for (int i4 = 0; i4 < n; ++i4) {
                    if (!this.mWidgets.getComboItem(Ctrl.COMBO_SDCARD_SIZE, i4).startsWith(suffix)) continue;
                    this.mWidgets.selectComboIndex(Ctrl.COMBO_SDCARD_SIZE, i4);
                }
            }
        }
    }

    private void fillInitialDeviceInfo(Device device) {
        String name = device.getManufacturer();
        name = !name.equals(GENERIC) && !name.equals("User") && device.getName().indexOf(name) == -1 ? " by " + name : "";
        name = "AVD for " + device.getName() + name;
        name = name.replaceAll("[^0-9a-zA-Z_-]+", " ").trim().replaceAll("[ _]+", "_");
        this.mWidgets.setText(Ctrl.TEXT_AVD_NAME, name);
        this.selectDevice(device);
        this.toggleCameras();
        if (this.mWidgets.getComboSize(Ctrl.COMBO_TARGET) == 1) {
            this.mWidgets.selectComboIndex(Ctrl.COMBO_TARGET, 0);
            this.reloadTagAbiCombo();
        }
        this.fillDeviceProperties(device);
    }

    @NonNull
    private ISystemImage[] getSystemImages(IAndroidTarget target) {
        if (target != null) {
            ISystemImage[] images = target.getSystemImages();
            if (images != null && images.length != 0 || !target.isPlatform()) {
                // empty if block
            }
            if (images != null) {
                return images;
            }
        }
        return new ISystemImage[0];
    }

    private static int nexusRank(Device device) {
        String name = device.getName();
        if (name.endsWith(" One")) {
            return 1;
        }
        if (name.endsWith(" S")) {
            return 2;
        }
        if (name.startsWith("Galaxy")) {
            return 3;
        }
        if (name.endsWith(" 7")) {
            return 4;
        }
        if (name.endsWith(" 10")) {
            return 5;
        }
        if (name.endsWith(" 4")) {
            return 6;
        }
        return 7;
    }

    private static boolean isGeneric(Device device) {
        return device.getManufacturer().equals(GENERIC);
    }

    private static boolean isNexus(Device device) {
        return device.getName().contains(NEXUS);
    }

    private static String getGenericLabel(Device d) {
        Matcher matcher;
        String name = d.getName();
        if (name.equals("3.7 FWVGA slider")) {
            name = "3.7in FWVGA slider";
        }
        if ((matcher = PATTERN.matcher(name)).matches()) {
            String size = matcher.group(1);
            String n = matcher.group(2);
            int dot = size.indexOf(46);
            if (dot == -1) {
                size = size + ".0";
                dot = size.length() - 2;
            }
            for (int i = 0; i < 2 - dot; ++i) {
                size = ' ' + size;
            }
            name = size + "\" " + n;
        }
        return String.format(Locale.US, "%1$s (%2$s)", name, AvdCreationPresenter.getResolutionString(d));
    }

    private static String getNexusLabel(Device d) {
        String name = d.getName();
        Screen screen = d.getDefaultHardware().getScreen();
        float length = (float)screen.getDiagonalLength();
        return String.format(Locale.US, "%1$s (%3$s\", %2$s)", name, AvdCreationPresenter.getResolutionString(d), Float.toString(length));
    }

    @Nullable
    private static String getResolutionString(Device device) {
        Screen screen = device.getDefaultHardware().getScreen();
        return String.format(Locale.US, "%1$d \u00d7 %2$d: %3$s", screen.getXDimension(), screen.getYDimension(), screen.getPixelDensity().getResourceValue());
    }

    public void onTargetComboChanged() {
        this.reloadTagAbiCombo();
        this.validatePage();
    }

    public void onTagComboChanged() {
        this.reloadSkinCombo();
        this.validatePage();
    }

    public void onRadioSdCardSizeChanged() {
        boolean sizeMode = this.mWidgets.isChecked(Ctrl.RADIO_SDCARD_SIZE);
        this.enableSdCardWidgets(sizeMode);
        this.validatePage();
    }

    private static class AvdSkinChoice
    implements Comparable<AvdSkinChoice> {
        private final SkinType mType;
        private final String mLabel;
        private final File mPath;

        AvdSkinChoice(@NonNull SkinType type, @NonNull String label) {
            this(type, label, null);
        }

        AvdSkinChoice(@NonNull SkinType type, @NonNull String label, @NonNull File path) {
            this.mType = type;
            this.mLabel = label;
            this.mPath = path;
        }

        @NonNull
        public SkinType getType() {
            return this.mType;
        }

        @NonNull
        public String getLabel() {
            return this.mLabel;
        }

        @Nullable
        public File getPath() {
            return this.mPath;
        }

        public boolean hasPath() {
            return this.mType == SkinType.FROM_TARGET;
        }

        @Override
        public int compareTo(AvdSkinChoice o) {
            int t = this.mType.compareTo(o.mType);
            if (t == 0) {
                t = this.mLabel.compareTo(o.mLabel);
            }
            if (t == 0 && this.mPath != null && o.mPath != null) {
                t = this.mPath.compareTo(o.mPath);
            }
            return t;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
            result = 31 * result + (this.mLabel == null ? 0 : this.mLabel.hashCode());
            result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AvdSkinChoice)) {
                return false;
            }
            AvdSkinChoice other = (AvdSkinChoice)obj;
            if (this.mType != other.mType) {
                return false;
            }
            if (this.mLabel == null ? other.mLabel != null : !this.mLabel.equals(other.mLabel)) {
                return false;
            }
            return !(this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath));
        }
    }

    private static enum SkinType {
        DYNAMIC,
        NONE,
        FROM_TARGET;

    }

    public static interface IWidgetAdapter {
        public void setTitle(@NonNull String var1);

        public int getComboIndex(@NonNull Ctrl var1);

        public int getComboSize(@NonNull Ctrl var1);

        public void selectComboIndex(@NonNull Ctrl var1, int var2);

        public String getComboItem(@NonNull Ctrl var1, int var2);

        public void addComboItem(@NonNull Ctrl var1, String var2);

        public void setComboItems(@NonNull Ctrl var1, @Nullable String[] var2);

        public boolean isEnabled(@NonNull Ctrl var1);

        public void setEnabled(@NonNull Ctrl var1, boolean var2);

        public boolean isChecked(@NonNull Ctrl var1);

        public void setChecked(@NonNull Ctrl var1, boolean var2);

        public String getText(@NonNull Ctrl var1);

        public void setText(@NonNull Ctrl var1, String var2);

        public void setImage(@NonNull Ctrl var1, @Nullable String var2);

        public String openFileDialog(@NonNull String var1);

        public void repack();

        public IMessageBoxLogger newDelayedMessageBoxLog(String var1, boolean var2);
    }

    public static enum Ctrl {
        BUTTON_OK,
        BUTTON_BROWSE_SDCARD,
        COMBO_DEVICE,
        COMBO_TARGET,
        COMBO_TAG_ABI,
        COMBO_SKIN,
        COMBO_FRONT_CAM,
        COMBO_BACK_CAM,
        COMBO_DATA_PART_SIZE,
        COMBO_SDCARD_SIZE,
        CHECK_FORCE_CREATION,
        CHECK_KEYBOARD,
        CHECK_SNAPSHOT,
        CHECK_GPU_EMUL,
        RADIO_SDCARD_SIZE,
        RADIO_SDCARD_FILE,
        TEXT_AVD_NAME,
        TEXT_RAM,
        TEXT_VM_HEAP,
        TEXT_DATA_PART,
        TEXT_SDCARD_SIZE,
        TEXT_SDCARD_FILE,
        ICON_STATUS,
        TEXT_STATUS;

    }
}

