/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.internal.build.SymbolLoader;
import com.android.sdklib.internal.build.SymbolWriter;
import com.android.xml.AndroidXPathFactory;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

public final class AaptExecTask
extends SingleDependencyTask {
    private String mExecutable;
    private String mCommand;
    private boolean mForce = true;
    private boolean mDebug = false;
    private boolean mVerbose = false;
    private boolean mUseCrunchCache = false;
    private int mVersionCode = 0;
    private String mVersionName;
    private String mManifestFile;
    private String mManifestPackage;
    private String mOriginalManifestPackage;
    private ArrayList<Path> mResources;
    private String mAssets;
    private String mAndroidJar;
    private String mApkFolder;
    private String mApkName;
    private String mResourceFilter;
    private String mRFolder;
    private final ArrayList<NoCompress> mNoCompressList = new ArrayList();
    private String mLibraryResFolderPathRefid;
    private String mLibraryPackagesRefid;
    private String mLibraryRFileRefid;
    private boolean mNonConstantId;
    private String mIgnoreAssets;
    private String mBinFolder;
    private String mProguardFile;
    private static final SingleDependencyTask.InputPathFactory sPathFactory = new SingleDependencyTask.InputPathFactory(){

        @Override
        public InputPath createPath(File file, Set<String> extensionsToCheck) {
            return new ResFolderInputPath(file, extensionsToCheck);
        }
    };

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setCommand(String command) {
        this.mCommand = command;
    }

    public void setForce(boolean force) {
        this.mForce = force;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setNoCrunch(boolean usecrunch) {
        this.mUseCrunchCache = usecrunch;
    }

    public void setNonConstantId(boolean nonConstantId) {
        this.mNonConstantId = nonConstantId;
    }

    public void setIgnoreAssets(String ignoreAssets) {
        this.mIgnoreAssets = ignoreAssets;
    }

    public void setVersioncode(String versionCode) {
        if (versionCode.length() > 0) {
            try {
                this.mVersionCode = Integer.decode(versionCode);
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("WARNING: Ignoring invalid version code value '%s'.", versionCode));
            }
        }
    }

    public void setVersionname(String versionName) {
        this.mVersionName = versionName;
    }

    public void setDebug(boolean value) {
        this.mDebug = value;
    }

    public void setManifest(Path manifest) {
        this.mManifestFile = TaskHelper.checkSinglePath("manifest", manifest);
    }

    public void setManifestpackage(String packageName) {
        if (packageName != null && packageName.length() != 0) {
            this.mManifestPackage = packageName;
        }
    }

    public void setOriginalManifestPackage(String packageName) {
        this.mOriginalManifestPackage = packageName;
    }

    @Deprecated
    public void setResources(Path resources) {
        System.out.println("WARNNG: Using deprecated 'resources' attribute in AaptExecLoopTask.Use nested element(s) <res path=\"value\" /> instead.");
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        this.mResources.add(new Path(this.getProject(), resources.toString()));
    }

    public void setAssets(Path assets) {
        this.mAssets = TaskHelper.checkSinglePath("assets", assets);
    }

    public void setAndroidjar(Path androidJar) {
        this.mAndroidJar = TaskHelper.checkSinglePath("androidjar", androidJar);
    }

    @Deprecated
    public void setOutfolder(Path outFolder) {
        System.out.println("WARNNG: Using deprecated 'outfolder' attribute in AaptExecLoopTask.Use 'apkfolder' (path) instead.");
        this.mApkFolder = TaskHelper.checkSinglePath("outfolder", outFolder);
    }

    public void setApkfolder(Path apkFolder) {
        this.mApkFolder = TaskHelper.checkSinglePath("apkfolder", apkFolder);
    }

    public void setResourcefilename(String apkName) {
        this.mApkName = apkName;
    }

    public void setRfolder(Path rFolder) {
        this.mRFolder = TaskHelper.checkSinglePath("rfolder", rFolder);
    }

    public void setresourcefilter(String filter) {
        if (filter != null && filter.length() > 0) {
            this.mResourceFilter = filter;
        }
    }

    public void setLibraryResFolderPathRefid(String libraryResFolderPathRefid) {
        this.mLibraryResFolderPathRefid = libraryResFolderPathRefid;
    }

    public void setLibraryPackagesRefid(String libraryPackagesRefid) {
        this.mLibraryPackagesRefid = libraryPackagesRefid;
    }

    public void setLibraryRFileRefid(String libraryRFileRefid) {
        this.mLibraryRFileRefid = libraryRFileRefid;
    }

    public void setBinFolder(Path binFolder) {
        this.mBinFolder = TaskHelper.checkSinglePath("binFolder", binFolder);
    }

    public void setProguardFile(Path proguardFile) {
        this.mProguardFile = TaskHelper.checkSinglePath("proguardFile", proguardFile);
    }

    public Object createNocompress() {
        NoCompress nc = new NoCompress();
        this.mNoCompressList.add(nc);
        return nc;
    }

    public Object createRes() {
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        Path path = new Path(this.getProject());
        this.mResources.add(path);
        return path;
    }

    @Override
    protected String getExecTaskName() {
        return "aapt";
    }

    public void execute() throws BuildException {
        List<InputPath> inputPaths;
        if (this.mLibraryResFolderPathRefid == null) {
            throw new BuildException("Missing attribute libraryResFolderPathRefid");
        }
        if (this.mLibraryPackagesRefid == null) {
            throw new BuildException("Missing attribute libraryPackagesRefid");
        }
        if (this.mLibraryRFileRefid == null) {
            throw new BuildException("Missing attribute libraryRFileRefid");
        }
        Project taskProject = this.getProject();
        String libPkgProp = null;
        Path libRFileProp = null;
        if (!this.mNonConstantId && this.mRFolder != null && new File(this.mRFolder).isDirectory()) {
            libPkgProp = taskProject.getProperty(this.mLibraryPackagesRefid);
            Object rFilePath = taskProject.getReference(this.mLibraryRFileRefid);
            if ((libPkgProp == null || rFilePath == null) && rFilePath != libPkgProp) {
                throw new BuildException(String.format("Both %1$s and %2$s should resolve to valid values.", this.mLibraryPackagesRefid, this.mLibraryRFileRefid));
            }
            if (rFilePath instanceof Path) {
                libRFileProp = (Path)rFilePath;
            } else if (rFilePath != null) {
                throw new BuildException("attribute libraryRFileRefid must reference a Path object.");
            }
        }
        boolean generateRClass = this.mRFolder != null && new File(this.mRFolder).isDirectory();
        Object libResRef = taskProject.getReference(this.mLibraryResFolderPathRefid);
        ArrayList<File> paths = new ArrayList<File>();
        for (Path pathList : this.mResources) {
            for (String path : pathList.list()) {
                paths.add(new File(path));
            }
        }
        if (libResRef instanceof Path) {
            for (String path : ((Path)libResRef).list()) {
                paths.add(new File(path));
            }
        }
        if (generateRClass) {
            inputPaths = AaptExecTask.getInputPaths(paths, Collections.singleton("xml"), sPathFactory);
            if (this.mManifestFile != null) {
                inputPaths.add(new InputPath(new File(this.mManifestFile)));
            }
            if (this.initDependencies(this.mRFolder + File.separator + "R.java.d", inputPaths) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources. R.java and Manifest.java untouched.");
                return;
            }
            System.out.println("Generating resource IDs...");
        } else {
            File assetsDir;
            inputPaths = AaptExecTask.getInputPaths(paths, null, sPathFactory);
            if (this.mManifestFile != null) {
                inputPaths.add(new InputPath(new File(this.mManifestFile)));
            }
            if (this.mAssets != null && (assetsDir = new File(this.mAssets)).isDirectory()) {
                inputPaths.add(new InputPath(assetsDir));
            }
            String dependencyFilePath = this.mApkFolder + File.separator + this.mApkName;
            if (this.initDependencies(dependencyFilePath = dependencyFilePath + ".d", inputPaths) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources or assets. " + this.mApkName + " remains untouched");
                return;
            }
            if (this.mResourceFilter == null) {
                System.out.println("Creating full resource package...");
            } else {
                System.out.println(String.format("Creating resource package with filter: (%1$s)...", this.mResourceFilter));
            }
        }
        ExecTask task = new ExecTask();
        task.setExecutable(this.mExecutable);
        task.setFailonerror(true);
        task.setTaskName(this.getExecTaskName());
        task.createArg().setValue(this.mCommand);
        if (this.mUseCrunchCache) {
            task.createArg().setValue("--no-crunch");
        }
        if (this.mNonConstantId) {
            task.createArg().setValue("--non-constant-id");
        }
        if (this.mForce) {
            task.createArg().setValue("-f");
        }
        if (this.mVerbose) {
            task.createArg().setValue("-v");
        }
        if (this.mDebug) {
            task.createArg().setValue("--debug-mode");
        }
        if (generateRClass) {
            task.createArg().setValue("-m");
        }
        if (this.mResourceFilter != null && this.mResourceFilter.length() > 0) {
            task.createArg().setValue("-c");
            task.createArg().setValue(this.mResourceFilter);
        }
        boolean compressNothing = false;
        for (NoCompress nc : this.mNoCompressList) {
            if (nc.mExtension != null) continue;
            task.createArg().setValue("-0");
            task.createArg().setValue("");
            compressNothing = true;
            break;
        }
        task.createArg().setValue("-0");
        task.createArg().setValue("apk");
        if (!compressNothing) {
            for (NoCompress nc : this.mNoCompressList) {
                task.createArg().setValue("-0");
                task.createArg().setValue(nc.mExtension);
            }
        }
        if (this.mNonConstantId || libPkgProp != null && libPkgProp.length() > 0) {
            if (this.mBinFolder == null) {
                throw new BuildException("Missing attribute binFolder when compiling libraries or projects with libraries.");
            }
            task.createArg().setValue("--output-text-symbols");
            task.createArg().setValue(this.mBinFolder);
        }
        if (libResRef != null) {
            task.createArg().setValue("--auto-add-overlay");
        }
        if (this.mVersionCode != 0) {
            task.createArg().setValue("--version-code");
            task.createArg().setValue(Integer.toString(this.mVersionCode));
        }
        if (this.mVersionName != null && this.mVersionName.length() > 0) {
            task.createArg().setValue("--version-name");
            task.createArg().setValue(this.mVersionName);
        }
        if (this.mManifestFile != null && this.mManifestFile.length() > 0) {
            task.createArg().setValue("-M");
            task.createArg().setValue(this.mManifestFile);
        }
        if (this.mManifestPackage != null) {
            task.createArg().setValue("--rename-manifest-package");
            task.createArg().setValue(this.mManifestPackage);
        }
        if (this.mResources.size() > 0) {
            for (Path pathList : this.mResources) {
                for (String path : pathList.list()) {
                    File res = new File(path);
                    if (!res.isDirectory()) continue;
                    task.createArg().setValue("-S");
                    task.createArg().setValue(path);
                }
            }
        }
        if (libResRef instanceof Path) {
            for (String path : ((Path)libResRef).list()) {
                File res = new File(path);
                if (!res.isDirectory()) continue;
                task.createArg().setValue("-S");
                task.createArg().setValue(path);
            }
        }
        if (this.mAssets != null && new File(this.mAssets).isDirectory()) {
            task.createArg().setValue("-A");
            task.createArg().setValue(this.mAssets);
        }
        if (this.mAndroidJar != null) {
            task.createArg().setValue("-I");
            task.createArg().setValue(this.mAndroidJar);
        }
        String filename = null;
        if (this.mApkName != null) {
            filename = this.mApkName;
        }
        if (filename != null) {
            File file = new File(this.mApkFolder, filename);
            task.createArg().setValue("-F");
            task.createArg().setValue(file.getAbsolutePath());
        }
        if (generateRClass) {
            task.createArg().setValue("-J");
            task.createArg().setValue(this.mRFolder);
        }
        if (this.mIgnoreAssets != null && this.mIgnoreAssets.length() > 0) {
            task.createArg().setValue("--ignore-assets");
            task.createArg().setValue(this.mIgnoreAssets);
        }
        task.createArg().setValue("--generate-dependencies");
        if (this.mProguardFile != null && this.mProguardFile.length() > 0) {
            task.createArg().setValue("-G");
            task.createArg().setValue(this.mProguardFile);
        }
        task.setProject(taskProject);
        task.setOwningTarget(this.getOwningTarget());
        task.execute();
        try {
            File rFile;
            if (!this.mNonConstantId && libPkgProp != null && !libPkgProp.isEmpty() && (rFile = new File(this.mBinFolder, "R.txt")).isFile()) {
                String[] rFiles;
                String[] packages;
                SymbolLoader fullSymbolValues = new SymbolLoader(rFile);
                fullSymbolValues.load();
                if (libPkgProp.startsWith(";")) {
                    libPkgProp = libPkgProp.substring(1).trim();
                }
                if ((packages = libPkgProp.split(";")).length != (rFiles = libRFileProp.list()).length) {
                    throw new BuildException(String.format("%1$s and %2$s must contain the same number of items.", this.mLibraryPackagesRefid, this.mLibraryRFileRefid));
                }
                if (this.mOriginalManifestPackage == null) {
                    this.mOriginalManifestPackage = this.getPackageName(this.mManifestFile);
                }
                ArrayListMultimap libMap = ArrayListMultimap.create();
                for (int i = 0; i < packages.length; ++i) {
                    File rText;
                    String libPackage = packages[i];
                    if (this.mOriginalManifestPackage.equals(libPackage) || !(rText = new File(rFiles[i])).isFile()) continue;
                    SymbolLoader libSymbols = new SymbolLoader(rText);
                    libSymbols.load();
                    libMap.put((Object)libPackage, (Object)libSymbols);
                }
                for (String packageName : libMap.keySet()) {
                    Collection symbols = libMap.get((Object)packageName);
                    SymbolWriter writer = new SymbolWriter(this.mRFolder, packageName, fullSymbolValues);
                    for (SymbolLoader symbolLoader : symbols) {
                        writer.addSymbolsToWrite(symbolLoader);
                    }
                    writer.write();
                }
            }
        }
        catch (Exception e) {
            File f = new File(this.mRFolder, "R.java.d");
            f.delete();
            throw e instanceof BuildException ? (BuildException)e : new BuildException((Throwable)e);
        }
    }

    private String getPackageName(String manifest) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            String s = xpath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifest)));
            return s;
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static class ResFolderInputPath
    extends InputPath {
        public ResFolderInputPath(File file, Set<String> extensionsToCheck) {
            super(file, extensionsToCheck);
        }

        @Override
        public boolean ignores(File file) {
            String name = file.getName();
            char firstChar = name.charAt(0);
            if (firstChar == '.' || firstChar == '_' && file.isDirectory() || name.charAt(name.length() - 1) == '~') {
                return true;
            }
            if ("CVS".equals(name) || "thumbs.db".equalsIgnoreCase(name) || "picasa.ini".equalsIgnoreCase(name)) {
                return true;
            }
            String ext = ResFolderInputPath.getExtension(name);
            return "scc".equalsIgnoreCase(ext);
        }
    }

    public static final class NoCompress {
        String mExtension;

        public void setExtension(String extention) {
            this.mExtension = extention;
        }
    }
}

