/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.ant.BuildTypedTask;
import com.android.ant.DependencyGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

class MultiFilesTask
extends BuildTypedTask {
    MultiFilesTask() {
    }

    protected void processFiles(SourceProcessor processor, List<Path> paths, String genFolder) {
        Project taskProject = this.getProject();
        Set<String> extensions = processor.getSourceFileExtensions();
        ArrayList<String> sourceFolders = new ArrayList<String>();
        for (Path p : paths) {
            String[] values = p.list();
            if (values == null) continue;
            sourceFolders.addAll(Arrays.asList(values));
        }
        ArrayList<String> includePatterns = new ArrayList<String>(extensions.size());
        for (String extension : extensions) {
            includePatterns.add("**/*." + extension);
        }
        Map<String, String> sourceFiles = this.getFilesByNameEntryFilter(sourceFolders, includePatterns.toArray(new String[includePatterns.size()]));
        if (!sourceFiles.isEmpty()) {
            processor.displayMessage(DisplayType.FOUND, sourceFiles.size());
        }
        Iterator<?> depFiles = this.getFilesByNameEntryFilter(genFolder, "**/*.d");
        HashMap<String, String> toCompile = new HashMap<String, String>();
        ArrayList<File> toRemove = new ArrayList<File>();
        ArrayList<String> depsToRemove = new ArrayList<String>();
        while (depFiles.hasNext()) {
            String depFile = depFiles.next().toString();
            DependencyGraph graph = new DependencyGraph(depFile, null);
            File sourceFile = graph.getFirstPrereq();
            String sourceFilePath = sourceFile.getAbsolutePath();
            String fileExtension = sourceFilePath.substring(sourceFilePath.lastIndexOf(46) + 1);
            if (!extensions.contains(fileExtension.toLowerCase(Locale.US))) continue;
            String sourceFolder = sourceFiles.get(sourceFilePath);
            if (sourceFolder == null) {
                Set<File> outputFiles = graph.getTargets();
                toRemove.addAll(outputFiles);
                depsToRemove.add(depFile);
                continue;
            }
            sourceFiles.remove(sourceFilePath);
            if (!this.hasBuildTypeChanged() && !graph.dependenciesHaveChanged(false)) continue;
            toCompile.put(sourceFilePath, sourceFolder);
        }
        toCompile.putAll(sourceFiles);
        processor.displayMessage(DisplayType.COMPILING, toCompile.size());
        if (!toCompile.isEmpty()) {
            for (Map.Entry toCompilePath : toCompile.entrySet()) {
                processor.process((String)toCompilePath.getKey(), (String)toCompilePath.getValue(), sourceFolders, taskProject);
            }
        }
        if (!toRemove.isEmpty()) {
            processor.displayMessage(DisplayType.REMOVE_OUTPUT, toRemove.size());
            for (File toRemoveFile : toRemove) {
                processor.removedOutput(toRemoveFile);
                if (toRemoveFile.delete()) continue;
                System.err.println("Failed to remove " + toRemoveFile.getAbsolutePath());
            }
        }
        if (!depsToRemove.isEmpty()) {
            processor.displayMessage(DisplayType.REMOVE_DEP, toRemove.size());
            for (String path : depsToRemove) {
                if (new File(path).delete()) continue;
                System.err.println("Failed to remove " + path);
            }
        }
    }

    private Map<String, String> getFilesByNameEntryFilter(List<String> folders, String[] filters) {
        HashMap<String, String> sourceFiles = new HashMap<String, String>();
        for (String folder : folders) {
            Iterator<?> iterator = this.getFilesByNameEntryFilter(folder, filters);
            while (iterator.hasNext()) {
                sourceFiles.put(iterator.next().toString(), folder);
            }
        }
        return sourceFiles;
    }

    private Iterator<?> getFilesByNameEntryFilter(String folder, String ... filters) {
        Project taskProject = this.getProject();
        FileSet fs = new FileSet();
        fs.setProject(taskProject);
        fs.setDir(new File(folder));
        for (String filter : filters) {
            PatternSet.NameEntry include = fs.createInclude();
            include.setName(filter);
        }
        return fs.iterator();
    }

    static interface SourceProcessor {
        @NonNull
        public Set<String> getSourceFileExtensions();

        public void process(@NonNull String var1, @NonNull String var2, @NonNull List<String> var3, @NonNull Project var4);

        public void displayMessage(@NonNull DisplayType var1, int var2);

        public void removedOutput(@NonNull File var1);
    }

    static enum DisplayType {
        FOUND,
        COMPILING,
        REMOVE_OUTPUT,
        REMOVE_DEP;

    }
}

