/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.util;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.ReadOnlyException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileDisk
implements BlockDevice {
    public static final int BYTES_PER_SECTOR = 512;
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private final boolean readOnly;
    private boolean closed;

    public FileDisk(File file, boolean readOnly) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.readOnly = readOnly;
        this.closed = false;
        String modeString = readOnly ? "r" : "rw";
        this.raf = new RandomAccessFile(file, modeString);
        this.fc = this.raf.getChannel();
    }

    public FileDisk(RandomAccessFile raf, FileChannel fc, boolean readOnly) {
        this.closed = false;
        this.raf = raf;
        this.fc = fc;
        this.readOnly = readOnly;
    }

    private FileDisk(RandomAccessFile raf, boolean readOnly) {
        this.closed = false;
        this.raf = raf;
        this.fc = raf.getChannel();
        this.readOnly = readOnly;
    }

    public static FileDisk create(File file, long size) throws IOException {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.setLength(size);
            return new FileDisk(raf, false);
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public long getSize() throws IOException {
        this.checkClosed();
        return this.raf.length();
    }

    @Override
    public void read(long devOffset, ByteBuffer dest) throws IOException {
        this.checkClosed();
        int toRead = dest.remaining();
        if (devOffset + (long)toRead > this.getSize()) {
            throw new IOException("reading past end of device");
        }
        while (toRead > 0) {
            int read = this.fc.read(dest, devOffset);
            if (read < 0) {
                throw new IOException();
            }
            toRead -= read;
            devOffset += (long)read;
        }
    }

    @Override
    public void write(long devOffset, ByteBuffer src) throws IOException {
        this.checkClosed();
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        int toWrite = src.remaining();
        if (devOffset + (long)toWrite > this.getSize()) {
            throw new IOException("writing past end of file");
        }
        while (toWrite > 0) {
            int written = this.fc.write(src, devOffset);
            if (written < 0) {
                throw new IOException();
            }
            toWrite -= written;
            devOffset += (long)written;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public int getSectorSize() {
        this.checkClosed();
        return 512;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.fc.close();
        this.raf.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("device already closed");
        }
    }

    @Override
    public boolean isReadOnly() {
        this.checkClosed();
        return this.readOnly;
    }
}

