/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.python.apache.xerces.xni.parser.XMLComponentManager;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected ArrayList fRecognizedProperties;
    protected HashMap fProperties;
    protected ArrayList fRecognizedFeatures = new ArrayList();
    protected HashMap fFeatures;
    protected XMLComponentManager fParentSettings;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager xMLComponentManager) {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
        this.fParentSettings = xMLComponentManager;
    }

    public void addRecognizedFeatures(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!this.fRecognizedFeatures.contains(string2)) {
                this.fRecognizedFeatures.add(string2);
            }
            ++n2;
        }
    }

    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        this.checkFeature(string2);
        this.fFeatures.put(string2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!this.fRecognizedProperties.contains(string2)) {
                this.fRecognizedProperties.add(string2);
            }
            ++n2;
        }
    }

    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        this.checkProperty(string2);
        this.fProperties.put(string2, object);
    }

    public boolean getFeature(String string2) throws XMLConfigurationException {
        Boolean bl = (Boolean)this.fFeatures.get(string2);
        if (bl == null) {
            this.checkFeature(string2);
            return false;
        }
        return bl;
    }

    public Object getProperty(String string2) throws XMLConfigurationException {
        Object v = this.fProperties.get(string2);
        if (v == null) {
            this.checkProperty(string2);
        }
        return v;
    }

    protected void checkFeature(String string2) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string2)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getFeature(string2);
            } else {
                short s = 0;
                throw new XMLConfigurationException(s, string2);
            }
        }
    }

    protected void checkProperty(String string2) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string2)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getProperty(string2);
            } else {
                short s = 0;
                throw new XMLConfigurationException(s, string2);
            }
        }
    }
}

