/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;

public class ArrayAccess
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode operand = null;
    private AbstractNode indexExpression = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astOperand() {
        if (!(this.operand instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.operand);
    }

    public ArrayAccess astOperand(Expression operand) {
        if (operand == null) {
            throw new NullPointerException("operand is mandatory");
        }
        return this.rawOperand(operand);
    }

    public Node rawOperand() {
        return this.operand;
    }

    public ArrayAccess rawOperand(Node operand) {
        if (operand == this.operand) {
            return this;
        }
        if (operand != null) {
            this.adopt((AbstractNode)operand);
        }
        if (this.operand != null) {
            this.disown(this.operand);
        }
        this.operand = (AbstractNode)operand;
        return this;
    }

    public Expression astIndexExpression() {
        if (!(this.indexExpression instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.indexExpression);
    }

    public ArrayAccess astIndexExpression(Expression indexExpression) {
        if (indexExpression == null) {
            throw new NullPointerException("indexExpression is mandatory");
        }
        return this.rawIndexExpression(indexExpression);
    }

    public Node rawIndexExpression() {
        return this.indexExpression;
    }

    public ArrayAccess rawIndexExpression(Node indexExpression) {
        if (indexExpression == this.indexExpression) {
            return this;
        }
        if (indexExpression != null) {
            this.adopt((AbstractNode)indexExpression);
        }
        if (this.indexExpression != null) {
            this.disown(this.indexExpression);
        }
        this.indexExpression = (AbstractNode)indexExpression;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.operand != null) {
            result.add(this.operand);
        }
        if (this.indexExpression != null) {
            result.add(this.indexExpression);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.operand == original) {
            this.rawOperand(replacement);
            return true;
        }
        if (this.indexExpression == original) {
            this.rawIndexExpression(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.operand == child) {
            this.disown((AbstractNode)child);
            this.operand = null;
            return true;
        }
        if (this.indexExpression == child) {
            this.disown((AbstractNode)child);
            this.indexExpression = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitArrayAccess(this)) {
            return;
        }
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        if (this.indexExpression != null) {
            this.indexExpression.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ArrayAccess copy() {
        ArrayAccess result = new ArrayAccess();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.operand != null) {
            result.rawOperand(this.operand.copy());
        }
        if (this.indexExpression != null) {
            result.rawIndexExpression(this.indexExpression.copy());
        }
        return result;
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

