/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Assert
extends AbstractNode
implements Statement {
    private AbstractNode assertion = null;
    private AbstractNode message = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astAssertion() {
        if (!(this.assertion instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.assertion);
    }

    public Assert astAssertion(Expression assertion) {
        if (assertion == null) {
            throw new NullPointerException("assertion is mandatory");
        }
        return this.rawAssertion(assertion);
    }

    public Node rawAssertion() {
        return this.assertion;
    }

    public Assert rawAssertion(Node assertion) {
        if (assertion == this.assertion) {
            return this;
        }
        if (assertion != null) {
            this.adopt((AbstractNode)assertion);
        }
        if (this.assertion != null) {
            this.disown(this.assertion);
        }
        this.assertion = (AbstractNode)assertion;
        return this;
    }

    public Expression astMessage() {
        if (!(this.message instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.message);
    }

    public Assert astMessage(Expression message) {
        return this.rawMessage(message);
    }

    public Node rawMessage() {
        return this.message;
    }

    public Assert rawMessage(Node message) {
        if (message == this.message) {
            return this;
        }
        if (message != null) {
            this.adopt((AbstractNode)message);
        }
        if (this.message != null) {
            this.disown(this.message);
        }
        this.message = (AbstractNode)message;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.assertion != null) {
            result.add(this.assertion);
        }
        if (this.message != null) {
            result.add(this.message);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.assertion == original) {
            this.rawAssertion(replacement);
            return true;
        }
        if (this.message == original) {
            this.rawMessage(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.assertion == child) {
            this.disown((AbstractNode)child);
            this.assertion = null;
            return true;
        }
        if (this.message == child) {
            this.disown((AbstractNode)child);
            this.message = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAssert(this)) {
            return;
        }
        if (this.assertion != null) {
            this.assertion.accept(visitor);
        }
        if (this.message != null) {
            this.message.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Assert copy() {
        Assert result = new Assert();
        if (this.assertion != null) {
            result.rawAssertion(this.assertion.copy());
        }
        if (this.message != null) {
            result.rawMessage(this.message.copy());
        }
        return result;
    }
}

