/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.chimpchat.ChimpChat;
import com.android.monkeyrunner.MonkeyFormatter;
import com.android.monkeyrunner.MonkeyRunner;
import com.android.monkeyrunner.MonkeyRunnerOptions;
import com.android.monkeyrunner.ScriptRunner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.python.util.PythonInterpreter;

public class MonkeyRunnerStarter {
    private static final Logger LOG = Logger.getLogger(MonkeyRunnerStarter.class.getName());
    private static final String MONKEY_RUNNER_MAIN_MANIFEST_NAME = "MonkeyRunnerStartupRunner";
    private final ChimpChat chimp;
    private final MonkeyRunnerOptions options;

    public MonkeyRunnerStarter(MonkeyRunnerOptions options) {
        TreeMap<String, String> chimp_options = new TreeMap<String, String>();
        chimp_options.put("backend", options.getBackendName());
        this.options = options;
        this.chimp = ChimpChat.getInstance(chimp_options);
        MonkeyRunner.setChimpChat(this.chimp);
    }

    private int run() {
        String monkeyRunnerPath = System.getProperty("com.android.monkeyrunner.bindir") + File.separator + "monkeyrunner";
        Map<String, Predicate<PythonInterpreter>> plugins = this.handlePlugins();
        if (this.options.getScriptFile() == null) {
            ScriptRunner.console(monkeyRunnerPath);
            this.chimp.shutdown();
            return 0;
        }
        int error = ScriptRunner.run(monkeyRunnerPath, this.options.getScriptFile().getAbsolutePath(), this.options.getArguments(), plugins);
        this.chimp.shutdown();
        return error;
    }

    private Predicate<PythonInterpreter> handlePlugin(File f) {
        Object loadedObject;
        Class<?> clz;
        URL url;
        Manifest manifest;
        JarFile jarFile;
        try {
            jarFile = new JarFile(f);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to open plugin file.  Is it a jar file? " + f.getAbsolutePath(), e);
            return Predicates.alwaysFalse();
        }
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to get manifest file from jar: " + f.getAbsolutePath(), e);
            return Predicates.alwaysFalse();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String pluginClass = mainAttributes.getValue(MONKEY_RUNNER_MAIN_MANIFEST_NAME);
        if (pluginClass == null) {
            return Predicates.alwaysTrue();
        }
        try {
            url = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, "Unable to convert file to url " + f.getAbsolutePath(), e);
            return Predicates.alwaysFalse();
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
        try {
            clz = Class.forName(pluginClass, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "Unable to load the specified plugin: " + pluginClass, e);
            return Predicates.alwaysFalse();
        }
        try {
            loadedObject = clz.newInstance();
        }
        catch (InstantiationException e) {
            LOG.log(Level.SEVERE, "Unable to load the specified plugin: " + pluginClass, e);
            return Predicates.alwaysFalse();
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.SEVERE, "Unable to load the specified plugin (did you make it public?): " + pluginClass, e);
            return Predicates.alwaysFalse();
        }
        if (loadedObject instanceof Runnable) {
            final Runnable run = (Runnable)loadedObject;
            return new Predicate<PythonInterpreter>(){

                public boolean apply(PythonInterpreter i) {
                    run.run();
                    return true;
                }
            };
        }
        if (loadedObject instanceof Predicate) {
            return (Predicate)loadedObject;
        }
        LOG.severe("Unable to coerce object into correct type: " + pluginClass);
        return Predicates.alwaysFalse();
    }

    private Map<String, Predicate<PythonInterpreter>> handlePlugins() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File f : this.options.getPlugins()) {
            builder.put((Object)f.getAbsolutePath(), this.handlePlugin(f));
        }
        return builder.build();
    }

    private static final void replaceAllLogFormatters(Formatter form, Level level) {
        LogManager mgr = LogManager.getLogManager();
        Enumeration<String> loggerNames = mgr.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger logger = mgr.getLogger(loggerName);
            for (Handler handler : logger.getHandlers()) {
                handler.setFormatter(form);
                handler.setLevel(level);
            }
        }
    }

    public static void main(String[] args) {
        MonkeyRunnerOptions options = MonkeyRunnerOptions.processOptions(args);
        if (options == null) {
            return;
        }
        MonkeyRunnerStarter.replaceAllLogFormatters(MonkeyFormatter.DEFAULT_INSTANCE, options.getLogLevel());
        MonkeyRunnerStarter runner = new MonkeyRunnerStarter(options);
        int error = runner.run();
        System.exit(error);
    }
}

