/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.w3c.dom.Element;

public class OrphanXmlElement
extends XmlNode {
    @NonNull
    private final Element mXml;
    @NonNull
    private final ManifestModel.NodeTypes mType;

    public OrphanXmlElement(@NonNull Element xml) {
        String androidPrefix;
        this.mXml = (Element)Preconditions.checkNotNull((Object)xml);
        String elementName = this.mXml.getNodeName();
        int indexOfColon = elementName.indexOf(58);
        ManifestModel.NodeTypes nodeType = indexOfColon != -1 ? ((androidPrefix = XmlUtils.lookupNamespacePrefix(xml, "http://schemas.android.com/apk/res/android")).equals(elementName.substring(0, indexOfColon)) ? ManifestModel.NodeTypes.fromXmlSimpleName(elementName.substring(indexOfColon + 1)) : ManifestModel.NodeTypes.CUSTOM) : ManifestModel.NodeTypes.fromXmlSimpleName(elementName);
        this.mType = nodeType;
    }

    public boolean isA(ManifestModel.NodeTypes type) {
        return this.mType == type;
    }

    @Override
    @NonNull
    public Element getXml() {
        return this.mXml;
    }

    @Override
    public XmlNode.NodeKey getId() {
        return new XmlNode.NodeKey(Strings.isNullOrEmpty((String)this.getKey()) ? this.getName().toString() : this.getName().toString() + "#" + this.getKey());
    }

    @Override
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    @NonNull
    public ManifestModel.NodeTypes getType() {
        return this.mType;
    }

    @Nullable
    public String getKey() {
        return this.mType.getNodeKeyResolver().getKey(this.mXml);
    }

    @Override
    @NonNull
    public PositionXmlParser.Position getPosition() {
        return PositionImpl.UNKNOWN;
    }

    @Override
    @NonNull
    public XmlLoader.SourceLocation getSourceLocation() {
        return XmlLoader.UNKNOWN;
    }
}

