/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.Selector;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlDocument {
    private static final String DEFAULT_SDK_VERSION = "1";
    private final Element mRootElement;
    private final AtomicReference<XmlElement> mRootNode = new AtomicReference<Object>(null);
    private final PositionXmlParser mPositionXmlParser;
    private final XmlLoader.SourceLocation mSourceLocation;
    private final KeyResolver<String> mSelectors;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> mSystemPropertyResolver;
    private final Type mType;
    private final Optional<String> mMainManifestPackageName;

    public XmlDocument(@NonNull PositionXmlParser positionXmlParser, @NonNull XmlLoader.SourceLocation sourceLocation, @NonNull KeyResolver<String> selectors, @NonNull PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> systemPropertyResolver, @NonNull Element element, @NonNull Type type, @NonNull Optional<String> mainManifestPackageName) {
        this.mPositionXmlParser = (PositionXmlParser)Preconditions.checkNotNull((Object)positionXmlParser);
        this.mSourceLocation = (XmlLoader.SourceLocation)Preconditions.checkNotNull((Object)sourceLocation);
        this.mRootElement = (Element)Preconditions.checkNotNull((Object)element);
        this.mSelectors = (KeyResolver)Preconditions.checkNotNull(selectors);
        this.mSystemPropertyResolver = (PlaceholderHandler.KeyBasedValueResolver)Preconditions.checkNotNull(systemPropertyResolver);
        this.mType = type;
        this.mMainManifestPackageName = mainManifestPackageName;
    }

    public Type getFileType() {
        return this.mType;
    }

    public String prettyPrint() {
        return XmlPrettyPrinter.prettyPrint(this.getXml(), XmlFormatPreferences.defaults(), XmlFormatStyle.get(this.getRootNode().getXml()), null, false);
    }

    public Optional<XmlDocument> merge(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) {
        if (this.getFileType() == Type.MAIN) {
            mergingReportBuilder.getActionRecorder().recordDefaultNodeAction(this.getRootNode());
        }
        this.getRootNode().mergeWithLowerPriorityNode(lowerPriorityDocument.getRootNode(), mergingReportBuilder);
        this.addImplicitElements(lowerPriorityDocument, mergingReportBuilder);
        return mergingReportBuilder.hasErrors() ? Optional.absent() : Optional.of((Object)this.reparse());
    }

    public XmlDocument reparse() {
        return new XmlDocument(this.mPositionXmlParser, this.mSourceLocation, this.mSelectors, this.mSystemPropertyResolver, this.mRootElement, this.mType, this.mMainManifestPackageName);
    }

    public KeyResolver<String> getSelectors() {
        return this.mSelectors;
    }

    public PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> getSystemPropertyResolver() {
        return this.mSystemPropertyResolver;
    }

    public Optional<String> compareTo(XmlDocument other) {
        return this.getRootNode().compareTo(other.getRootNode());
    }

    @NonNull
    PositionXmlParser.Position getNodePosition(XmlNode node) {
        return this.getNodePosition(node.getXml());
    }

    @NonNull
    PositionXmlParser.Position getNodePosition(Node xml) {
        final PositionXmlParser.Position position = this.mPositionXmlParser.getPosition(xml);
        if (position == null) {
            return PositionImpl.UNKNOWN;
        }
        return new PositionXmlParser.Position(){

            @Override
            @Nullable
            public PositionXmlParser.Position getEnd() {
                return position.getEnd();
            }

            @Override
            public void setEnd(@NonNull PositionXmlParser.Position end) {
                position.setEnd(end);
            }

            @Override
            public int getLine() {
                return position.getLine() + 1;
            }

            @Override
            public int getOffset() {
                return position.getOffset();
            }

            @Override
            public int getColumn() {
                return position.getColumn() + 1;
            }
        };
    }

    @NonNull
    public XmlLoader.SourceLocation getSourceLocation() {
        return this.mSourceLocation;
    }

    public synchronized XmlElement getRootNode() {
        if (this.mRootNode.get() == null) {
            this.mRootNode.set(new XmlElement(this.mRootElement, this));
        }
        return this.mRootNode.get();
    }

    public Optional<XmlElement> getByTypeAndKey(ManifestModel.NodeTypes type, @Nullable String keyValue) {
        return this.getRootNode().getNodeByTypeAndKey(type, keyValue);
    }

    public String getPackageName() {
        return (String)this.mMainManifestPackageName.or((Object)this.mRootElement.getAttribute("package"));
    }

    public String getPackageNameForAttributeExpansion() {
        String aPackage = this.mRootElement.getAttribute("package");
        if (aPackage != null) {
            return aPackage;
        }
        if (this.mMainManifestPackageName.isPresent()) {
            return (String)this.mMainManifestPackageName.get();
        }
        throw new RuntimeException("No package present in overlay or main manifest file");
    }

    public Optional<XmlAttribute> getPackage() {
        Optional<XmlAttribute> packageAttribute = this.getRootNode().getAttribute(XmlNode.fromXmlName("package"));
        return packageAttribute.isPresent() ? packageAttribute : this.getRootNode().getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "package"));
    }

    public Document getXml() {
        return this.mRootElement.getOwnerDocument();
    }

    private String getRawMinSdkVersion() {
        Optional<XmlAttribute> minSdkVersion;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent() && (minSdkVersion = ((XmlElement)usesSdk.get()).getAttribute(XmlNode.fromXmlName("android:minSdkVersion"))).isPresent()) {
            return ((XmlAttribute)minSdkVersion.get()).getValue();
        }
        return DEFAULT_SDK_VERSION;
    }

    private String getMinSdkVersion() {
        String injectedMinSdk = this.mSystemPropertyResolver.getValue(ManifestMerger2.SystemProperty.MIN_SDK_VERSION);
        if (injectedMinSdk != null) {
            return injectedMinSdk;
        }
        return this.getRawMinSdkVersion();
    }

    private String getRawTargetSdkVersion() {
        Optional<XmlAttribute> targetSdkVersion;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent() && (targetSdkVersion = ((XmlElement)usesSdk.get()).getAttribute(XmlNode.fromXmlName("android:targetSdkVersion"))).isPresent()) {
            return ((XmlAttribute)targetSdkVersion.get()).getValue();
        }
        return this.getRawMinSdkVersion();
    }

    private String getTargetSdkVersion() {
        String injectedTargetVersion = this.mSystemPropertyResolver.getValue(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION);
        if (injectedTargetVersion != null) {
            return injectedTargetVersion;
        }
        return this.getRawTargetSdkVersion();
    }

    private static int getApiLevelFromAttribute(String attributeVersion) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attributeVersion) ? 1 : 0) != 0);
        if (Character.isDigit(attributeVersion.charAt(0))) {
            return Integer.parseInt(attributeVersion);
        }
        return SdkVersionInfo.getApiByPreviewName(attributeVersion, true);
    }

    private void addImplicitElements(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReport) {
        XmlElement usesSdkElement;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (this.mType == Type.OVERLAY && !usesSdk.isPresent()) {
            return;
        }
        if (usesSdk.isPresent() && (usesSdkElement = (XmlElement)usesSdk.get()).getOperationType() != NodeOperationType.MERGE) {
            mergingReport.addMessage(this.getSourceLocation(), usesSdkElement.getLine(), usesSdkElement.getColumn(), MergingReport.Record.Severity.ERROR, "uses-sdk element cannot have a \"tools:node\" attribute");
            return;
        }
        int thisTargetSdk = XmlDocument.getApiLevelFromAttribute(this.getTargetSdkVersion());
        int libraryTargetSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getFileType() == Type.LIBRARY ? lowerPriorityDocument.getRawTargetSdkVersion() : lowerPriorityDocument.getTargetSdkVersion());
        String libraryTargetSdkVersion = lowerPriorityDocument.getTargetSdkVersion();
        if (!Character.isDigit(libraryTargetSdkVersion.charAt(0)) && !libraryTargetSdkVersion.equals(this.getTargetSdkVersion())) {
            mergingReport.addMessage(this.getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, String.format("uses-sdk:targetSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getTargetSdkVersion(), libraryTargetSdkVersion, lowerPriorityDocument.getSourceLocation().print(false)));
            return;
        }
        String libraryMinSdkVersion = lowerPriorityDocument.getRawMinSdkVersion();
        if (!Character.isDigit(libraryMinSdkVersion.charAt(0)) && !libraryMinSdkVersion.equals(this.getMinSdkVersion())) {
            mergingReport.addMessage(this.getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, String.format("uses-sdk:minSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getMinSdkVersion(), libraryMinSdkVersion, lowerPriorityDocument.getSourceLocation().print(false)));
            return;
        }
        if (!this.checkUsesSdkMinVersion(lowerPriorityDocument, mergingReport)) {
            mergingReport.addMessage(this.getSourceLocation(), usesSdk.isPresent() ? ((XmlElement)usesSdk.get()).getLine() : 0, usesSdk.isPresent() ? ((XmlElement)usesSdk.get()).getColumn() : 0, MergingReport.Record.Severity.ERROR, String.format("uses-sdk:minSdkVersion %1$s cannot be smaller than version %2$s declared in library %3$s\n\tSuggestion: use tools:overrideLibrary=\"%4$s\" to force usage", this.getMinSdkVersion(), lowerPriorityDocument.getRawMinSdkVersion(), lowerPriorityDocument.getSourceLocation().print(false), lowerPriorityDocument.getPackageName()));
            return;
        }
        if (thisTargetSdk <= libraryTargetSdk) {
            return;
        }
        if (thisTargetSdk < 4) {
            return;
        }
        boolean hasWriteToExternalStoragePermission = lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_EXTERNAL_STORAGE")).isPresent();
        if (libraryTargetSdk < 4) {
            Optional<Element> permission = this.addIfAbsent(mergingReport.getActionRecorder(), ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_EXTERNAL_STORAGE"), lowerPriorityDocument.getPackageName() + " has a targetSdkVersion < 4", Pair.of("maxSdkVersion", "18"));
            hasWriteToExternalStoragePermission = permission.isPresent();
            this.addIfAbsent(mergingReport.getActionRecorder(), ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_PHONE_STATE"), lowerPriorityDocument.getPackageName() + " has a targetSdkVersion < 4", new Pair[0]);
        }
        if (hasWriteToExternalStoragePermission && !lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_EXTERNAL_STORAGE")).isPresent()) {
            this.addIfAbsent(mergingReport.getActionRecorder(), ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_EXTERNAL_STORAGE"), lowerPriorityDocument.getPackageName() + " requested WRITE_EXTERNAL_STORAGE", Pair.of("maxSdkVersion", "18"));
        }
        if (libraryTargetSdk < 16) {
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_CONTACTS")).isPresent()) {
                this.addIfAbsent(mergingReport.getActionRecorder(), ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_CALL_LOG"), lowerPriorityDocument.getPackageName() + " has targetSdkVersion < 16 and requested READ_CONTACTS", new Pair[0]);
            }
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_CONTACTS")).isPresent()) {
                this.addIfAbsent(mergingReport.getActionRecorder(), ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_CALL_LOG"), lowerPriorityDocument.getPackageName() + " has targetSdkVersion < 16 and requested WRITE_CONTACTS", new Pair[0]);
            }
        }
    }

    private boolean checkUsesSdkMinVersion(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReport) {
        int libraryMinSdk;
        int thisMinSdk = XmlDocument.getApiLevelFromAttribute(this.getMinSdkVersion());
        if (thisMinSdk < (libraryMinSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getRawMinSdkVersion()))) {
            Optional<XmlElement> xmlElementOptional = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
            if (!xmlElementOptional.isPresent()) {
                return false;
            }
            XmlElement xmlElement = (XmlElement)xmlElementOptional.get();
            for (Selector selector : xmlElement.getOverrideUsesSdkLibrarySelectors()) {
                if (!selector.appliesTo(lowerPriorityDocument.getRootNode())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Optional<Element> addIfAbsent(@NonNull ActionRecorder actionRecorder, @NonNull ManifestModel.NodeTypes nodeType, @Nullable String keyValue, @Nullable String reason, Pair<String, String> ... attributes) {
        Optional<XmlElement> xmlElementOptional = this.getByTypeAndKey(nodeType, keyValue);
        if (xmlElementOptional.isPresent()) {
            return Optional.absent();
        }
        Element elementNS = this.getXml().createElementNS("http://schemas.android.com/apk/res/android", "android:" + nodeType.toXmlName());
        ImmutableList<String> keyAttributesNames = nodeType.getNodeKeyResolver().getKeyAttributesNames();
        if (keyAttributesNames.size() == 1) {
            elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + (String)keyAttributesNames.get(0), keyValue);
        }
        if (attributes != null) {
            for (Pair<String, String> attribute : attributes) {
                elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + attribute.getFirst(), attribute.getSecond());
            }
        }
        XmlElement xmlElement = new XmlElement(elementNS, this);
        actionRecorder.recordImpliedNodeAction(xmlElement, reason);
        this.getRootNode().getXml().appendChild(elementNS);
        return Optional.of((Object)elementNS);
    }

    private static String permission(String permissionName) {
        return "android.permission." + permissionName;
    }

    static enum Type {
        OVERLAY,
        MAIN,
        LIBRARY;

    }
}

