/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.MergeProcessor;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.args.IOptsParser;
import java.io.IOException;

public final class mergeCommand
extends Command {
    private String[] m_datapath;
    private String m_outFileName;

    public mergeCommand(String usageToolName, String[] args) {
        super(usageToolName, args);
    }

    @Override
    public synchronized void run() {
        ClassLoader loader;
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = this.getClass().getClassLoader();
        }
        try {
            IOptsParser parser = this.getOptParser(loader);
            IOptsParser.IOpts parsedopts = parser.parse(this.m_args);
            int usageRequestLevel = parsedopts.usageRequestLevel();
            if (usageRequestLevel > 0) {
                this.usageexit(parser, usageRequestLevel, null);
                return;
            }
            IOptsParser.IOpt[] opts = parsedopts.getOpts();
            if (opts == null) {
                parsedopts.error(this.m_out, 80);
                this.usageexit(parser, 1, null);
                return;
            }
            try {
                for (int o = 0; o < opts.length; ++o) {
                    IOptsParser.IOpt opt = opts[o];
                    String on = opt.getCanonicalName();
                    if (this.processOpt(opt)) continue;
                    if ("in".equals(on)) {
                        this.m_datapath = mergeCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if (!"out".equals(on)) continue;
                    this.m_outFileName = opt.getFirstValue();
                }
                if (!this.processFilePropertyOverrides()) {
                    return;
                }
                this.processCmdPropertyOverrides(parsedopts);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("ARGS_IO_FAILURE", ioe);
            }
            MergeProcessor processor = MergeProcessor.create();
            processor.setAppName("EMMA");
            processor.setDataPath(this.m_datapath);
            processor.setSessionOutFile(this.m_outFileName);
            processor.setPropertyOverrides(this.m_propertyOverrides);
            processor.run();
        }
        catch (EMMARuntimeException yre) {
            this.exit(true, yre.getMessage(), yre, 2);
            return;
        }
        catch (Throwable t) {
            this.exit(true, "unexpected failure: ", t, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected String usageArgsMsg() {
        return "[options]";
    }
}

