/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;

public final class ReportProcessor
extends Processor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File[] m_sourcePath;
    private IReportGenerator[] m_reportGenerators;
    private int m_dataFileCount;
    private static final Class[] EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};

    public static ReportProcessor create() {
        return new ReportProcessor();
    }

    public final synchronized void setDataPath(String[] path) {
        this.m_dataPath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, true);
    }

    public synchronized void setSourcePath(String[] path) {
        this.m_sourcePath = path == null ? null : Files.pathToFiles(path, true);
    }

    public synchronized void setReportTypes(String[] types) {
        if (types == null) {
            throw new IllegalArgumentException("null input: types");
        }
        String[] reportTypes = Strings.removeDuplicates(types, true);
        if (reportTypes.length == 0) {
            throw new IllegalArgumentException("empty input: types");
        }
        IReportGenerator[] reportGenerators = new IReportGenerator[reportTypes.length];
        for (int t = 0; t < reportTypes.length; ++t) {
            reportGenerators[t] = AbstractReportGenerator.create(reportTypes[t]);
        }
        this.m_reportGenerators = reportGenerators;
    }

    @Override
    protected void validateState() {
        super.validateState();
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
        if (this.m_reportGenerators == null || this.m_reportGenerators.length == 0) {
            throw new IllegalStateException("report types not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _run(IProperties toolProperties) {
        RuntimeException failure;
        block44: {
            Logger log = this.m_log;
            boolean verbose = this.m_log.atVERBOSE();
            if (verbose) {
                String nonexistent;
                File f;
                int p;
                log.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
                log.verbose("input data path:");
                log.verbose("{");
                for (p = 0; p < this.m_dataPath.length; ++p) {
                    f = this.m_dataPath[p];
                    nonexistent = f.exists() ? "" : "{nonexistent} ";
                    log.verbose("  " + nonexistent + f.getAbsolutePath());
                }
                log.verbose("}");
                if (this.m_sourcePath == null || this.m_sourcePath.length == 0) {
                    log.verbose("source path not set");
                } else {
                    log.verbose("source path:");
                    log.verbose("{");
                    for (p = 0; p < this.m_sourcePath.length; ++p) {
                        f = this.m_sourcePath[p];
                        nonexistent = f.exists() ? "" : "{nonexistent} ";
                        log.verbose("  " + nonexistent + f.getAbsolutePath());
                    }
                    log.verbose("}");
                }
            } else {
                log.info("processing input files ...");
            }
            failure = null;
            try {
                long start = log.atINFO() ? System.currentTimeMillis() : 0L;
                IMergeable mdata = null;
                IMergeable cdata = null;
                try {
                    for (int f = 0; f < this.m_dataPath.length; ++this.m_dataFileCount, ++f) {
                        ICoverageData _cdata;
                        IMergeable[] fileData;
                        IMetaData _mdata;
                        File dataFile = this.m_dataPath[f];
                        if (verbose) {
                            log.verbose("processing input file [" + dataFile.getAbsolutePath() + "] ...");
                        }
                        if ((_mdata = (IMetaData)(fileData = DataFactory.load(dataFile))[0]) != null) {
                            if (verbose) {
                                log.verbose("  loaded " + _mdata.size() + " metadata entries");
                            }
                            mdata = mdata == null ? _mdata : (IMetaData)mdata.merge(_mdata);
                        }
                        if ((_cdata = (ICoverageData)fileData[1]) == null) continue;
                        if (verbose) {
                            log.verbose("  loaded " + _cdata.size() + " coverage data entries");
                        }
                        cdata = cdata == null ? _cdata : (ICoverageData)cdata.merge(_cdata);
                    }
                    if (log.atINFO()) {
                        long end = System.currentTimeMillis();
                        log.info(this.m_dataFileCount + " file(s) read and merged in " + (end - start) + " ms");
                    }
                    if (mdata == null || mdata.isEmpty()) {
                        log.warning("nothing to do: no metadata found in any of the data files");
                        return;
                    }
                    if (cdata == null) {
                        log.warning("nothing to do: no runtime coverage data found in any of the data files");
                        return;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                    break block44;
                }
                {
                    if (cdata.isEmpty()) {
                        log.warning("no collected coverage data found in any of the data files [all reports will be empty]");
                    }
                    if (verbose) {
                        if (mdata != null) {
                            log.verbose("  merged metadata contains " + mdata.size() + " entries");
                        }
                        if (cdata != null) {
                            log.verbose("  merged coverage data contains " + cdata.size() + " entries");
                        }
                    }
                    SourcePathCache srcpathCache = null;
                    if (this.m_sourcePath != null) {
                        srcpathCache = new SourcePathCache(this.m_sourcePath, true);
                    }
                    for (int g = 0; g < this.m_reportGenerators.length; ++g) {
                        IReportGenerator generator = this.m_reportGenerators[g];
                        try {
                            generator.process((IMetaData)mdata, (ICoverageData)cdata, srcpathCache, toolProperties);
                        }
                        catch (Throwable t) {
                            try {
                                t.printStackTrace(System.out);
                                break;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    generator.cleanup();
                                }
                                catch (Throwable ignore) {}
                            }
                        }
                        try {
                            generator.cleanup();
                            continue;
                        }
                        catch (Throwable ignore) {}
                    }
                }
            }
            catch (SecurityException se) {
                failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
            }
            catch (RuntimeException re) {
                failure = re;
            }
            finally {
                this.reset();
            }
        }
        if (failure == null) return;
        if (!Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) throw failure;
        throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "this private build is unsupported"}, failure);
    }

    private ReportProcessor() {
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }
}

