/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SourcePathCache {
    private final File[] m_sourcepath;
    private final Map m_packageCache;
    private static final FileExtensionFilter FILE_EXTENSION_FILTER = new FileExtensionFilter(".java");

    public SourcePathCache(String[] sourcepath, boolean removeNonExistent) {
        if (sourcepath == null) {
            throw new IllegalArgumentException("null input: sourcepath");
        }
        ArrayList<File> _sourcepath = new ArrayList<File>(sourcepath.length);
        for (int i = 0; i < sourcepath.length; ++i) {
            File dir = new File(sourcepath[i]);
            if (removeNonExistent && (!dir.isDirectory() || !dir.exists())) continue;
            _sourcepath.add(dir);
        }
        this.m_sourcepath = new File[_sourcepath.size()];
        _sourcepath.toArray(this.m_sourcepath);
        this.m_packageCache = new HashMap();
    }

    public SourcePathCache(File[] sourcepath, boolean removeNonExistent) {
        if (sourcepath == null) {
            throw new IllegalArgumentException("null input: sourcepath");
        }
        ArrayList<File> _sourcepath = new ArrayList<File>(sourcepath.length);
        for (int i = 0; i < sourcepath.length; ++i) {
            File dir = sourcepath[i];
            if (removeNonExistent && (!dir.isDirectory() || !dir.exists())) continue;
            _sourcepath.add(dir);
        }
        this.m_sourcepath = new File[_sourcepath.size()];
        _sourcepath.toArray(this.m_sourcepath);
        this.m_packageCache = new HashMap();
    }

    public synchronized File find(String packageVMName, String name) {
        if (packageVMName == null) {
            throw new IllegalArgumentException("null input: packageVMName");
        }
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (this.m_sourcepath.length == 0) {
            return null;
        }
        CacheEntry entry = (CacheEntry)this.m_packageCache.get(packageVMName);
        if (entry == null) {
            entry = new CacheEntry(this.m_sourcepath.length);
            this.m_packageCache.put(packageVMName, entry);
        }
        Set[] listings = entry.m_listings;
        for (int p = 0; p < listings.length; ++p) {
            Set listing = listings[p];
            if (listing == null) {
                listings[p] = listing = this.faultListing(this.m_sourcepath[p], packageVMName);
            }
            if (!listing.contains(name)) continue;
            File relativeFile = new File(packageVMName.replace('/', File.separatorChar), name);
            return new File(this.m_sourcepath[p], relativeFile.getPath()).getAbsoluteFile();
        }
        return null;
    }

    private Set faultListing(File dir, String packageVMName) {
        File packageFile = new File(dir, packageVMName.replace('/', File.separatorChar));
        File[] listing = packageFile.listFiles(FILE_EXTENSION_FILTER);
        if (listing == null || listing.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>(listing.length);
        for (int f = 0; f < listing.length; ++f) {
            result.add(listing[f].getName());
        }
        return result;
    }

    private static final class FileExtensionFilter
    implements FileFilter {
        private final String m_extension;

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String name = file.getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot <= 0) {
                return false;
            }
            return this.m_extension.equals(name.substring(lastDot));
        }

        public String toString() {
            return super.toString() + ", extension = [" + this.m_extension + "]";
        }

        FileExtensionFilter(String extension) {
            if (extension == null) {
                throw new IllegalArgumentException("null input: extension");
            }
            String canonical = FileExtensionFilter.canonicalizeExtension(extension);
            if (extension.length() <= 1) {
                throw new IllegalArgumentException("empty input: extension");
            }
            this.m_extension = canonical;
        }

        private static String canonicalizeExtension(String extension) {
            if (extension.charAt(0) != '.') {
                return ".".concat(extension);
            }
            return extension;
        }
    }

    private static final class CacheEntry {
        final Set[] m_listings;

        CacheEntry(int size) {
            this.m_listings = new Set[size];
        }
    }
}

