/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.IElement;
import com.vladium.emma.report.html.doc.IElementList;
import com.vladium.emma.report.html.doc.ISimpleElement;
import com.vladium.emma.report.html.doc.Tag;
import com.vladium.util.IConstants;

public final class HTMLDocument
extends IElement.Factory.ElementImpl {
    private final String m_title;
    private final IElement m_head = IElement.Factory.create(Tag.HEAD);
    private final IElement m_body;
    private IContent m_header;
    private IContent m_footer;

    public HTMLDocument() {
        this((String)null, (String)null);
    }

    public HTMLDocument(String title, String encoding) {
        super(Tag.HTML, AttributeSet.create());
        super.add(this.m_head);
        this.m_body = IElement.Factory.create(Tag.BODY);
        super.add(this.m_body);
        if (encoding != null && encoding.length() != 0) {
            ISimpleElement meta = ISimpleElement.Factory.create(Tag.META);
            meta.getAttributes().set(Attribute.HTTP_EQUIV, "Content-Type").set(Attribute.CONTENT, "text/html; charset=" + encoding);
            this.m_head.add(meta);
        }
        if (title != null) {
            IElement titleElement = IElement.Factory.create(Tag.TITLE).setText(title, false);
            this.m_head.add(titleElement);
        }
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public IElement getHead() {
        return this.m_head;
    }

    public IElement getBody() {
        return this.m_body;
    }

    public IContent getHeader() {
        return this.m_header;
    }

    public IContent getFooter() {
        return this.m_footer;
    }

    public void setHeader(IContent header) {
        if (header != null) {
            this.m_header = header;
        }
    }

    public void setFooter(IContent footer) {
        if (footer != null) {
            this.m_footer = footer;
        }
    }

    @Override
    public void emit(HTMLWriter out) {
        if (this.m_header != null) {
            this.m_body.add(0, this.m_header);
        }
        if (this.m_footer != null) {
            this.m_body.add(this.m_body.size(), this.m_footer);
        }
        super.emit(out);
    }

    @Override
    public IElementList add(IContent content) {
        this.m_body.add(content);
        return this;
    }

    public void addStyle(String css) {
        if (css != null) {
            IElement style = IElement.Factory.create(Tag.STYLE);
            style.getAttributes().set(Attribute.TYPE, "text/css");
            StringBuffer def = new StringBuffer("<!--");
            def.append(IConstants.EOL);
            style.setText(css, false);
            def.append(IConstants.EOL);
            def.append("-->");
            this.m_head.add(style);
        }
    }

    public void addLINK(String type, String href) {
        ISimpleElement link = ISimpleElement.Factory.create(Tag.LINK);
        link.getAttributes().set(Attribute.TYPE, type);
        link.getAttributes().set(Attribute.HREF, href);
        link.getAttributes().set(Attribute.SRC, href);
        this.m_head.add(link);
    }

    public void addH(int level, String text, String classID) {
        Tag Hl = Tag.Hs[level];
        IElement h = IElement.Factory.create(Hl);
        h.setText(text, true);
        h.setClass(classID);
        this.add(h);
    }

    public void addH(int level, IContent text, String classID) {
        Tag Hl = Tag.Hs[level];
        IElement h = IElement.Factory.create(Hl);
        h.add(text);
        h.setClass(classID);
        this.add(h);
    }

    public void addHR(int size) {
        IElement hr = IElement.Factory.create(Tag.HR);
        hr.getAttributes().set(Attribute.SIZE, size);
        this.add(hr);
    }

    public void addEmptyP() {
        this.add(IElement.Factory.create(Tag.P));
    }
}

