/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class FieldCollection
implements IFieldCollection {
    private List m_fields;

    @Override
    public Field_info get(int offset) {
        return (Field_info)this.m_fields.get(offset);
    }

    @Override
    public int[] get(ClassDef cls, String name) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        int count = this.m_fields.size();
        IntVector result = new IntVector(count);
        for (int f = 0; f < count; ++f) {
            Field_info field = (Field_info)this.m_fields.get(f);
            if (!field.getName(cls).equals(name)) continue;
            result.add(f);
        }
        return result.values();
    }

    @Override
    public int size() {
        return this.m_fields.size();
    }

    @Override
    public Object clone() {
        try {
            FieldCollection _clone = (FieldCollection)super.clone();
            int fields_count = this.m_fields.size();
            _clone.m_fields = new ArrayList(fields_count);
            for (int f = 0; f < fields_count; ++f) {
                _clone.m_fields.add(((Field_info)this.m_fields.get(f)).clone());
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int fields_count = this.m_fields.size();
        out.writeU2(fields_count);
        for (int i = 0; i < fields_count; ++i) {
            this.get(i).writeInClassFormat(out);
        }
    }

    @Override
    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public int add(Field_info field) {
        int newoffset = this.m_fields.size();
        this.m_fields.add(field);
        return newoffset;
    }

    @Override
    public Field_info set(int offset, Field_info field) {
        return this.m_fields.set(offset, field);
    }

    FieldCollection(int capacity) {
        this.m_fields = capacity < 0 ? new ArrayList() : new ArrayList(capacity);
    }
}

