/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.DeclaredExceptionTable;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.IDeclaredExceptionTable;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public final class ExceptionsAttribute_info
extends Attribute_info {
    private IDeclaredExceptionTable m_exceptions;

    public ExceptionsAttribute_info(int attribute_name_index, IDeclaredExceptionTable exceptions) {
        super(attribute_name_index, exceptions.length());
        this.m_exceptions = exceptions;
    }

    public IDeclaredExceptionTable getDeclaredExceptions() {
        return this.m_exceptions;
    }

    @Override
    public long length() {
        return 6L + this.m_exceptions.length();
    }

    @Override
    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public String toString() {
        return "ExceptionsAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.m_attribute_length + ']';
    }

    @Override
    public Object clone() {
        ExceptionsAttribute_info _clone = (ExceptionsAttribute_info)super.clone();
        _clone.m_exceptions = (IDeclaredExceptionTable)this.m_exceptions.clone();
        return _clone;
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        this.m_exceptions.writeInClassFormat(out);
    }

    ExceptionsAttribute_info(int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        int number_of_exceptions = bytes.readU2();
        this.m_exceptions = new DeclaredExceptionTable(number_of_exceptions);
        for (int i = 0; i < number_of_exceptions; ++i) {
            int exception_index = bytes.readU2();
            this.m_exceptions.add(exception_index);
        }
    }
}

