/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.InnerClass_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class InnerClassesAttribute_info
extends Attribute_info {
    private List m_classes;

    public boolean makesClassNested(int class_index, int[] nestedAccessFlags) {
        if (class_index > 0) {
            int iLimit = this.size();
            for (int i = 0; i < iLimit; ++i) {
                InnerClass_info info = this.get(i);
                if (info.m_inner_class_index != class_index) continue;
                nestedAccessFlags[0] = info.m_inner_access_flags;
                return true;
            }
        }
        return false;
    }

    public final InnerClass_info get(int offset) {
        return (InnerClass_info)this.m_classes.get(offset);
    }

    public final int size() {
        return this.m_classes.size();
    }

    @Override
    public final long length() {
        return 8 + (this.m_classes.size() << 3);
    }

    @Override
    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("InnerClassesAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int l = 0; l < this.size(); ++l) {
            s.append("            " + this.get(l));
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public Object clone() {
        InnerClassesAttribute_info _clone = (InnerClassesAttribute_info)super.clone();
        List classes = this.m_classes;
        int class_count = classes.size();
        _clone.m_classes = new ArrayList(class_count);
        for (int e = 0; e < class_count; ++e) {
            _clone.m_classes.add(((InnerClass_info)classes.get(e)).clone());
        }
        return _clone;
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        List classes = this.m_classes;
        int class_count = classes.size();
        out.writeU2(class_count);
        for (int l = 0; l < class_count; ++l) {
            ((InnerClass_info)classes.get(l)).writeInClassFormat(out);
        }
    }

    InnerClassesAttribute_info(int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        int class_count = bytes.readU2();
        ArrayList<InnerClass_info> classes = new ArrayList<InnerClass_info>(class_count);
        for (int i = 0; i < class_count; ++i) {
            classes.add(new InnerClass_info(bytes));
        }
        this.m_classes = classes;
    }
}

