/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import java.io.InputStream;

public final class ByteArrayIStream
extends InputStream {
    private final byte[] m_buf;
    private final int m_max;
    private int m_pos;
    private static final int NATIVE_COPY_THRESHOLD = 9;

    public ByteArrayIStream(byte[] buf) {
        this(buf, buf.length);
    }

    public ByteArrayIStream(byte[] buf, int length) {
        this.m_buf = buf;
        this.m_max = length;
    }

    @Override
    public final int read() {
        if (this.m_pos >= this.m_max) {
            return -1;
        }
        return 0xFF & this.m_buf[this.m_pos++];
    }

    @Override
    public final int read(byte[] buf, int offset, int length) {
        int pos = this.m_pos;
        int max = this.m_max;
        if (pos >= max) {
            return -1;
        }
        if (pos + length > max) {
            length = max - pos;
        }
        if (length <= 0) {
            return 0;
        }
        byte[] mbuf = this.m_buf;
        if (length < 9) {
            for (int i = 0; i < length; ++i) {
                buf[offset + i] = mbuf[pos + i];
            }
        } else {
            System.arraycopy(mbuf, pos, buf, offset, length);
        }
        this.m_pos += length;
        return length;
    }

    @Override
    public final int available() {
        return this.m_max - this.m_pos;
    }

    @Override
    public final long skip(long n) {
        if ((long)this.m_pos + n > (long)this.m_max) {
            n = this.m_max - this.m_pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.m_pos = (int)((long)this.m_pos + n);
        return n;
    }

    @Override
    public final void reset() {
        this.m_pos = 0;
    }

    @Override
    public final void close() {
        this.reset();
    }
}

