/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public interface IProperties {
    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    public boolean isOverridden(String var1);

    public IProperties copy();

    public Iterator properties();

    public Properties toProperties();

    public String[] toAppArgsForm(String var1);

    public boolean isEmpty();

    public void list(PrintStream var1);

    public void list(PrintWriter var1);

    public String setProperty(String var1, String var2);

    public static abstract class Factory {
        public static IProperties create(IMapper mapper) {
            return new PropertiesImpl(null, mapper);
        }

        public static IProperties wrap(Properties properties, IMapper mapper) {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String n = (String)names.nextElement();
                String v = properties.getProperty(n);
                map.put(n, v);
            }
            return new PropertiesImpl(map, mapper);
        }

        public static IProperties combine(IProperties overrides, IProperties base) {
            IProperties result = overrides != null ? overrides.copy() : Factory.create(null);
            ((PropertiesImpl)result).getLastProperties().setDelegate((PropertiesImpl)base);
            return result;
        }

        private static final class PropertiesImpl
        implements IProperties,
        Cloneable {
            private final IMapper m_mapper;
            private HashMap m_valueMap;
            private PropertiesImpl m_delegate;
            private transient Set m_unmappedKeySet;

            @Override
            public String getProperty(String key) {
                return this.getProperty(key, null);
            }

            @Override
            public String getProperty(String key, String dflt) {
                String mappedKey;
                String value = (String)this.m_valueMap.get(key);
                if (value == null && this.m_mapper != null && (mappedKey = this.m_mapper.getMappedKey(key)) != null) {
                    value = (String)this.m_valueMap.get(mappedKey);
                }
                if (value == null && this.m_delegate != null) {
                    value = this.m_delegate.getProperty(key, null);
                }
                return value != null ? value : dflt;
            }

            @Override
            public boolean isOverridden(String key) {
                return this.m_valueMap.containsKey(key);
            }

            @Override
            public IProperties copy() {
                PropertiesImpl _clone;
                try {
                    _clone = (PropertiesImpl)super.clone();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new Error(cnse.toString());
                }
                _clone.m_valueMap = (HashMap)this.m_valueMap.clone();
                _clone.m_unmappedKeySet = null;
                PropertiesImpl scan = _clone;
                PropertiesImpl delegate = this.m_delegate;
                while (delegate != null) {
                    PropertiesImpl _delegateClone;
                    try {
                        _delegateClone = (PropertiesImpl)delegate.clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        throw new Error(cnse.toString());
                    }
                    _delegateClone.m_valueMap = (HashMap)delegate.m_valueMap.clone();
                    _delegateClone.m_unmappedKeySet = null;
                    scan.setDelegate(_delegateClone);
                    scan = _delegateClone;
                    delegate = delegate.m_delegate;
                }
                return _clone;
            }

            @Override
            public Iterator properties() {
                return this.unmappedKeySet().iterator();
            }

            @Override
            public Properties toProperties() {
                Properties result = new Properties();
                Iterator i = this.properties();
                while (i.hasNext()) {
                    String n = (String)i.next();
                    String v = this.getProperty(n);
                    result.setProperty(n, v);
                }
                return result;
            }

            @Override
            public boolean isEmpty() {
                return this.m_valueMap.isEmpty() && (this.m_delegate == null || this.m_delegate != null && this.m_delegate.isEmpty());
            }

            @Override
            public String[] toAppArgsForm(String prefix) {
                if (this.isEmpty()) {
                    return IConstants.EMPTY_STRING_ARRAY;
                }
                if (prefix == null) {
                    throw new IllegalArgumentException("null input: prefix");
                }
                ArrayList<String> _result = new ArrayList<String>();
                Iterator names = this.properties();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    String value = this.getProperty(name, "");
                    _result.add(prefix.concat(name).concat("=").concat(value));
                }
                String[] result = new String[_result.size()];
                _result.toArray(result);
                return result;
            }

            @Override
            public void list(PrintStream out) {
                if (out != null) {
                    Iterator i = this.properties();
                    while (i.hasNext()) {
                        String n = (String)i.next();
                        String v = this.getProperty(n);
                        out.println(n + ":\t[" + v + "]");
                    }
                }
            }

            @Override
            public void list(PrintWriter out) {
                if (out != null) {
                    Iterator i = this.properties();
                    while (i.hasNext()) {
                        String n = (String)i.next();
                        String v = this.getProperty(n);
                        out.println(n + ":\t[" + v + "]");
                    }
                }
            }

            @Override
            public String setProperty(String key, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("null input: value");
                }
                this.m_unmappedKeySet = null;
                return this.m_valueMap.put(key, value);
            }

            PropertiesImpl(HashMap values, IMapper mapper) {
                this.m_mapper = mapper;
                this.m_valueMap = values != null ? values : new HashMap();
                this.m_delegate = null;
            }

            Set unmappedKeySet() {
                TreeSet result = this.m_unmappedKeySet;
                if (result == null) {
                    result = new TreeSet();
                    result.addAll(this.m_valueMap.keySet());
                    if (this.m_delegate != null) {
                        result.addAll(this.m_delegate.unmappedKeySet());
                    }
                    this.m_unmappedKeySet = result;
                    return result;
                }
                return result;
            }

            PropertiesImpl getLastProperties() {
                PropertiesImpl result = this;
                PropertiesImpl delegate = this.m_delegate;
                while (delegate != null) {
                    if (delegate == this) {
                        throw new IllegalStateException("cyclic delegation detected");
                    }
                    result = delegate;
                    delegate = delegate.m_delegate;
                }
                return result;
            }

            void setDelegate(PropertiesImpl delegate) {
                this.m_delegate = delegate;
                this.m_unmappedKeySet = null;
            }
        }
    }

    public static interface IMapper {
        public String getMappedKey(String var1);
    }
}

