/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exception;

import com.vladium.util.IJREVersion;
import com.vladium.util.exception.AbstractException;
import com.vladium.util.exception.AbstractRuntimeException;
import com.vladium.util.exception.IThrowableWrapper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

abstract class ExceptionCommon
implements IJREVersion {
    private static final boolean EMBED_ERROR_CODE = true;
    private static final String ROOT_RESOURCE_BUNDLE_NAME;
    private static final ResourceBundle ROOT_RESOURCE_BUNDLE;
    private static final Map s_exceptionCodeMap;
    private static final String NESTED_THROWABLE_HEADER = "[NESTED EXCEPTION]:";
    private static final Class THROWABLE;
    private static final Class ABSTRACT_EXCEPTION;
    private static final Class ABSTACT_RUNTIME_EXCEPTION;
    static final Enumeration EMPTY_ENUMERATION;
    private static final ResourceBundle EMPTY_RESOURCE_BUNDLE;
    private static final String EOL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle addExceptionResource(Class namespace, String messageResourceBundleName) {
        if (namespace != null && messageResourceBundleName != null && messageResourceBundleName.length() > 0) {
            if (!ABSTRACT_EXCEPTION.isAssignableFrom(namespace) && !ABSTACT_RUNTIME_EXCEPTION.isAssignableFrom(namespace)) {
                throw new Error("addExceptionResource(): class [" + namespace + "] is not a subclass of " + ABSTRACT_EXCEPTION.getName() + " or " + ABSTACT_RUNTIME_EXCEPTION.getName());
            }
            ResourceBundle temprb = null;
            String nameInNamespace = null;
            try {
                nameInNamespace = ExceptionCommon.getNameInNamespace(namespace, messageResourceBundleName);
                ClassLoader loader = namespace.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                temprb = ResourceBundle.getBundle(nameInNamespace, Locale.getDefault(), loader);
            }
            catch (Throwable ignore) {
                temprb = null;
            }
            if (temprb != null) {
                Map map = s_exceptionCodeMap;
                synchronized (map) {
                    ResourceBundle currentrb = (ResourceBundle)s_exceptionCodeMap.get(namespace);
                    if (currentrb != null) {
                        return currentrb;
                    }
                    s_exceptionCodeMap.put(namespace, temprb);
                    return temprb;
                }
            }
        }
        return null;
    }

    static void printStackTrace(Throwable t, PrintWriter out) {
        if (JRE_1_4_PLUS) {
            if (t instanceof IThrowableWrapper) {
                IThrowableWrapper tw = (IThrowableWrapper)((Object)t);
                tw.__printStackTrace(out);
            } else {
                t.printStackTrace(out);
            }
        } else {
            boolean first = true;
            while (t != null) {
                if (first) {
                    first = false;
                } else {
                    out.println();
                    out.println(NESTED_THROWABLE_HEADER);
                }
                if (t instanceof IThrowableWrapper) {
                    IThrowableWrapper tw = (IThrowableWrapper)((Object)t);
                    tw.__printStackTrace(out);
                    t = tw.getCause();
                    continue;
                }
                t.printStackTrace(out);
                break;
            }
        }
    }

    static void printStackTrace(Throwable t, PrintStream out) {
        if (JRE_1_4_PLUS) {
            if (t instanceof IThrowableWrapper) {
                IThrowableWrapper tw = (IThrowableWrapper)((Object)t);
                tw.__printStackTrace(out);
            } else {
                t.printStackTrace(out);
            }
        } else {
            boolean first = true;
            while (t != null) {
                if (first) {
                    first = false;
                } else {
                    out.println();
                    out.println(NESTED_THROWABLE_HEADER);
                }
                if (t instanceof IThrowableWrapper) {
                    IThrowableWrapper tw = (IThrowableWrapper)((Object)t);
                    tw.__printStackTrace(out);
                    t = tw.getCause();
                    continue;
                }
                t.printStackTrace(out);
                break;
            }
        }
    }

    static String getMessage(Class namespace, String code) {
        if (code == null) {
            return null;
        }
        try {
            if (code.length() > 0) {
                String msg = ExceptionCommon.lookup(namespace, code);
                if (msg == null) {
                    return code;
                }
                return "[" + code + "] " + msg;
            }
            return "";
        }
        catch (Throwable t) {
            return code;
        }
    }

    static String getMessage(Class namespace, String code, Object[] arguments) {
        if (code == null) {
            return null;
        }
        String pattern = ExceptionCommon.getMessage(namespace, code);
        if (arguments == null || arguments.length == 0) {
            return pattern;
        }
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (Throwable t) {
            StringBuffer msg = new StringBuffer(code + EOL);
            for (int a = 0; a < arguments.length; ++a) {
                block8: {
                    msg.append("\t{" + a + "} = [");
                    Object arg = arguments[a];
                    try {
                        msg.append(arg.toString());
                    }
                    catch (Throwable e) {
                        if (arg != null) {
                            msg.append(arg.getClass().getName());
                            break block8;
                        }
                        msg.append("null");
                    }
                }
                msg.append("]");
                msg.append(EOL);
            }
            return msg.toString();
        }
    }

    private ExceptionCommon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(Class namespace, String propertyName) {
        if (propertyName == null) {
            return null;
        }
        if (namespace != null) {
            while (namespace != ABSTRACT_EXCEPTION && namespace != ABSTACT_RUNTIME_EXCEPTION && namespace != THROWABLE && namespace != null) {
                ResourceBundle rb;
                Map map = s_exceptionCodeMap;
                synchronized (map) {
                    rb = (ResourceBundle)s_exceptionCodeMap.get(namespace);
                    if (rb == null && (rb = ExceptionCommon.addExceptionResource(namespace, "exceptions")) == null) {
                        s_exceptionCodeMap.put(namespace, EMPTY_RESOURCE_BUNDLE);
                    }
                }
                if (rb != null) {
                    String propertyValue = null;
                    try {
                        propertyValue = rb.getString(propertyName);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (propertyValue != null) {
                        return propertyValue;
                    }
                }
                namespace = namespace.getSuperclass();
            }
        }
        if (ROOT_RESOURCE_BUNDLE != null) {
            String propertyValue = null;
            try {
                propertyValue = ROOT_RESOURCE_BUNDLE.getString(propertyName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (propertyValue != null) {
                return propertyValue;
            }
        }
        return null;
    }

    private static String getNameInNamespace(Class namespace, String name) {
        if (namespace == null) {
            return name;
        }
        String namespaceName = namespace.getName();
        int lastDot = namespaceName.lastIndexOf(46);
        if (lastDot <= 0) {
            return name;
        }
        return namespaceName.substring(0, lastDot + 1) + name;
    }

    static {
        s_exceptionCodeMap = new HashMap();
        THROWABLE = Throwable.class;
        ABSTRACT_EXCEPTION = AbstractException.class;
        ABSTACT_RUNTIME_EXCEPTION = AbstractRuntimeException.class;
        EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_SET);
        EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

            @Override
            public Object handleGetObject(String key) {
                return null;
            }

            public Enumeration getKeys() {
                return EMPTY_ENUMERATION;
            }
        };
        EOL = System.getProperty("line.separator", "\n");
        ROOT_RESOURCE_BUNDLE_NAME = ExceptionCommon.getNameInNamespace(ExceptionCommon.class, "exceptions");
        ResourceBundle temprb = null;
        try {
            temprb = ResourceBundle.getBundle(ROOT_RESOURCE_BUNDLE_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ROOT_RESOURCE_BUNDLE = temprb;
    }
}

