/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.packages.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import java.io.File;
import java.util.Properties;

public class BrokenPackage
extends MajorRevisionPackage
implements IExactApiLevelDependency,
IMinApiLevelDependency {
    private final int mMinApiLevel;
    private final int mExactApiLevel;
    private final String mShortDescription;
    private final String mLongDescription;
    private final IPkgDesc mPkgDesc;

    BrokenPackage(@Nullable Properties props, @NonNull String shortDescription, @NonNull String longDescription, int minApiLevel, int exactApiLevel, @Nullable String archiveOsPath, @NonNull IPkgDesc pkgDesc) {
        super(null, props, 0, null, longDescription, null, archiveOsPath);
        this.mShortDescription = shortDescription;
        this.mLongDescription = longDescription;
        this.mMinApiLevel = minApiLevel;
        this.mExactApiLevel = exactApiLevel;
        this.mPkgDesc = pkgDesc;
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    @Override
    public int getExactApiLevel() {
        return this.mExactApiLevel;
    }

    @Override
    public String installId() {
        return "";
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        return this.mShortDescription;
    }

    @Override
    public String getShortDescription() {
        return this.mShortDescription;
    }

    @Override
    public String getLongDescription() {
        String s = this.mLongDescription;
        if (s != null && s.length() != 0) {
            return s;
        }
        s = this.getDescription();
        if (s != null && s.length() != 0) {
            return s;
        }
        return this.getShortDescription();
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return null;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof BrokenPackage) {
            return this.mShortDescription.equals(((BrokenPackage)pkg).mShortDescription) && this.getDescription().equals(pkg.getDescription()) && this.getMinApiLevel() == ((BrokenPackage)pkg).getMinApiLevel();
        }
        return false;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        FullRevision rev = this.getPkgDesc().getFullRevision();
        if (rev != null) {
            int pos = s.indexOf("|r:");
            assert (pos > 0);
            String reverseSort = String.format("|rr:%1$04d.%2$04d.%3$04d.", 9999 - rev.getMajor(), 9999 - rev.getMinor(), 9999 - rev.getMicro());
            s = s.substring(0, pos) + reverseSort + s.substring(pos);
        }
        return s;
    }
}

