/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import java.io.File;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Position;

public class JavaContext
extends Context {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    private Node mCompilationUnit;
    private final JavaParser mParser;

    public JavaContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file, @NonNull JavaParser parser) {
        super(driver, project, main, file);
        this.mParser = parser;
    }

    @NonNull
    public Location getLocation(@NonNull Node node) {
        return this.mParser.getLocation(this, node);
    }

    @NonNull
    public JavaParser getParser() {
        return this.mParser;
    }

    @Nullable
    public Node getCompilationUnit() {
        return this.mCompilationUnit;
    }

    public void setCompilationUnit(@Nullable Node compilationUnit) {
        this.mCompilationUnit = compilationUnit;
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message) {
        if (this.mDriver.isSuppressed(this, issue, this.mCompilationUnit)) {
            return;
        }
        super.report(issue, location, message);
    }

    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        this.report(issue, scope, location, message);
    }

    @Nullable
    public static Node findSurroundingMethod(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Nullable
    public static ClassDeclaration findSurroundingClass(@Nullable Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == ClassDeclaration.class) {
                return (ClassDeclaration)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Override
    @Nullable
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressedWithComment(@NonNull Node scope, @NonNull Issue issue) {
        String contents = this.getContents();
        assert (contents != null);
        Position position = scope.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getStart();
        return this.isSuppressedWithComment(start, issue);
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull Node node) {
        return this.mParser.createLocationHandle(this, node);
    }

    @Nullable
    public JavaParser.ResolvedNode resolve(@NonNull Node node) {
        return this.mParser.resolve(this, node);
    }

    @Nullable
    public JavaParser.TypeDescriptor getType(@NonNull Node node) {
        return this.mParser.getType(this, node);
    }

    public boolean isContextMethod(@NonNull MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = this.resolve(node);
        return resolved instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.content.Context", false);
    }
}

