/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.google.common.annotations.Beta;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlContext
extends ResourceContext {
    static final String SUPPRESS_COMMENT_PREFIX = "<!--suppress ";
    private final XmlParser mParser;
    public Document document;

    public XmlContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file, @Nullable ResourceFolderType folderType, @NonNull XmlParser parser) {
        super(driver, project, main, file, folderType);
        this.mParser = parser;
    }

    @NonNull
    public Location getLocation(@NonNull Node node) {
        return this.mParser.getLocation(this, node);
    }

    @NonNull
    public Location getLocation(@NonNull Node textNode, int begin, int end) {
        assert (textNode.getNodeType() == 3);
        return this.mParser.getLocation(this, textNode, begin, end);
    }

    @NonNull
    public XmlParser getParser() {
        return this.mParser;
    }

    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        this.report(issue, scope, location, message);
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message) {
        if (this.document != null && this.mDriver.isSuppressed(this, issue, this.document)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Override
    @Nullable
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressedWithComment(@NonNull Node node, @NonNull Issue issue) {
        String contents = this.getContents();
        assert (contents != null);
        int start = this.mParser.getNodeStartOffset(this, node);
        if (start != -1) {
            return this.isSuppressedWithComment(start, issue);
        }
        return false;
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull Node node) {
        return this.mParser.createLocationHandle(this, node);
    }
}

