/*
 * Decompiled with CFR 0.152.
 */
package com.android.dvlib;

import com.android.annotations.Nullable;
import com.android.io.NonClosingInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeviceSchema {
    public static final int NS_LATEST_VERSION = 2;
    public static final String NS_DEVICES_URI = DeviceSchema.getSchemaUri(2);
    private static final String NS_DEVICES_URI_BASE = "http://schemas.android.com/sdk/devices/";
    static final String NS_DEVICES_URI_PATTERN = "http://schemas.android.com/sdk/devices/([0-9]+)";
    public static final String NODE_DEVICES = "devices";
    public static final String NODE_DEVICE = "device";
    public static final String NODE_HARDWARE = "hardware";
    public static final String NODE_SOFTWARE = "software";
    public static final String NODE_STATE = "state";
    public static final String NODE_KEYBOARD = "keyboard";
    public static final String NODE_TOUCH = "touch";
    public static final String NODE_GL_EXTENSIONS = "gl-extensions";
    public static final String NODE_GL_VERSION = "gl-version";
    public static final String NODE_NETWORKING = "networking";
    public static final String NODE_REMOVABLE_STORAGE = "removable-storage";
    public static final String NODE_FLASH = "flash";
    public static final String NODE_LIVE_WALLPAPER_SUPPORT = "live-wallpaper-support";
    public static final String NODE_STATUS_BAR = "status-bar";
    public static final String NODE_BUTTONS = "buttons";
    public static final String NODE_CAMERA = "camera";
    public static final String NODE_LOCATION = "location";
    public static final String NODE_GPU = "gpu";
    public static final String NODE_DOCK = "dock";
    public static final String NODE_YDPI = "ydpi";
    public static final String NODE_POWER_TYPE = "power-type";
    public static final String NODE_Y_DIMENSION = "y-dimension";
    public static final String NODE_SCREEN_RATIO = "screen-ratio";
    public static final String NODE_NAV_STATE = "nav-state";
    public static final String NODE_MIC = "mic";
    public static final String NODE_RAM = "ram";
    public static final String NODE_XDPI = "xdpi";
    public static final String NODE_DIMENSIONS = "dimensions";
    public static final String NODE_ABI = "abi";
    public static final String NODE_MECHANISM = "mechanism";
    public static final String NODE_MULTITOUCH = "multitouch";
    public static final String NODE_NAV = "nav";
    public static final String NODE_PIXEL_DENSITY = "pixel-density";
    public static final String NODE_SCREEN_ORIENTATION = "screen-orientation";
    public static final String NODE_AUTOFOCUS = "autofocus";
    public static final String NODE_SCREEN_SIZE = "screen-size";
    public static final String NODE_DESCRIPTION = "description";
    public static final String NODE_BLUETOOTH_PROFILES = "bluetooth-profiles";
    public static final String NODE_SCREEN = "screen";
    public static final String NODE_SENSORS = "sensors";
    public static final String NODE_DIAGONAL_LENGTH = "diagonal-length";
    public static final String NODE_SCREEN_TYPE = "screen-type";
    public static final String NODE_KEYBOARD_STATE = "keyboard-state";
    public static final String NODE_X_DIMENSION = "x-dimension";
    public static final String NODE_CPU = "cpu";
    public static final String NODE_INTERNAL_STORAGE = "internal-storage";
    public static final String NODE_META = "meta";
    public static final String NODE_ICONS = "icons";
    public static final String NODE_SIXTY_FOUR = "sixty-four";
    public static final String NODE_SIXTEEN = "sixteen";
    public static final String NODE_FRAME = "frame";
    public static final String NODE_PATH = "path";
    public static final String NODE_PORTRAIT_X_OFFSET = "portrait-x-offset";
    public static final String NODE_PORTRAIT_Y_OFFSET = "portrait-y-offset";
    public static final String NODE_LANDSCAPE_X_OFFSET = "landscape-x-offset";
    public static final String NODE_LANDSCAPE_Y_OFFSET = "landscape-y-offset";
    public static final String NODE_NAME = "name";
    public static final String NODE_ID = "id";
    public static final String NODE_API_LEVEL = "api-level";
    public static final String NODE_MANUFACTURER = "manufacturer";
    public static final String NODE_TAG_ID = "tag-id";
    public static final String NODE_BOOT_PROPS = "boot-props";
    public static final String NODE_BOOT_PROP = "boot-prop";
    public static final String NODE_PROP_NAME = "prop-name";
    public static final String NODE_PROP_VALUE = "prop-value";
    public static final String NODE_SKIN = "skin";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_NAME = "name";

    public static String getSchemaUri(int version) {
        return String.format("http://schemas.android.com/sdk/devices/%d", version);
    }

    public static InputStream getXsdStream(int version) {
        assert (version >= 1 && version <= 2) : "Unexpected schema version " + version;
        String rootElement = NODE_DEVICES;
        String filename = String.format("%1$s-%2$d.xsd", rootElement, version);
        try {
            return DeviceSchema.class.getResourceAsStream(filename);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(InputStream deviceXml, OutputStream out, File parent) {
        PrintWriter writer = new PrintWriter(out);
        try {
            int version;
            if (!(deviceXml instanceof NonClosingInputStream)) {
                deviceXml = new NonClosingInputStream(deviceXml);
                ((NonClosingInputStream)deviceXml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            if ((version = DeviceSchema.getXmlSchemaVersion(deviceXml)) < 1 || version > 2) {
                writer.println(String.format("Devices XSD version %1$d is out of valid range 1..%2$d", version, 2));
                boolean bl = false;
                return bl;
            }
            assert (deviceXml.markSupported());
            Schema schema = DeviceSchema.getSchema(version);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            DevicesValidationHandler devicesValidator = new DevicesValidationHandler(parent, writer);
            SAXParser parser = factory.newSAXParser();
            deviceXml.reset();
            parser.parse(deviceXml, (DefaultHandler)devicesValidator);
            boolean bl = devicesValidator.isValidDevicesFile();
            return bl;
        }
        catch (SAXException e) {
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ParserConfigurationException e) {
            writer.println("Error creating SAX parser:");
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            writer.println("Error reading file stream:");
            writer.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            writer.flush();
        }
    }

    @Nullable
    public static Schema getSchema(int version) throws SAXException {
        InputStream xsdStream = DeviceSchema.getXsdStream(version);
        if (xsdStream == null) {
            return null;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        return schema;
    }

    public static int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            assert (xml.markSupported());
            xml.reset();
            if (!(xml instanceof NonClosingInputStream)) {
                xml = new NonClosingInputStream(xml);
                ((NonClosingInputStream)xml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile(NS_DEVICES_URI_PATTERN);
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!NODE_DEVICES.equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private static class DevicesValidationHandler
    extends DefaultHandler {
        private boolean mValidDevicesFile = true;
        private boolean mDefaultSeen = false;
        private String mDeviceName;
        private final File mDirectory;
        private final PrintWriter mWriter;
        private final StringBuilder mStringAccumulator = new StringBuilder();

        public DevicesValidationHandler(File directory, PrintWriter writer) {
            this.mDirectory = directory;
            this.mWriter = writer;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String val;
            if (DeviceSchema.NODE_DEVICE.equals(localName)) {
                this.mDefaultSeen = false;
            } else if (DeviceSchema.NODE_STATE.equals(localName) && (val = attributes.getValue(DeviceSchema.ATTR_DEFAULT)) != null && ("1".equals(val) || Boolean.parseBoolean(val))) {
                if (this.mDefaultSeen) {
                    this.validationError("More than one default state for device " + this.mDeviceName);
                } else {
                    this.mDefaultSeen = true;
                }
            }
            this.mStringAccumulator.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.mStringAccumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (DeviceSchema.NODE_DEVICE.equals(localName) && !this.mDefaultSeen) {
                this.validationError("No default state for device " + this.mDeviceName);
            } else if ("name".equals(localName)) {
                this.mDeviceName = this.mStringAccumulator.toString().trim();
            } else if (DeviceSchema.NODE_PATH.equals(localName) || DeviceSchema.NODE_SIXTY_FOUR.equals(localName) || DeviceSchema.NODE_SIXTEEN.equals(localName)) {
                if (this.mDirectory == null) {
                    this.validationError("No parent directory given, but relative paths exist.");
                    return;
                }
                String relativePath = this.mStringAccumulator.toString().trim();
                File f = new File(this.mDirectory, relativePath);
                if (f == null || !f.isFile()) {
                    this.validationError(relativePath + " is not a valid path.");
                    return;
                }
                String fileName = f.getName();
                int extensionStart = fileName.lastIndexOf(46);
                if (extensionStart == -1 || !fileName.substring(extensionStart + 1).equals("png")) {
                    this.validationError(relativePath + " is not a valid file type.");
                }
            }
        }

        @Override
        public void error(SAXParseException e) {
            this.validationError(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.validationError(e.getMessage());
        }

        public boolean isValidDevicesFile() {
            return this.mValidDevicesFile;
        }

        private void validationError(String reason) {
            this.mWriter.println("Error: " + reason);
            this.mValidDevicesFile = false;
        }
    }
}

