/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.DeviceConnection;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.ThemeModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.models.Window;
import com.android.hierarchyviewerlib.ui.util.PsdFile;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DeviceBridge {
    public static final String TAG = "hierarchyviewer";
    private static final int DEFAULT_SERVER_PORT = 4939;
    private static final int SERVICE_CODE_START_SERVER = 1;
    private static final int SERVICE_CODE_STOP_SERVER = 2;
    private static final int SERVICE_CODE_IS_SERVER_RUNNING = 3;
    private static AndroidDebugBridge sBridge;
    private static final HashMap<IDevice, Integer> sDevicePortMap;
    private static final HashMap<IDevice, ViewServerInfo> sViewServerInfo;
    private static int sNextLocalPort;

    public static void acquireBridge(AndroidDebugBridge bridge) {
        sBridge = bridge;
    }

    public static void initDebugBridge(String adbLocation) {
        if (sBridge == null) {
            AndroidDebugBridge.init(HierarchyViewerDirector.isUsingDdmProtocol());
        }
        if (sBridge == null || !sBridge.isConnected()) {
            sBridge = AndroidDebugBridge.createBridge(adbLocation, true);
        }
    }

    public static void terminate() {
        AndroidDebugBridge.terminate();
    }

    public static IDevice[] getDevices() {
        if (sBridge == null) {
            return new IDevice[0];
        }
        return sBridge.getDevices();
    }

    public static void startListenForDevices(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.addDeviceChangeListener(listener);
    }

    public static void stopListenForDevices(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.removeDeviceChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupDeviceForward(IDevice device) {
        HashMap<IDevice, Integer> hashMap = sDevicePortMap;
        synchronized (hashMap) {
            if (device.getState() == IDevice.DeviceState.ONLINE) {
                int localPort = sNextLocalPort++;
                try {
                    device.createForward(localPort, 4939);
                    sDevicePortMap.put(device, localPort);
                }
                catch (TimeoutException e) {
                    Log.e(TAG, "Timeout setting up port forwarding for " + device);
                }
                catch (AdbCommandRejectedException e) {
                    Log.e(TAG, String.format("Adb rejected forward command for device %1$s: %2$s", device, e.getMessage()));
                }
                catch (IOException e) {
                    Log.e(TAG, String.format("Failed to create forward for device %1$s: %2$s", device, e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceForward(IDevice device) {
        HashMap<IDevice, Integer> hashMap = sDevicePortMap;
        synchronized (hashMap) {
            Integer localPort = sDevicePortMap.get(device);
            if (localPort != null) {
                try {
                    device.removeForward(localPort, 4939);
                    sDevicePortMap.remove(device);
                }
                catch (TimeoutException e) {
                    Log.e(TAG, "Timeout removing port forwarding for " + device);
                }
                catch (AdbCommandRejectedException e) {
                }
                catch (IOException e) {
                    Log.e(TAG, String.format("Failed to remove forward for device %1$s: %2$s", device, e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeviceLocalPort(IDevice device) {
        HashMap<IDevice, Integer> hashMap = sDevicePortMap;
        synchronized (hashMap) {
            Integer port = sDevicePortMap.get(device);
            if (port != null) {
                return port;
            }
            Log.e(TAG, "Missing forwarded port for " + device.getSerialNumber());
            return -1;
        }
    }

    public static boolean isViewServerRunning(IDevice device) {
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                ViewServerInfo serverInfo;
                device.executeShellCommand(DeviceBridge.buildIsServerRunningShellCommand(), new BooleanResultReader(result));
                if (!result[0] && (serverInfo = DeviceBridge.loadViewServerInfo(device)) != null && serverInfo.protocolVersion > 2) {
                    result[0] = true;
                }
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "Timeout checking status of view server on device " + device);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to check status of view server on device " + device);
        }
        catch (AdbCommandRejectedException e) {
            Log.e(TAG, "Adb rejected command to check status of view server on device " + device);
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.e(TAG, "Unable to execute command to check status of view server on device " + device);
        }
        return result[0];
    }

    public static boolean startViewServer(IDevice device) {
        return DeviceBridge.startViewServer(device, 4939);
    }

    public static boolean startViewServer(IDevice device, int port) {
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                device.executeShellCommand(DeviceBridge.buildStartServerShellCommand(port), new BooleanResultReader(result));
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "Timeout starting view server on device " + device);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to start view server on device " + device);
        }
        catch (AdbCommandRejectedException e) {
            Log.e(TAG, "Adb rejected command to start view server on device " + device);
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.e(TAG, "Unable to execute command to start view server on device " + device);
        }
        return result[0];
    }

    public static boolean stopViewServer(IDevice device) {
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                device.executeShellCommand(DeviceBridge.buildStopServerShellCommand(), new BooleanResultReader(result));
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "Timeout stopping view server on device " + device);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to stop view server on device " + device);
        }
        catch (AdbCommandRejectedException e) {
            Log.e(TAG, "Adb rejected command to stop view server on device " + device);
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.e(TAG, "Unable to execute command to stop view server on device " + device);
        }
        return result[0];
    }

    private static String buildStartServerShellCommand(int port) {
        return String.format("service call window %d i32 %d", 1, port);
    }

    private static String buildStopServerShellCommand() {
        return String.format("service call window %d", 2);
    }

    private static String buildIsServerRunningShellCommand() {
        return String.format("service call window %d", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewServerInfo loadViewServerInfo(IDevice device) {
        String line;
        int server = -1;
        int protocol = -1;
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(device);
            connection.sendCommand("SERVER");
            line = connection.getInputStream().readLine();
            if (line != null) {
                server = Integer.parseInt(line);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to get view server version from device " + device);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = null;
        try {
            connection = new DeviceConnection(device);
            connection.sendCommand("PROTOCOL");
            line = connection.getInputStream().readLine();
            if (line != null) {
                protocol = Integer.parseInt(line);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to get view server protocol version from device " + device);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        if (server == -1 || protocol == -1) {
            return null;
        }
        ViewServerInfo returnValue = new ViewServerInfo(server, protocol);
        HashMap<IDevice, ViewServerInfo> hashMap = sViewServerInfo;
        synchronized (hashMap) {
            sViewServerInfo.put(device, returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewServerInfo getViewServerInfo(IDevice device) {
        HashMap<IDevice, ViewServerInfo> hashMap = sViewServerInfo;
        synchronized (hashMap) {
            return sViewServerInfo.get(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeViewServerInfo(IDevice device) {
        HashMap<IDevice, ViewServerInfo> hashMap = sViewServerInfo;
        synchronized (hashMap) {
            sViewServerInfo.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] loadWindows(IHvDevice hvDevice, IDevice device) {
        ArrayList<Window> windows = new ArrayList<Window>();
        DeviceConnection connection = null;
        ViewServerInfo serverInfo = DeviceBridge.getViewServerInfo(device);
        try {
            String line;
            connection = new DeviceConnection(device);
            connection.sendCommand("LIST");
            BufferedReader in = connection.getInputStream();
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int index = line.indexOf(32);
                if (index == -1) continue;
                String windowId = line.substring(0, index);
                int id = serverInfo.serverVersion > 2 ? (int)Long.parseLong(windowId, 16) : Integer.parseInt(windowId, 16);
                Window w = new Window(hvDevice, line.substring(index + 1), id);
                windows.add(w);
            }
            if (serverInfo.protocolVersion < 3) {
                windows.add(Window.getFocusedWindow(hvDevice));
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to load the window list from device " + device);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Window[] returnValue = new Window[windows.size()];
        for (int i = windows.size() - 1; i >= 0; --i) {
            returnValue[returnValue.length - i - 1] = (Window)windows.get(i);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFocusedWindow(IDevice device) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(device);
            connection.sendCommand("GET_FOCUS");
            String line = connection.getInputStream().readLine();
            if (line == null || line.length() == 0) {
                int n = -1;
                return n;
            }
            int n = (int)Long.parseLong(line.substring(0, line.indexOf(32)), 16);
            return n;
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to get the focused window from device " + device);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewNode loadWindowData(Window window) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(window.getDevice());
            connection.sendCommand("DUMP " + window.encode());
            BufferedReader in = connection.getInputStream();
            ViewNode currentNode = DeviceBridge.parseViewHierarchy(in, window);
            ViewServerInfo serverInfo = DeviceBridge.getViewServerInfo(window.getDevice());
            if (serverInfo != null) {
                currentNode.protocolVersion = serverInfo.protocolVersion;
            }
            ViewNode viewNode = currentNode;
            return viewNode;
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to load window data for window " + window.getTitle() + " on device " + window.getDevice());
            Log.e(TAG, e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return null;
    }

    public static ViewNode parseViewHierarchy(BufferedReader in, Window window) {
        ViewNode currentNode = null;
        int currentDepth = -1;
        try {
            String line;
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int depth = 0;
                while (line.charAt(depth) == ' ') {
                    ++depth;
                }
                while (depth <= currentDepth) {
                    if (currentNode != null) {
                        currentNode = currentNode.parent;
                    }
                    --currentDepth;
                }
                currentNode = new ViewNode(window, currentNode, line.substring(depth));
                currentDepth = depth;
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading view hierarchy stream: " + e.getMessage());
            return null;
        }
        if (currentNode == null) {
            return null;
        }
        while (currentNode.parent != null) {
            currentNode = currentNode.parent;
        }
        return currentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProfileData(Window window, ViewNode viewNode) {
        DeviceConnection connection = null;
        try {
            int protocol;
            connection = new DeviceConnection(window.getDevice());
            connection.sendCommand("PROFILE " + window.encode() + " " + viewNode.toString());
            BufferedReader in = connection.getInputStream();
            HashMap<IDevice, ViewServerInfo> hashMap = sViewServerInfo;
            synchronized (hashMap) {
                protocol = DeviceBridge.sViewServerInfo.get((Object)window.getDevice()).protocolVersion;
            }
            if (protocol < 3) {
                boolean bl = DeviceBridge.loadProfileData(viewNode, in);
                return bl;
            }
            boolean ret = DeviceBridge.loadProfileDataRecursive(viewNode, in);
            if (ret) {
                viewNode.setProfileRatings();
            }
            boolean bl = ret;
            return bl;
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to load profiling data for window " + window.getTitle() + " on device " + window.getDevice());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return false;
    }

    private static boolean loadProfileData(ViewNode node, BufferedReader in) throws IOException {
        String line = in.readLine();
        if (line == null || line.equalsIgnoreCase("-1 -1 -1") || line.equalsIgnoreCase("DONE.")) {
            return false;
        }
        String[] data = line.split(" ");
        node.measureTime = (double)Long.parseLong(data[0]) / 1000.0 / 1000.0;
        node.layoutTime = (double)Long.parseLong(data[1]) / 1000.0 / 1000.0;
        node.drawTime = (double)Long.parseLong(data[2]) / 1000.0 / 1000.0;
        return true;
    }

    public static boolean loadProfileDataRecursive(ViewNode node, BufferedReader in) throws IOException {
        if (!DeviceBridge.loadProfileData(node, in)) {
            return false;
        }
        for (int i = 0; i < node.children.size(); ++i) {
            if (DeviceBridge.loadProfileDataRecursive(node.children.get(i), in)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadCapture(Window window, ViewNode viewNode) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(window.getDevice());
            connection.getSocket().setSoTimeout(5000);
            connection.sendCommand("CAPTURE " + window.encode() + " " + viewNode.toString());
            Image image = new Image((Device)Display.getDefault(), connection.getSocket().getInputStream());
            return image;
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to capture data for node " + viewNode + " in window " + window.getTitle() + " on device " + window.getDevice());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsdFile captureLayers(Window window) {
        DeviceConnection connection = null;
        FilterInputStream in = null;
        try {
            connection = new DeviceConnection(window.getDevice());
            connection.sendCommand("CAPTURE_LAYERS " + window.encode());
            in = new DataInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            PsdFile psdFile = DeviceBridge.parsePsd((DataInputStream)in);
            return psdFile;
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to capture layers for window " + window.getTitle() + " on device " + window.getDevice());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                connection.close();
            }
        }
        return null;
    }

    public static PsdFile parsePsd(DataInputStream in) throws IOException {
        int width = in.readInt();
        int height = in.readInt();
        PsdFile psd = new PsdFile(width, height);
        while (DeviceBridge.readLayer(in, psd)) {
        }
        return psd;
    }

    private static boolean readLayer(DataInputStream in, PsdFile psd) {
        try {
            if (in.read() == 2) {
                return false;
            }
            String name = in.readUTF();
            boolean visible = in.read() == 1;
            int x = in.readInt();
            int y = in.readInt();
            int dataSize = in.readInt();
            byte[] data = new byte[dataSize];
            for (int read = 0; read < dataSize; read += in.read(data, read, dataSize - read)) {
            }
            ByteArrayInputStream arrayIn = new ByteArrayInputStream(data);
            BufferedImage chunk = ImageIO.read(arrayIn);
            BufferedImage image = new BufferedImage(chunk.getWidth(), chunk.getHeight(), 2);
            Graphics2D g = image.createGraphics();
            g.drawImage(chunk, null, 0, 0);
            g.dispose();
            psd.addLayer(name, image, new Point(x, y), visible);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateView(ViewNode viewNode) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(viewNode.window.getDevice());
            connection.sendCommand("INVALIDATE " + viewNode.window.encode() + " " + viewNode);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to invalidate view " + viewNode + " in window " + viewNode.window + " on device " + viewNode.window.getDevice());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestLayout(ViewNode viewNode) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(viewNode.window.getDevice());
            connection.sendCommand("REQUEST_LAYOUT " + viewNode.window.encode() + " " + viewNode);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to request layout for node " + viewNode + " in window " + viewNode.window + " on device " + viewNode.window.getDevice());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputDisplayList(ViewNode viewNode) {
        DeviceConnection connection = null;
        try {
            connection = new DeviceConnection(viewNode.window.getDevice());
            connection.sendCommand("OUTPUT_DISPLAYLIST " + viewNode.window.encode() + " " + viewNode);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to dump displaylist for node " + viewNode + " in window " + viewNode.window + " on device " + viewNode.window.getDevice());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThemeModel dumpTheme(ViewNode viewNode) {
        DeviceConnection connection = null;
        ThemeModel model = null;
        try {
            connection = new DeviceConnection(viewNode.window.getDevice());
            connection.sendCommand("DUMP_THEME " + viewNode.window.encode() + " " + viewNode);
            BufferedReader in = connection.getInputStream();
            model = DeviceBridge.parseThemeDump(in);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to dump theme for node " + viewNode + " in window " + viewNode.window + " on device " + viewNode.window.getDevice());
            ThemeModel themeModel = null;
            return themeModel;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return model;
    }

    public static ThemeModel parseThemeDump(BufferedReader in) {
        ThemeModel model = new ThemeModel();
        try {
            String resourceName;
            while ((resourceName = in.readLine()) != null && !"DONE.".equalsIgnoreCase(resourceName)) {
                String resourceValue = in.readLine();
                if (resourceValue == null) {
                    return null;
                }
                model.add(resourceName, resourceValue);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading theme dump: " + e.getMessage());
            return null;
        }
        return model;
    }

    static {
        sDevicePortMap = new HashMap();
        sViewServerInfo = new HashMap();
        sNextLocalPort = 4939;
    }

    private static class BooleanResultReader
    extends MultiLineReceiver {
        private final boolean[] mResult;

        public BooleanResultReader(boolean[] result) {
            this.mResult = result;
        }

        @Override
        public void processNewLines(String[] strings) {
            Pattern pattern;
            Matcher matcher;
            if (strings.length > 0 && (matcher = (pattern = Pattern.compile(".*?\\([0-9]{8} ([0-9]{8}).*")).matcher(strings[0])).matches() && Integer.parseInt(matcher.group(1)) == 1) {
                this.mResult[0] = true;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    public static class ViewServerInfo {
        public final int protocolVersion;
        public final int serverVersion;

        ViewServerInfo(int serverVersion, int protocolVersion) {
            this.protocolVersion = protocolVersion;
            this.serverVersion = serverVersion;
        }
    }
}

