/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class GotoGotoReplacer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public GotoGotoReplacer(CodeAttributeEditor codeAttributeEditor) {
        this(codeAttributeEditor, null);
    }

    public GotoGotoReplacer(CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        if (by == -89 || by == -56) {
            int n2 = branchInstruction.branchOffset;
            int n3 = n + n2;
            if (n2 != 0 && n2 != branchInstruction.length(n) && !this.codeAttributeEditor.isModified(n) && !this.codeAttributeEditor.isModified(n3)) {
                Instruction instruction = InstructionFactory.create(codeAttribute.code, n3);
                if (instruction.opcode == -89) {
                    int n4 = ((BranchInstruction)instruction).branchOffset;
                    BranchInstruction branchInstruction2 = new BranchInstruction(by, n2 + n4);
                    this.codeAttributeEditor.replaceInstruction(n, branchInstruction2);
                    if (this.extraInstructionVisitor != null) {
                        this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
                    }
                }
            }
        }
    }
}

