/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.ast.ClassDeclaration;
import org.w3c.dom.Element;

public class PreferenceActivityDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("ExportedPreferenceActivity", "PreferenceActivity should not be exported", "Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", Category.SECURITY, 8, Severity.WARNING, new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String fqcn;
        if (SecurityDetector.getExported(element) && (fqcn = PreferenceActivityDetector.getFqcn(element)) != null) {
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, element)) {
                String message = "`PreferenceActivity` should not be exported";
                context.report(ISSUE, context.getLocation(element), message);
            }
            this.mExportedActivities.put(fqcn, context.createLocationHandle(element));
        }
    }

    private static String getFqcn(@NonNull Element activityElement) {
        String activityClassName = activityElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (activityClassName == null || activityClassName.isEmpty()) {
            return null;
        }
        if (activityClassName.startsWith(".")) {
            String pkg = activityElement.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (pkg != null) {
                return pkg + activityClassName;
            }
            return null;
        }
        return activityClassName;
    }

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(PREFERENCE_ACTIVITY);
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull ClassDeclaration node, @NonNull JavaParser.ResolvedClass resolvedClass) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        String className = resolvedClass.getName();
        if (resolvedClass.isSubclassOf(PREFERENCE_ACTIVITY, false) && this.mExportedActivities.containsKey(className)) {
            if (context.getMainProject().getTargetSdk() >= 19 && PreferenceActivityDetector.overridesIsValidFragment(resolvedClass)) {
                return;
            }
            String message = String.format("`PreferenceActivity` subclass `%1$s` should not be exported", className);
            context.report(ISSUE, this.mExportedActivities.get(className).resolve(), message);
        }
    }

    private static boolean overridesIsValidFragment(JavaParser.ResolvedClass resolvedClass) {
        Iterable<JavaParser.ResolvedMethod> resolvedMethods = resolvedClass.getMethods(IS_VALID_FRAGMENT, false);
        for (JavaParser.ResolvedMethod resolvedMethod : resolvedMethods) {
            if (resolvedMethod.getArgumentCount() != 1 || !resolvedMethod.getArgumentType(0).getName().equals("java.lang.String")) continue;
            return true;
        }
        return false;
    }
}

