/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import org.w3c.dom.Element;

public class TooManyViewsDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION;
    public static final Issue TOO_MANY;
    public static final Issue TOO_DEEP;
    private static final int MAX_VIEW_COUNT;
    private static final int MAX_DEPTH;
    private int mViewCount;
    private int mDepth;
    private boolean mWarnedAboutDepth;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        this.mDepth = 0;
        this.mViewCount = 0;
        this.mWarnedAboutDepth = false;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String msg;
        ++this.mViewCount;
        ++this.mDepth;
        if (this.mDepth == MAX_DEPTH && !this.mWarnedAboutDepth) {
            this.mWarnedAboutDepth = true;
            msg = String.format("`%1$s` has more than %2$d levels, bad for performance", context.file.getName(), MAX_DEPTH);
            context.report(TOO_DEEP, element, context.getLocation(element), msg);
        }
        if (this.mViewCount == MAX_VIEW_COUNT) {
            msg = String.format("`%1$s` has more than %2$d views, bad for performance", context.file.getName(), MAX_VIEW_COUNT);
            context.report(TOO_MANY, element, context.getLocation(element), msg);
        }
    }

    @Override
    public void visitElementAfter(@NonNull XmlContext context, @NonNull Element element) {
        --this.mDepth;
    }

    static {
        String depthValue;
        IMPLEMENTATION = new Implementation(TooManyViewsDetector.class, Scope.RESOURCE_FILE_SCOPE);
        TOO_MANY = Issue.create("TooManyViews", "Layout has too many views", "Using too many views in a single layout is bad for performance. Consider using compound drawables or other tricks for reducing the number of views in this layout.\n\nThe maximum view count defaults to 80 but can be configured with the environment variable `ANDROID_LINT_MAX_VIEW_COUNT`.", Category.PERFORMANCE, 1, Severity.WARNING, IMPLEMENTATION);
        TOO_DEEP = Issue.create("TooDeepLayout", "Layout hierarchy is too deep", "Layouts with too much nesting is bad for performance. Consider using a flatter layout (such as `RelativeLayout` or `GridLayout`).The default maximum depth is 10 but can be configured with the environment variable `ANDROID_LINT_MAX_DEPTH`.", Category.PERFORMANCE, 1, Severity.WARNING, IMPLEMENTATION);
        int maxViewCount = 0;
        int maxDepth = 0;
        String countValue = System.getenv("ANDROID_LINT_MAX_VIEW_COUNT");
        if (countValue != null) {
            try {
                maxViewCount = Integer.parseInt(countValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((depthValue = System.getenv("ANDROID_LINT_MAX_DEPTH")) != null) {
            try {
                maxDepth = Integer.parseInt(depthValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (maxViewCount == 0) {
            maxViewCount = 80;
        }
        if (maxDepth == 0) {
            maxDepth = 10;
        }
        MAX_VIEW_COUNT = maxViewCount;
        MAX_DEPTH = maxDepth;
    }
}

