/**
 * 更新用户信息缓存
 */
function updateUser(){
    $.ajax({
        url: '/home/vip/updateUser',
        data: {
            t: Date.parse(new Date())
        },
        async: false,
        type: 'POST',
        success: function (res) {
            if(res.code == 401){
                return false;
            }else if(res.code == 1 ){
                deleteUser();
                localStorage.setItem('userinfo', JSON.stringify(res.data));
                return true;
            }else{
                return false;
            }
        }
    });
}


// 更新用户信息缓存值
/**
 * 更新用户的本地缓存
 * 如果系统给用户赠送会员，或蚁币，系统无法更新用户本地缓存，执行这个方法，更新用户本地缓存
 * */
$(document).ready(function(){
    if( getUser() === false ){
    }else{
        $.post('/member/sj/gengJson',{"userid":getUser().id},function(msg){
            if(msg.code ==1){
                updateUser();
            }
        },'json');
    }
});



/**
 * 获取用户信息缓存
 *
 */
function getUser(){
    var userinfo = localStorage.getItem('userinfo');
    if (userinfo) {
        var this_data = JSON.parse(userinfo);
        if( this_data.extend != '' ){
            this_data.extend = (typeof this_data.extend == 'string') ? JSON.parse(this_data.extend) : this_data.extend
        }
        return this_data;
    }else{
        return false;
    }
}

/**
 * 删除用户信息缓存
 */
function deleteUser() {
    localStorage.removeItem('userinfo');
}

// ajax公共请求方法
// 带token
function get_ajax(args, url, method, async, callback) {
    var tokenData = localStorage.getItem('token_data');
    tokenData = (typeof tokenData == 'string') ? $.parseJSON(tokenData):tokenData;
    Object.assign(args,token);
    $.ajax({
        'url': url,
        'data': args,
        'type': method,
        "async": async,
        success: function(result) {
            result = (typeof result == 'string') ? $.parseJSON(result):result;
                var stast = localStorage.getItem('is_login');
                stast = Number(Boolean(stast));
                if (result.code == 103) {
                    localStorage.removeItem('token_data');
                    var user_id = localStorage.getItem('user_id');
                    get_ajax({id:user_id}, api_domain + '/apimember/login/logout', 'post', true, function (result) {

                    });
                    var new_stat = Number(stast) + 1;
                    localStorage.setItem('is_login',new_stat);
                    stast = localStorage.getItem('is_login');
                    if(new_stat <= 1){
                        localStorage.removeItem('is_login');
                        layer.msg('请先登录',{time:1500});
                        setTimeout(function(){
                            window.location.href="/"
                        }, 800);
                    }
                }else if (result.code == 102) {
                    getToken();
                }else{
                    callback(result);
                }
        }
    });
};
// 不带token
function index_ajax(args, url, method, async, callback) {
    $.ajax({
        'url': url,
        'data': args,
        'type': method,
        "async": async,
        success: function(result){
            if( result != '' ){
                var temp_result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                if (temp_result.code == 401) {
                    layer.msg(temp_result.msg);
                    deleteUser();
                    return false;
                }
                callback(result);
            }
        }
    });
};

// 不带token
function form_index_ajax(args, url, method, async, callback) {
    $.ajax({
        'url': url,
        'data': args,
        'type': method,
        "async": async,
        processData: false,
        contentType: false,
        success: function(result){
            if( result != '' ){
                var temp_result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                if (temp_result.code == 401) {
                    layer.msg(temp_result.msg);
                    deleteUser();
                    return false;
                }
                callback(result);
            }
        }
    });
};

// 时间倒计时自定义函数 
function getCountDowns(clas, timestamp) {
    is_intval = setInterval(function() {
        var nowTime = new Date();
        var endTime = new Date(timestamp * 1000);
        var t = endTime.getTime() - nowTime.getTime();
        var day = parseInt(t / 1000 / 60 / 60 / 24);
        var hour = Math.floor(t / 1000 / 60 / 60 % 24);
        var min = Math.floor(t / 1000 / 60 % 60);
        var sec = Math.floor(t / 1000 % 60);

        if (sec < 0) {
            clearInterval(is_intval);
            $(clas).find('.time-d').html('00');
            $(clas).find('.time-h').html('00');
            $(clas).find('.time-m').html('00');
            $(clas).find('.time-s').html('00');
            return false;
        }

        if (sec < 10) {
            sec = "0" + sec;
        }

        var countDownDay = day;
        var countDownHour = hour;
        var countDownMin = min;
        var countDownSec = sec;
        $(clas).find('.time-d').html(countDownDay);
        $(clas).find('.time-h').html(countDownHour);
        $(clas).find('.time-m').html(countDownMin);
        $(clas).find('.time-s').html(countDownSec);
    }, 1000);
};


// 时间戳转化时间字符串
function get_timepoint(date) {
    //如果date为13位不需要乘1000
    var date = new Date(date * 1000);
    var Y = date.getFullYear() + '-';
    var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
    var D = (date.getDate() < 10 ? '0' + (date.getDate()) : date.getDate()) + ' ';
    var h = (date.getHours() < 10 ? '0' + date.getHours() : date.getHours()) + ':';
    var m = (date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()) + ':';
    var s = (date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds());
    return Y + M + D + h + m + s;
}


// 获取时间后进行时间字符串切割 get_timepoint(item.update_time).slice(0, 11)
// 时间字符串转时间戳
function get_timestamp(time) {
    var time = time.replace(/-/g, '/');
    time = (new Date(time).getTime()) / 1000;
    return time;
}


// html转字符串
function get_string(str) {
    str = str.replace(/&/g, '&amp;');
    str = str.replace(/</g, '&lt;');
    str = str.replace(/>/g, '&gt;');
    str = str.replace(/"/g, '&quot;');
    str = str.replace(/'/g, '&#039;');
    return str;
};


// 字符串转html
function get_html(string, quote_style) {
    var optTemp = 0,
        i = 0,
        noquotes = false;
    if (typeof quote_style === 'undefined') {
        quote_style = 2;
    }
    string = string.toString().replace(/&lt;/g, '<').replace(/&gt;/g, '>');
    var OPTS = {
        'ENT_NOQUOTES': 0,
        'ENT_HTML_QUOTE_SINGLE': 1,
        'ENT_HTML_QUOTE_DOUBLE': 2,
        'ENT_COMPAT': 2,
        'ENT_QUOTES': 3,
        'ENT_IGNORE': 4
    };
    if (quote_style === 0) {
        noquotes = true;
    }
    if (typeof quote_style !== 'number') {
        quote_style = [].concat(quote_style);
        for (i = 0; i < quote_style.length; i++) {
            if (OPTS[quote_style[i]] === 0) {
                noquotes = true;
            } else if (OPTS[quote_style[i]]) {
                optTemp = optTemp | OPTS[quote_style[i]];
            }
        }
        quote_style = optTemp;
    }
    if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
        string = string.replace(/&#0*39;/g, "'");
    }
    if (!noquotes) {
        string = string.replace(/&quot;/g, '"');
    }
    string = string.replace(/&amp;/g, '&');
    return string;
}


// 判断当前浏览器
function get_browser() {
    var ua = navigator.userAgent.toLowerCase();
    var is = 'IE浏览器';
    if (isIE()) {
        is = 'IE浏览器';
        return is;
    }
    if (ua.indexOf("chrome") > 1) {
        is = '谷歌浏览器';
    }
    if (ua.indexOf("safari") > 1 && ua.indexOf("macintosh") > 1) {
        is = 'Safari浏览器';
        return is;
    }
    if (ua.indexOf("firefox") > 1) {
        is = '火狐浏览器';
        var reg = /firefox\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(")", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if (ua.indexOf("opr") > 1) {
        is = '欧朋浏览器';
        var reg = /opr\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(";", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if ((ua.indexOf("ubrowser") > 1 && ua.indexOf("ubrowser") == 95) || (ua.indexOf("ubrowser") > 1 && ua.indexOf("ubrowser") == 58)) {
        is = 'UC浏览器';
        var reg = /ubrowser\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(")", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if (ua.indexOf("metasr") > 1) {
        is = '搜狗浏览器';
        return is;
    }
    if (ua.indexOf("qqbrowser") > 1) {
        is = 'QQ浏览器';
        var reg = /qqbrowser\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(";", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if (ua.indexOf("maxthon") > 1) {
        is = '遨游浏览器';
        var reg = /maxthon\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(";", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if (ua.indexOf("bidubrowser") > 1) {
        is = '百度浏览器';
        if (ua.indexOf("chrome") > 1) {
            var reg = /bidubrowser\/([^ ]*)/;
            var b = reg.exec(ua);
            if (b && b[1]) {
                b[1] = b[1].replace(";", "");
                return is + b[1];
            } else {
                return is;
            }
        } else {
            var reg = /bidubrowser ([^)]*)/;
            var b = reg.exec(ua);
            if (b && b[1]) {
                b[1] = b[1].replace(";", "");
                return is + b[1];
            } else {
                return is;
            }
        }
    }
    if (ua.indexOf("2345explorer") > 1) {
        is = '2345浏览器';
        var reg = /2345explorer\/([^ ]*)/;
        var b = reg.exec(ua);
        if (b && b[1]) {
            b[1] = b[1].replace(";", "");
            return is + b[1];
        } else {
            return is;
        }
    }
    if (ua.indexOf("lbbrowser") > 1) {
        is = '猎豹浏览器';
        return is;
    }
    if (ua.indexOf("edge") > 1) {
        is = 'Edge浏览器';
        return is;
    }
    var is360 = _mime("type", "application/vnd.chromium.remoting-viewer");
    if (ua.indexOf("chrome") > 1 && is360) {
        is = '360浏览器';
        return is;
    }
    return is;
}
function _mime(option, value) {
    var mimeTypes = navigator.mimeTypes;
    for (var mt in mimeTypes) {
        if (mimeTypes[mt][option] == value) {
            return true;
        }
    }
    return false;
}
// 此方法兼容最新的IE11，IE10
function isIE() {
    if (!!window.ActiveXObject || "ActiveXObject" in window){
        return true;
    }else{
        return false;
    }
}

// 去除数组中重复数据 
function get_single(array) {
    var newArr = []; //一个新的临时数组
    for (var i = 0; i < array.length; i++) {
        if (newArr.indexOf(array[i]) == -1) {
            newArr.push(array[i]);
        }
    }
    return newArr;
}


// 限制输入数字最多两位小数
function get_twonum(obj) {
    obj.value = obj.value.replace(/[^\d.]/g, "");
    obj.value = obj.value.replace(/\.{2,}/g, ".");
    obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
    obj.value = obj.value.replace(/^(\-)*(\d+)\.(\d\d).*$/, '$1$2.$3');
    if (obj.value.indexOf(".") < 0 && obj.value != "") {
        obj.value = parseFloat(obj.value);
    }
}


// 颜色RGB转16进制
function get_color16(color) {
    var rgb = color.split(',');
    var r = parseInt(rgb[0].split('(')[1]);
    var g = parseInt(rgb[1]);
    var b = parseInt(rgb[2].split(')')[0]);
    var hex = "#" + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
    return hex;
}


// 16进制转rgba
function get_colorrgb(sColor) {
    var sColor = sColor.toLowerCase();
    var reg = /^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$/;
    if (sColor && reg.test(sColor)) {
        if (sColor.length === 4) {
            var sColorNew = "#";
            for (var i = 1; i < 4; i += 1) {
                sColorNew += sColor.slice(i, i + 1).concat(sColor.slice(i, i + 1));
            }
            sColor = sColorNew;
        }
        var sColorChange = [];
        for (var i = 1; i < 7; i += 2) {
            sColorChange.push(parseInt("0x" + sColor.slice(i, i + 2)));
        }
        return "RGB(" + sColorChange.join(",") + ")";
    } else {
        return sColor;
    }
}


// 解析url
function get_url() {
    var search = window.location.search.replace('?', '');
    var arr = search.split('&');
    var obj = {};
    $.each(arr, function(index, item) {
        var key = item.split('=')[0];
        var value = item.split('=')[1];
        obj[key] = value;
    })
    return obj;
}


// 图片转base64格式方法
function get_imgbase64(url, callback, outputFormat) {
    var canvas = document.createElement('CANVAS'),
        ctx = canvas.getContext('2d'),
        img = new Image;
    img.setAttribute('crossOrigin', 'anonymous')
    img.src = url + '?time=' + new Date().valueOf();
    img.onload = function() {
        canvas.height = img.height;
        canvas.width = img.width;
        ctx.drawImage(img, 0, 0);
        var dataURL = canvas.toDataURL(outputFormat || 'image/png');
        callback.call(this, dataURL);
        canvas = null;
    };
    img.src = url;
}
// 图片转base64使用案例
// get_imgbase64(ewm_img, function(base64Img){
//     $(body).find('.ewm-show-load').children('a').attr("href",base64Img)
// });

// 删除url中某个参数,并跳转
function funcUrlDel(name) {
    var loca = window.location;
    var baseUrl = loca.origin + loca.pathname + "?";
    var query = loca.search.substr(1);
    if (query.indexOf(name) > -1) {
        var obj = {}
        var arr = query.split("&");
        for (var i = 0; i < arr.length; i++) {
            arr[i] = arr[i].split("=");
            obj[arr[i][0]] = arr[i][1];
        };
        delete obj[name];
        var url = baseUrl + JSON.stringify(obj).replace(/[\"\{\}]/g, "").replace(/\:/g, "=").replace(/\,/g, "&");
        return url
    };
}


// 在当前页面url拼接数据
function changeURLPar(uri, par, par_value) {
    var pattern = par + '=([^&]*)';
    var replaceText = par + '=' + par_value;
    if (uri.match(pattern)) {
        // 如果连接中带这个参数
        var tmp = '/\\' + par + '=[^&]*/';
        tmp = uri.replace(eval(tmp), replaceText);
        return (tmp);
    } else {
        if (uri.match('[\?]')) { // 如果链接中不带这个参数但是有其他参数
            return uri + '&' + replaceText;
        } else { // 如果链接中没有带任何参数
            return uri + '?' + replaceText;
        }
    }
    return uri + '\n' + par + '\n' + par_value;
}


// 获取页面纯文本内容
function searchChild($ele) {
    // 当前元素的文本不包含子元素的值
    var str = $ele.contents().filter(function (index, content) {
        return content.nodeType === 3;
    }).text();
    /*  // 将换行符、回车符、制表符替换为空
     str = str.replace(/[\r\n\t]/g,"");
     // 将首尾空格替换为空
     str = str.replace(/(^\s*)|(\s*$)/g, "");
     if (str != null && str !== "" && str.indexOf(" ") !== 0) {
         console.log(str)
     }*/
     // 中文、英文、数字、-开头或结尾
    var reg = /^[\u4E00-\u9FA5\uf900-\ufa2d]|[0-9a-zA-Z\\/\-\\(\\)]|[\u4E00-\u9FA5\uf900-\ufa2d]$/; 
    if (reg.test(str)) {
        return str;
    }
    // 判断当前元素是否含有子元素
    if($ele.children() != null && $ele.children() !== "") {
        $ele.children().each(function(){
            // 当前元素的标签 tagName默认为大写 转为小写 不为script标签
            if(this.tagName.toLowerCase() !== "script") {
                searchChild($(this));
            }
        });
    }
}


// 压缩图片 signup-img-dele
function uploadImg(parametric) {
    var thisObj = {
        maxWidth: parametric.maxNum || 680,
        rate: parametric.rate || 0.8,
        callback: parametric.callback || function () {
            alert("回调函数未定义!")
        }
    }
    var file = parametric.file;
    if (!file) {
        thisObj.callback(false);
        return false;
    }
    var reader0 = new FileReader();
    var compressBas;
    reader0.readAsDataURL(file); //调用自带方法进行转换
    reader0.onload = function (e) {
        var dataUrl = this.result;//得到base64url
        var fileType = file.type;
        var image = new Image();
        image.src = dataUrl;
        image.onload = function (e) {
            var width = image.width, height = image.height;
            if (width < thisObj.maxWidth) {
                thisObj.maxWidth = width;
            }
            var scale = width / height;
            var canvas = document.createElement("canvas");
            var ctx = canvas.getContext('2d');
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            width1 = thisObj.maxWidth;
            height1 = parseInt(width1 / scale);
            if (width >= width1) {
                canvas.width = width1;
                canvas.height = height1;
                ctx.drawImage(image, 0, 0, width1, height1);
            } else {
                canvas.width = width;
                canvas.height = height;
                ctx.drawImage(image, 0, 0, width, height);
            }
            var cropStr = canvas.toDataURL("image/jpeg", thisObj.rate);
            thisObj.callback(cropStr);
        }
    }
};


// 返回bass64格式图片的大小
function showSize(base64url) {
    //获取base64图片大小，返回MB数字
    var str = base64url.replace('data:image/png;base64,', '')
    .replace('data:image/jpeg;base64,', '')
    .replace('data:image/bmp;base64,', '')
    .replace('data:image/jpg;base64,', '')
    .replace('data:image/gif;base64,', '');
    var equalIndex = str.indexOf('=');
    if(str.indexOf('=')>0) {
        str=str.substring(0, equalIndex);
    }
    var strLength=str.length;
    var fileLength=parseInt(strLength-(strLength/8)*2);
    // 由字节转换为MB
    var size = "";
    size = (fileLength/(1024)).toFixed(2);
    var sizeStr = size + "";                        //转成字符串
    var index = sizeStr.indexOf(".");                    //获取小数点处的索引
    var dou = sizeStr.substr(index + 1 ,2)            //获取小数点后两位的值
    if(dou == "00"){                                //判断后两位是否为00，如果是则删除00                
        return sizeStr.substring(0, index) + sizeStr.substr(index + 3, 2)
    }
    return parseInt(size);
}

/**
 * 转义
 * @param str
 * @returns {XML|string|*}
 */
function get_zhuanyihtml(str) {
    str = str.replace(/&amp;/g, '&');
    str = str.replace(/&lt;/g, '<');
    str = str.replace(/&gt;/g, '>');
    str = str.replace(/&quot;/g, '"');
    str = str.replace(/&#039;/g, "'");
    return str;
}

// 封装使用cookie的方法
function setCookie(name, value) {
    var Days = 7;
    var exp = new Date();
    // 过期时间7天
    exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
    if (typeof document !== 'undefined') {
        document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString() + ";path=/";
    }
    return true
}
function getCookie(name) {
    var arr,
    reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
    if (typeof document !== 'undefined') {
        if (arr = document.cookie.match(reg))
            return unescape(arr[2]);
        else
            return null;
    }
}
function delCookie(name){
    var myDate=new Date();    
    myDate.setTime(-1000);
    document.cookie= name+"=''; expires="+myDate.toGMTString(); 
}


// url 转义方法
function base64_encode(data) {
     var b64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='; 
     var o1, o2, o3, h1, h2, h3, h4, bits, i = 0, ac = 0, enc = '', tmp_arr = [];
      if (!data) { return data; } data = unescape(encodeURIComponent(data)); 
      do { o1 = data.charCodeAt(i++);
         o2 = data.charCodeAt(i++); 
         o3 = data.charCodeAt(i++); 
         bits = o1 << 16 | o2 << 8 | o3;
          h1 = bits >> 18 & 0x3f; 
          h2 = bits >> 12 & 0x3f; 
          h3 = bits >> 6 & 0x3f;
           h4 = bits & 0x3f; 
           tmp_arr[ac++] = b64.charAt(h1) + b64.charAt(h2) + b64.charAt(h3) + b64.charAt(h4); 
        } while (i < data.length);enc = tmp_arr.join(''); var r = data.length % 3; 
        return (r ? enc.slice(0, r - 3) : enc) + '==='.slice(r || 3); 
}

// 定义jq获取html的方法
jQuery.fn.outerHTML = function(s) {
    return (s) ? this.before(s).remove() : $("<Hill_man>").append(this.eq(0).clone()).html();
};
// 给String对象新增  replaceAll 方法
String.prototype.replaceAll = function (s1, s2) {
    return this.replace(new RegExp(s1, "gm"), s2);
};


// 开启加载
// Loading() // 加载
function Loading(){
    var load_html = '<div class="a-load"><i class="layui-icon layui-icon-loading layui-anim layui-anim-rotate layui-anim-loop"></i></div>';
    $('body').append(load_html)
};
// 关闭加载
// LoadClose() // 关闭加载
function LoadClose() {
    $('.a-load').remove();
};


// 公共请求域名
// var api_domain = window.location.origin;
var api_domain = '';


// 提示弹窗
function tips_window(title,cont,top,yesBtn){
    var this_html = '<div class="lf-tips">'+
                        '<div class="lf-tips-main">'+
                            '<div class="lf-tips-head">'+title+'<span><i class="fa fa-times-circle"></i></span></div>'+
                            '<div class="lf-tips-text" style="padding-top:'+top+'px;">'+cont+'</div>'+
                            '<div class="lf-tips-foot"><p class="p1 '+yesBtn+'">确定</p><p class="p2">取消</p></div>'+
                        '</div>'+
                    '</div>'
    $('body').append(this_html);
}
// 提示弹窗:关闭按钮、确定按钮、取消按钮
$(document).on('click','.lf-tips-head span,.lf-tips-foot .p1,.lf-tips-foot .p2',function(){
    $('.lf-tips').remove();
});



//检测字符串是否为空
String.prototype.isEmpty = function () {
    var s1 = this.replace(/[\r\n\u200B]/g, '').replace(/[ ]/g, ''),
        s2 = (s1 == '') ? true : false;
    return s2;
};


    // ------------------------- 右侧公用 -------------------------
    // 移除弹窗 右侧公用
    function dragRemove(item, cont) {
        var layer_left = parseFloat($(cont).css('left'));
        var layer_top = parseFloat($(cont).css('top'));
        var layer_height = parseFloat($(cont).css('height'));
        var layer_width = parseFloat($(cont).css('width'));
        var click_left = item.originalEvent.clientX;
        var click_top = item.originalEvent.clientY;
        var click_width = parseFloat($(item.item).css('width'));
        var click_height = parseFloat($(item.item).css('height'));
        if ((layer_left - click_left) >= click_width ||
            click_left >= (layer_left + layer_width) ||
            layer_top - click_top >= click_height ||
            click_top >= (layer_top + layer_height + click_height)
        ) {
            return true;
        }
    }
    // 弹窗高度变化 右侧公用
    function GroupMheight(demo1, demo2, demo3) {
        // demo1 容器class，demo2 layer弹窗class，demo3 layer弹窗变量
        // 当前内容高度
        var new_height = $(demo1).outerHeight() + 42;
        // 之前内容高度
        var old_height = parseInt($(demo2).css('height'));
        // 之前距离顶部
        var old_top = parseInt($(demo2).css('top'));
        // 换算
        layer.style(demo3, {
            height: new_height + 'px',
            top: old_top - (new_height - old_height) / 2 + 'px'
        });
        $(demo2).find('.layui-layer-content').css({height: (new_height - 42) + 'px'})
    }

    // 数组中是否有重复数据
    function isRepeat(arr) {
        var hash = {};
        for (var i in arr) {
            if (hash[arr[i]])
                return true;
            hash[arr[i]] = true;
        }
        return false;
    }


    // ------------------------- 秒刷 -------------------------
    // 带编号素材写入修改编号
    function trim(str) {
        return str.replace(/(^[ \t\n\r]+)|([ \t\n\r]+$)/g, '');
    }
    // 编号修改
    function titleInc(html){
        //数字排序
        var num, className, state = 0;
        if ($(html).find(".autosort").length > 0) {
            className = ".autosort";
        } else if ($(html).find(".autosort1").length > 0) {
            className = ".autosort1";
        } else if ($(html).find(".autosort2").length > 0) {
            className = ".autosort2";
        } else if ($(html).find(".autosort3").length > 0) {
            className = ".autosort3";
        } else if ($(html).find(".autosort4").length > 0) {
            className = ".autosort4";
        }
        //都不存在，为尚未更改的素材延用原有方法排序
        else {
            var html2, html_str;
            html_str = $(html).html();
            if (html_str == undefined) {
                return true;
            }
            //改造
            html2 = html_str.replace(/<!-- -->(\d*)<!-- -->/g, function (substring, serial_num) {
                return "<!-- -->" + (parseInt(serial_num) + 1) + "<!-- -->";
            });
            html2 = html2.replace(/<!--  -->(\d*)<!--  -->/g, function (substring, serial_num) {
                return "<!--  -->" + (parseInt(serial_num) + 1) + "<!--  -->";
            });
            $(html).html(html2);
            return false;
        }
        $.each($(html).find(className), function (k, v) {
            var text = trim($(v).html());
            state = 1;
            //整形
            if (/^\d*$/.exec(text)) {
                $(v).html(parseInt(text) + 1);
            }
            //小写英文
            else if (/^[a-z]*$/.exec(text)) {
                num = smallenglishNumSort(text);
                $(v).html(num);
            }
            //大写英文
            else if (/^[A-Z]*$/.exec(text)) {
                num = englishNumSort(text);
                $(v).html(num);
            }
            //中文
            else if (/^[\u4E00-\u9FA5]*$/.exec(text)) {
                var state = 1;
                num = ChineseToNumber(text);
                if (!num) {
                    state = 2;
                    // 校验是否为繁体中文
                    num = ChineseToNumber(text, 2);
                }
                $(v).html(SectionToChinese(num + 1, state));
                num++;
            }
        });
        return false;
    }
    // 秒刷写入编辑器
    function secondBrush(_this,type) {
        var rangeLength = ue.selection.getRange().endOffset;
        var textLength = _this.find(".xmybrush").length;
        var imgLength = _this.find("img.brushimg").length;
        var startIndex = 0;
        var imgIndex = 0;
        var innertext = _this.html();
        // 遍历当前选区中的节点
        ue.selection.getRange().adjustmentBoundary().traversal(function (node) {
            console.log(node);
            var isHasImg = 0;
            // 秒刷音乐
            if (node.localName == "ifarme") {
                if (node.className == "qqmusic_iframe") {
                    $(_this).find(".brushmusic:first").outerHTML($(node).outerHTML());
                }
                if (node.className == "video_iframe") {
                    $(_this).find("[onmouseup='crsp(this,event)']:first").outerHTML($(node).outerHTML());
                }
            }
            var qqmusic = $(node).find("iframe.qqmusic_iframe");
            if (qqmusic.length > 0) {
                $.each(qqmusic, function (key, val) {
                    if ($(_this).find(".brushmusic").length > 0) {
                        $(_this).find(".brushmusic:first").outerHTML($(val).outerHTML());
                    }
                });
            }
            var video = $(node).find("iframe.video_iframe");
            // 秒刷视频
            $.each(video, function (key, val) {
                if ($(_this).find("[onmouseup='crsp(this,event)']").length > 0) {
                    $(_this).find("[onmouseup='crsp(this,event)']:first").outerHTML($(val).outerHTML());
                }
            });
            // 秒刷图片
            if (node.localName == "img") {
                if (imgIndex >= imgLength) {
                    // _this.find("img.brushimg:last").after($(node).outerHTML());
                    _this.find("img.brushimg:last").parent().append($(node).outerHTML());
                } else {
                    var imgsrc = node.currentSrc ? node.currentSrc : $(node).find("img").attr("src");
                    _this.find("img.brushimg").eq(imgIndex).attr("src", imgsrc);
                    isHasImg = 1;
                    imgIndex++;
                }
            } else if ($(node).find("img").length > 0) {
                $.each($(node).find("img"), function (k, item) {
                    if (imgIndex >= imgLength) {
                        // _this.find("img.brushimg:last").after($(node).outerHTML());
                        _this.find("img.brushimg:last").parent().append($(item).outerHTML());
                    } else {
                        var imgsrc = item.currentSrc ? item.currentSrc : $(item).find("img").attr("src");
                        _this.find("img.brushimg").eq(imgIndex).attr("src", imgsrc);
                        isHasImg = 1;
                        imgIndex++;
                    }
                })
                //秒刷文字
                if (node.localName != "br" && trim(node.textContent) != "" && !/^\u200B$/ig.test(node.textContent)) {
                    if (startIndex >= textLength) {
                        var beforeStyle = _this.find(".xmybrush:last").attr("style");
                        _this.find(".xmybrush:last").after('<p class="xmybrush" style="' + beforeStyle + '">' + node.textContent + '</p>');
                    } else {
                        _this.find(".xmybrush").eq(startIndex).html(node.textContent);
                    }
                    startIndex++;
                }
            } else {
                //秒刷文字
                if (node.localName != "br" && trim(node.textContent) != "" && !/^\u200B$/ig.test(node.textContent)) {
                    if (startIndex >= textLength) {
                        var beforeStyle = _this.find(".xmybrush:last").attr("style");
                        _this.find(".xmybrush:last").after('<p class="xmybrush" style="' + beforeStyle + '">' + node.textContent + '</p>');
                    } else {
                        _this.find(".xmybrush").eq(startIndex).html(node.textContent);
                    }
                    startIndex++;
                }
            }
        });

        var html = _this.outerHTML();
        // DIY 样式插入特殊处理
        if (type === 2) {
            html = "<section class='xmyeditor'>" + html + "</section>";
        }
        ue.execCommand('inserthtml', html);
        // 秒刷后空行问题
        //统计素材秒刷次数
        var data_id = $(_this).attr("data-id");
        if (data_id && data_id !== null && data_id !== undefined) {
            $.post("/home/Styles/countBrush", {"data_id": data_id}, function (con) {
            }, "json");
        }
    }
    
function isRepeat(arr) {
    var hash = {};
    for (var i in arr) {
        if (hash[arr[i]])
            return true;
        hash[arr[i]] = true;
    }
    return false;
}

loginGetCoin();
/**
 * 检测用户处于登录状态赠送蚁币功能
 */
function loginGetCoin() {
    var user=getUser();
    if(!user){
        return;
    }
    var myDate=new Date();
    var month=myDate.getMonth()+1;
    var day=myDate.getDate();
    var browser_name = get_browser();
    if(month<10){
        month="0"+month;
    }
    if(day<10){
        day="0"+day;
    }
    var loginGetCoinTime = localStorage.getItem('loginGetCoinTime');
    var now_time=myDate.getFullYear()+'_'+month+'_'+day;
    var type=2;
    if(loginGetCoinTime==undefined || !loginGetCoinTime){
        type=1;
    }
    if(loginGetCoinTime != now_time || loginGetCoinTime == undefined || !loginGetCoinTime){
        $.ajax({
            url:'/home/index/loginTask',
            type:'GET',
            data:{type:type,browser_name:browser_name},
            success:function(msg) {
                if(msg.code==200){
                    localStorage.setItem('loginGetCoinTime',msg.time);
                }else{
                    if(type==1){
                        localStorage.setItem('loginGetCoinTime',msg.time);
                    }
                }
            }
        })
    }
}
