function colorRender(options){
    this.options = options;
    this.options.Cl_group_layer = null;
    this.options.color = this.options.color.toLowerCase();
    this.init();
    // 渐变背景色默认展示
    this.options.is_gradient = (typeof this.options.is_gradient == 'undefined') ? true : this.options.is_gradient;
    this.options.is_recover = (typeof this.options.is_recover == 'undefined') ? false : this.options.is_recover;
}
colorRender.prototype = {
    init: function () {
        var $this = this;
        $(function(){
            $this.getStateColor(1);
            $this.showPalette();
            $this.getHistoryColor();
            $this.getColorGroup();
            $this.getColorPlan();
            // 点击事件渲染
            $this.bindEvent();

            // 选中颜色初始渲染
            $('.CL-e>span').attr('data-type', 1);
            $('.CL-e>div>p>span').text('系统色');
            $('.CL-i').hide();
            $('.CL-group').hide();
            // 默认色渲染
            $('.CL-g .p2 input').val($this.options.color);
            $('.CL-g .p1').css('background-color', $this.options.color);
            // 如果是rgba
            var color_arr = $this.options.color.split(',');
            if (color_arr.length == 4){
                $('.CL-h .p3').css({ 'left': parseInt(parseFloat(color_arr.pop()) * 174) + 'px'});
            }
            // 是否可以操作
            if (!$this.options.isoption){
                $('.CL-e div li[data-type="group-manage"]').hide();
                $('.CL-c div li[data-type="2"]').hide();
                $('.CL-i').hide();
            }else{
                $('.CL-e div li[data-type="group-manage"]').show();
                $('.CL-c div li[data-type="2"]').show();
            }
            // 是否隐藏渐变背景
            if (!$this.options.is_gradient){
                $('.CL-e .sp2').hide();
            }else{
                $('.CL-e .sp2').show();
            }
            // 上次是否选择分组
            if ($('.CL-e>div').attr('data-type') != '' && typeof $('.CL-e>div').attr('data-type') != 'undefined'){
                $('.CL-e div ul li[data-id="' + $('.CL-e>div').attr('data-group_id')+'"]').click();
            }else{
                $('.CL-f').show();
            }
            $('.CL-g').show().next().show();
            $('.CL-color').hide();
        })
    },
    getStateColor:function(page){
        var $this = this,
        // 页面初始化渲染颜色组件系统色库
        result = this.options.state_color,
        str = '',
        sum = result.system_color.length,
        limit = 44,
        last_page = Math.ceil((sum / limit)),
        str = '';
        // 如果是获取的最后一页颜色
        if (page == last_page) {
            for (var i = sum - limit; i < sum; i++) {
                str += '<p style="background-color:' + result.system_color[i] + ';" data-color="' + result.system_color[i] + '" class="ps p1"></p>'
            }
            str += '<p class="p2" data-color="" data-page="1"><i class="fa fa-refresh"></i></p>';
        } else {
            for (var i = (page - 1) * limit; i < page * limit; i++) {
                str += '<p style="background-color:' + result.system_color[i] + ';" data-color="' + result.system_color[i] + '" class="ps p1"></p>'
            }
            str += '<p class="p2" data-color="" data-page="' + (page + 1) + '"><i class="fa fa-refresh"></i></p>';
        }
        $('.CL-f').html(str).show();
        $('.CL-group').hide();
        // 渲染颜色组件取色器
        $('.CL-color').ColorPicker({
            flat: true,
            onChange: function (hsb, hex, rgb) {
                $('.CL-g .p2 input').val('#' + hex);
                $('.CL-g .p1').css({ 'background-color': '#' + hex });
                // 设置透密度为100%
                $('.CL-h .p3').css({ 'left': '174px' });
            }
        });

        // 透明度更改
        $(".CL-h .p3").css({ 'left': '174px' }).Tdrag({
            scope: ".CL-h",
            axis: "x",
            cbMove: function () {
                var value = (parseInt($(".CL-h .p3").css('left')) / 174).toFixed(2);
                var color = get_colorrgb($('.CL-g .p2 input').val()).toLowerCase().split(',').map(function (item, index) {
                    return item.replace(')', '').replace('rgba(', '').replace('rgb(', '');
                });
                value = value.split('').map(function (item, index){
                    return (item == '0' && index == 3 ) ? item.replace('0', '') : item
                }).join('');
                
                if (value == '1.0' || value == '0.0'){
                    value = value.replace('.0','')
                }
                (color.length == 4) ? color.pop() : true;
                var new_color = '';
                if (value != '1'){
                    new_color = 'rgba(' + color.join(',') + ',' + value + ')'
                }else{
                    new_color = 'rgb(' + color.join(',')+')'
                }
                $('.CL-g .p2 input').val(new_color);
                $('.CL-g .p1').css({ 'background-color': new_color });
                // 返回颜色值
                $this.options.onChange(new_color);
            }
        });
    },
    showPalette:function(){
        // 获取需要展示调色板的位置
        var $this = this,
        renderDemo = $($this.options.container);
        $('.CL-body').show().css({
            top: $this.options.top+'px',
            left: $this.options.left+'px'
        });
        $('.L2-coll-bg').show()
    },
    getHistoryColor:function(){
        var $this = this;
        var history_color = localStorage.getItem('history_color');
        var str = '<p class="p0 ps"><img src="/common/images/zz9.png" alt=""></p>';
        var edit_str = '';

        if (history_color == null) {
            for (var i = 0; i < 17; i++) {
                str += '';
                edit_str += '';
            }
        }else{
            history_color = $.parseJSON(history_color);
            var gradient_numb = 0;
            for (var i = 0; i < 17; i++) {
                if (i < history_color.length) {
                    var color = history_color[i].split('-');
                    if (color.length == 2) {
                        if (!$this.options.is_gradient){
                            gradient_numb += 1;
                        }else{
                            var color1 = color[0];
                            var color2 = color[1];
                            str += '<p style="background-image: linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image: -webkit-linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image:-moz-linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image:-o-linear-gradient((to right bottom,' + color1 + ',' + color2 + ');" data-color="' + history_color[i] + '" class="ps p1 grad-color"></p>';
                        }
                    } else {
                        str += '<p data-color="' + history_color[i] + '" class="ps" style="background-color: ' + history_color[i] + ';"></p>';
                        edit_str += '<p data-color="' + history_color[i] + '" class="ps edui-default" style="background-color:  ' + history_color[i] + ';"></p>'
                    }
                }
            }
        }
        $('.CL-b').html(str);
        // 渲染编辑器顶部颜色工具条
        if ($('.editor-b p').length != 0){
            $.each($('.editor-b'),function(index,item){
                $(item).find('p').eq(0).siblings().remove();
                $(item).find('p').eq(0).after(edit_str);
            });
        }
    },
    getColorGroup:function(group_id){
        // 渲染调色板颜色分组
        index_ajax({}, api_domain + '/editorapi/Palette/group', 'POST', false, function (result) {
            result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
            color_group = result;
            if (result.code == 0) {
                var str = '';
                var str1 = '';
                var click_data = null;
                $('.CL-e div li[data-type="group"]').remove();
                if ($('.editor-e').length != 0){
                    click_data = $('.editor-e').attr('data-bs');
                    $('.editor-e div li[data-type="group"]').remove();
                }else{
                    click_data = '';
                }
                $.each(result.data, function (index, item) {
                    if (item.status == 1) {
                        str += '<li data-id="' + item.id + '" data-type="group" data-color="' + item.colors + '">' + item.name + '</li>'
                        str1 += '<li  data-id="' + item.id + '" onclick=\'' + click_data + '._onChangeGroup(this);\' data-type="group" data-color="' + item.colors + '" class="edui-default">' + item.name + '</li>'
                    }
                });
                $('.CL-e div li[data-type="group-manage"]').before(str);
                $('.editor-e div li[data-type="editor-basis"]').after(str1);
                // 渲染颜色展示区域颜色
                if (group_id != '') {
                    $('.CL-e div ul').find('li[data-id="' + group_id + '"]').click();
                }
            } else {
                layer.msg(result.msg, { time: 1500 });
            }
        });
    },
    setHistoryColor: function (color, type){
        var $this = this;
        color = color.toLowerCase();
        // type == 2 是渐变色处理方法
        // 将颜色使用记录存储在本地
        var history_color = localStorage.getItem('history_color');
        if (history_color == null) {
            history_color = [];
        } else {
            history_color = $.parseJSON(history_color);
        }
        if (type == 1) {
            // 更改底部透明度滑动条
            color_arr = color.split(',');
            if (color_arr.length == 4) {
                $('.CL-h .p3').css({ 'left': parseInt(parseFloat(color_arr[3]) * 174) + 'px' });
                color = color_arr.join(',');
            }else{
                if ($('.CL-h .p3').css('left') != '174px') {
                    var last_color = $('.CL-g .p2 input').val().split(',')
                    var opacity = last_color[last_color.length - 1].replace('\)', '');
                    var new_color = get_colorrgb(color).split(',');
                    var new_last_color = new_color[new_color.length - 1].replace('\)', '');
                    new_color.pop();
                    new_color.push(new_last_color);
                    new_color.push(opacity + ')');
                    var first_val = new_color.shift().replace('RGB', 'rgba');
                    new_color.unshift(first_val);
                    color = new_color.join(',');
                }
            }
            $('.CL-g .p2 input').val(color);
            $('.CL-g .p1').css({ 'background-color': color });
        } else {
          /*   $('.CL-g .p2 input').val(color);
            $('.CL-g .p1').css({ 'background-color': color }); */
        }

        var flag = true;
        // 插件是否有重复颜色
        $.each(history_color,function(index,item){
            if (item == color) {
                history_color.splice(index,1);
                history_color.unshift(color);
                flag = !flag;
            }
        });
        // 如果没有重复的颜色。插入到顶部
        if (flag){
            history_color.unshift(color);
        }
        if (history_color.length == 18 && flag) {
            history_color.pop();
            history_color.unshift(color);
        }
        localStorage.setItem('history_color', JSON.stringify(history_color));

        // 返回颜色值
        $this.options.onChange(color);
        
        // 更新渲染历史记录颜色
        $this.getHistoryColor();
    },
    getColorPlan:function(){
        var $this = this;
        var result = $this.options.color_plan
        if (result == null){
            // layer.msg('获取配色方案出错，请稍后重试',{time:1500});
            return false;
        }
        // 渲染配色方案
        if (result.code == 0) {
            var str = '', str1 = '';
            if(result.data == ''){
                // 当无数据时隐藏配色方案部分
                $('.CL-c').hide().next().hide();
            }else{
                $.each(result.data, function (index, item) {
                    user_colors = item.user_colors.replace(']', '').replace('[', '').replace(/\"/g, '');
                    str += '<li data-type="1" data-id="' + item.id + '" data-color="' + user_colors + '">' + item.name + '</li>';
                    if (index == 0) {
                        // 默认展示第一个配色方案
                        $('.CL-c p span').text(item.name).attr('data-color', user_colors);
                        var str_p = '', first_plan = user_colors.split(',');
                        for (var i = 0; i < 18; i++) {
                            if (i < first_plan.length) {
                                str_p += '<p class="ps" style="background-color:' + first_plan[i] + ';" data-color="' + first_plan[i] + '"></p>'
                            }
                        }
                        $('.CL-d').html(str_p);
                    }
                });
                if (!$this.options.isoption) {
                    str1 = '';
                } else {
                    str1 = '<li data-type="2">更多配色</li>';
                }
                $('.CL-c div ul').html(str + str1)
            }
            
        } else {
            layer.msg(result.msg, { time: 1500 });
        }
    },
    ColorGroup:function(){
        var $this = this;
        if (getUser().group_id <= 1) {
            layer.msg('此功能仅限会员可以使用', { time: 1500 })
            return false
        }
        layer.open({
            type: 1,
            title: ['颜色分组管理', 'font-size:14px;text-align:center;color:#666'],
            skin: 'layer-Cl-group',
            move: false,
            shade: [0.6, '#000000'],
            closeBtn: 2,
            area: ['560px', '161px'],
            btn: false,
            content: $('.Cl-group-mage').html(),
            success: function (layero, index) {
                Cl_group_layer = $this.options.Cl_group_layer = index;
                // 渲染分组数据
                var choose_numb = 0;
                index_ajax({}, api_domain + '/editorapi/Palette/group', 'POST', true, function (result) {
                    result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                    if (result.code == 0) {
                        var str = '';
                        $.each(result.data, function (indexs, item) {
                            if (item.status == 1) {
                                str += '<li class="Cl-group-li active" data-groupId="' + item.id + '" data-oldIndex="' + indexs + '">';
                                choose_numb += 1;
                            } else {
                                str += '<li class="Cl-group-li" data-groupId="' + item.id + '" data-oldIndex="' + indexs + '">';
                            }
                            str += 
                                '<p class="p1">' + item.name.slice(0, 6) + '</p>' +
                                '<p class="p2" style = "display:none;"><input type="text" onblur="this.value=this.value.slice(0,6)"></p>' +
                                '<span class="del"><i class="fa fa-minus-circle"></i></span>' +
                                '</li>';
                        });
                        $('.Cl-group-add').before(str);
                        // 更改弹窗高度 位置
                        GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer);
                        // 已选中分组数量
                        $('.Cl-group-foot .p1 span').text(choose_numb);
                    } else {
                        layer.msg(result.msg, { time: 1500 });
                    }
                });
                // 可拖动渲染
                var group_sort = new Sortable($('#Cl-group-drag')[0], {
                    animation: 150,
                    handle: ".Cl-group-li",
                    filter: '.Cl-group-li>.p2',
                    preventOnFilter: false,
                    onEnd: function (evt) {
                        //拖拽完毕之后发生该事件
                        var flag = dragRemove(evt, '.layer-Cl-group');
                        var group_id = $(evt.item).attr('data-groupid');
                        // 如果拖拽节点确定删除了
                        if (flag) {
                            $(evt.item).remove();
                            GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer)
                            if (!$(evt.item).hasClass('Cl-group-new') ){
                                // 请求删除分组接口
                                index_ajax({ group_id: group_id }, api_domain + '/editorapi/Palette/deleteGroup', 'post', true, function (result) {
                                    result = (typeof result == 'string') ? $.parseJSON(result) : result;
                                    if (result.code == 0) {
                                        $(evt.item).remove();
                                        GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer)
                                    } else {
                                        layer.msg(result.msg, { time: 1500 });
                                    }
                                });
                            }else{
                                $('.Cl-group-add').attr('data-isok', 'true');
                            }
                        }
                        // 做标记，看分组是否移动
                        $(evt.item).attr('data_newIndex', evt.newIndex).addClass('Cl-group-move');
                    }
                });
            }
        });
    },
    bindEvent:function(){
        var $this = this;
        Cl_group_layer = $this.options.Cl_group_layer;
        // 系统色换一批事件
        $('.CL-f').off('click','.p2').on('click', '.p2', function () {
            var page = parseInt($(this).attr('data-page'));
            $this.getStateColor(page);
        });

        // 点击更多时展示取色器
        $('.CL-e .sp1').unbind().click(function () {
            var type = $(this).attr('data-type');
            if (type == '1') {
                $('.CL-color').show().prev().hide();
                $(this).attr('data-type', 2);
            } else {
                $('.CL-color').hide().prev().show();
                $(this).attr('data-type', 1);
            }
            $('.CL-g').show().next().show();
            $('.CL-e .sp2').attr('data-type', 1)
            // 隐藏底部导入导出按钮
            $('.CL-i').hide();
        });


        // 点击颜色方案 方案名渲染对应颜色
        $('.CL-c div ul').off('click','li').on('click', 'li', function () {
            var $this = $(this);
            var type = $this.attr('data-type');
            if (type == 1) {
                var color_plan = $this.attr('data-color').split(',');
                var str_p = '';
                for (var i = 0; i < 18; i++) {
                    if (i < color_plan.length) {
                        str_p += '<p class="ps" style="background-color:' + color_plan[i] + ';" data-color="' + color_plan[i] + '"></p>'
                    }
                }
                $('.CL-d').html(str_p);
                $('.CL-c p span').html($this.text());
                $('.CL-c div ul').hide();
            } else {
                window.open('/colors.html');
            }
        });

        // 输入移入时展示配色方案类表
        $('.CL-c div').mouseover(function () {
            $('.CL-c div ul').show();
        })
        $('.CL-c div').mouseout(function () {
            $('.CL-c div ul').hide();
        })


        // 分组颜色鼠标移入移出
        $('.CL-e div').mouseover(function () {
            $('.CL-e div ul').show();
        })
        $('.CL-e div').mouseout(function () {
            $('.CL-e div ul').hide();
        })
        // 选择系统颜色、基础颜色、颜色分组
        $('.CL-e div').off('click','ul li').on('click', 'ul li', function () {
            var that = $(this),
                str = '',
                type = that.attr('data-type');
            // 颜色分组容器可拖动暂时移出
            $('.CL-group').remove();
            $('.CL-g .p3').text('加入');
            // 隐藏导入导出按钮
            $('.CL-i').hide();

            // 默认色渲染
            $('.CL-g .p2 input').val($this.options.color);
            $('.CL-g .p1').css('background-color', $this.options.color);
            $('.CL-h .p3').css('left','174px');
            // 如果是系统色
            if (type == 'state') {
                $this.getStateColor(1);
                $('.CL-g .p3').text('使用');
            }
            // 如果是基础色
            var COLORS = $this.options.bass_color;
            if (type == 'basis') {
                $.each(COLORS, function (index, item) {
                    str += '<p style="background-color:#' + item + ';" data-color="#' + item + '" class="ps"></p>';
                });
                $('.CL-f').html(str).show();
                $('.CL-g .p3').text('使用');
            }

            // 如果是分组数据类型
            if (type == 'group') {
                var group_color = that.attr('data-color').split(';'),
                    length = group_color.length,
                    group_id = that.attr('data-id');
                for (var i = 0; i < 45; i++) {
                    if (i < length && group_color[i] != '') {
                        str += '<p style="background-color:' + group_color[i] + ';" data-color="' + group_color[i] + '" class="ps"></p>';
                    } else {
                        str += '<p data-color="" class="p-null"></p>'
                    }
                }
                
                // 存储当前分类内容
                $('.CL-e>div').attr('data-type', 'group').attr('data-group_id', group_id);
                // 是否可以操作
                if (!$this.options.isoption) {
                    $('.CL-i').hide();
                    $('.CL-f').html(str).attr('data-groupid', group_id).show();
                    $('.CL-group').hide();
                } else {
                    $('.CL-i').show();
                    $('.CL-f').attr('data-groupid', group_id).hide().after('<div class="CL-group">'+str+'</div>');
                    // 分组颜色拖拽删除
                    group_color_sorttable = new Sortable($('.CL-group')[0], {
                        animation: 150,
                        handle: ".CL-group>p.ps",
                        filter:'.CL-group>p.p-null',
                        preventOnFilter: false,
                        onEnd: function(evt){ 
                            parent_left = parseFloat($(evt.item).parent().offset().left),
                            parent_top = parseFloat($(evt.item).parent().offset().top),
                            parent_height = parseFloat($(evt.item).parent().css('height')),
                            parent_width = parseFloat($(evt.item).parent().css('width')),
                            click_left = evt.originalEvent.clientX,
                            click_top = evt.originalEvent.clientY,
                            click_width = parseFloat($(evt.item).css('width')),
                            click_height = parseFloat($(evt.item).css('height'));
                            if ((parent_left - click_left) >= click_width ||
                                click_left >= (parent_left + parent_width) ||
                                parent_top - click_top >= click_height ||
                                click_top >= (parent_top + parent_height + click_height)
                            ) {
                                var group_id = $('.CL-f').attr('data-groupid');
                                var color = $(evt.item).attr('data-color');
                                index_ajax({ group_id: group_id, color: color }, api_domain + '/editorapi/Palette/deleteColor', 'POST', true, function (result) {
                                    result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                                    if (result.code == 0) {
                                        $(evt.item).remove();
                                        layer.msg('已删除选中颜色',{time:1500});
                                    } else {
                                        layer.msg(result.msg, { time: 1500 });
                                    }
                                });
                            }
                        }
                    });
                }
            }else{
                $('.CL-e>div').attr('data-type', '');
                $('.CL-f').attr('data-groupid', '');
            }

            // 如果是分组管理
            if (type == 'group-manage') {
               $this.ColorGroup();
            }

            $('.CL-e p span').text(that.text());
            //如果当前显示的是颜色插件，则隐藏颜色插件
            if ($('.CL-e .sp1').attr('data-type') == '2') {
                $('.CL-e .sp1').click();
            }
            // 如果当前显示的是渐变色
            $('.CL-e .sp2').attr('data-type', 1);
            $('.CL-g').show().next().show();
            $('.CL-e div ul').hide();
            
        });

        // 点击渐变色渲染渐变色容器
        $('.CL-e .sp2').unbind().click(function () {
            var type = $(this).attr('data-type');
            var gradient_color = $this.options.gradient_color;
            var str = '';
            $.each(gradient_color, function (index, item) {
                var color1 = item.split('-')[0];
                var color2 = item.split('-')[1];
                str += '<p style="background-image: linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image: -webkit-linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image:-moz-linear-gradient(to right bottom,' + color1 + ',' + color2 + ');background-image:-o-linear-gradient((to right bottom,' + color1 + ',' + color2 + ');" data-color="' + item + '" class="ps p1 grad-color"></p>';
            });
            $('.CL-f').html(str).show();
            $('.CL-group').hide();
            // 选择渐变色的时候隐藏 颜色输入框和透明度
            if (type == '1') {
                $(this).attr('data-type', 2);
            }
            $('.CL-g').hide().next().hide().next().hide();
            //颜色选择器是否展示
            if ($('.CL-e .sp1').attr('data-type') == 2) {
                $('.CL-color').hide().prev().show();
                $('.CL-e .sp1').attr('data-type', 1)
            }
            // 隐藏底部导入导出按钮
        });

        // 使用系统色，基础颜色，分组内部颜色
        $('.CL-f').off('click','.ps').on('click', '.ps', function () {
            $('.CL-checked-color').remove();
            $(this).html('<i class="fa fa-check CL-checked-color" aria-hidden="true"></i>');
            // 如果是渐变颜色
            if ($('.CL-e .sp2').attr('data-type') == '2') {
                var color = $(this).attr('data-color');
                $this.setHistoryColor(color, 2);
                return false;
            }
            var color = $(this).attr('data-color');
            if (color.split(',').length == 4 && color.split(',').pop().replace(')','') == '1.00'){
                color = get_color16(color);
                // 默认色渲染
                $('.CL-g .p2 input').val(color);
                $('.CL-g .p1').css('background-color', color);
                $('.CL-h .p3').css('left','174px');
            }
            $this.setHistoryColor(color, 1);
            // 返回设置的颜色值
        });

        // 颜色底部组件添加颜色事件
        $('.CL-g .p3').unbind().click(function () {
            var color_input = $('.CL-g .p2 input')
            var color_value = color_input.val().replace(/\ +/g, "");
            if (color_value.length == 3 || color_value.length == 6){
                color_value = '#' + color_value;
            }
            var color_reg = /^#[0-9a-fA-F]{6}$|^#[0-9a-fA-F]{3}$|^[rR][gG][Bb]\(\d{0,3},\s?\d{0,3},\s?\d{0,3}\)$|^[rR][gG][Bb][Aa]?[\(]([\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?),){2}[\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?),?[\s]*(0\.\d{1,}|1\.\d{1,}|1|0)?[\)]{1}$/ig
            if (!color_reg.test(color_value)) {
                layer.msg('颜色设置参数格式错误', { time: 1500});
                color_input.focus();
                return false;
            }

            // 如果当前选中的是分组，添加该选中颜色到该分组中
            var data_demo = $('.CL-e>div');
            if (data_demo.attr('data-type') != '' && typeof data_demo.attr('data-type') != 'undefined' ){
                var group_id = data_demo.attr('data-group_id');
                console.log($('.CL-f>.ps').length);
                if ($('.CL-f>.ps').length >= 45){
                    layer.msg('分组颜色导入已达最大数量',{time:1500});
                    return false;
                }
                // 处理rgba 透明度为1的
                if (color_value.split(',').length == 4 && color_value.split(',').pop().replace(')', '') == '1.00') {
                    color_value = get_color16(color_value);
                }

                var used_color = $('.CL-e div li[data-id="' + group_id+'"]').attr('data-color').split(';');
                var flag = true;
                $.each(used_color,function(index,item){
                    if (item == color_value){
                        layer.msg('请勿重复添加颜色',{time:1500});
                        flag = false;
                        return  false;
                    }
                })

                if(flag){
                    index_ajax({ group_id: group_id, color: color_value }, api_domain + '/editorapi/Palette/importColor', 'POST', true, function (result) {
                        result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                        if (result.code == 0) {
                            layer.msg('颜色已加入该分组中', { time: 1500 });
                            // 渲染分组颜色数据
                            $this.getColorGroup(group_id);
                            // 展示系统色
                        } else {
                            layer.msg(result.msg, { time: 1500 });
                        }
                    });
                }
            }else{
                $this.setHistoryColor(color_value, 1);
            }
        });


        
        // 使用配色方案中的颜色
        $('.CL-d').off('click','.ps').on('click', '.ps', function () {
            var color = $(this).attr('data-color');
            $this.setHistoryColor(color, 1);
            $('.CL-checked-color').remove();
            $(this).html('<i class="fa fa-check CL-checked-color" aria-hidden="true"></i>');
        });

        // 使用历史记录中的颜色
        $('.CL-b').off('click','.ps').on('click', '.ps', function () {
            color = $(this).attr('data-color');
            if($(this).hasClass('p0')){
                $this.options.onChange('');
                if ( $this.options.is_recover ){
                    $this.options.onEditChange($this.options.color);
                }
                // 恢复默认颜色
                $('.CL-g .p2 input').val($this.options.color);
                $('.CL-g .p1').css('background-color',$this.options.color);
                $('.CL-h .p3').css('left','174px');
            }else{
                var color = $(this).attr('data-color').split('-');
                if (color.length == 2) {
                    // 返回设置的颜色值
                    $this.options.onChange(color[0] + '-' + color[1]);
                    // 恢复默认颜色
                    $('.CL-g .p2 input').val($this.options.color);
                    $('.CL-g .p1').css('background-color', $this.options.color);
                    $('.CL-h .p3').css('left', '174px');
                    // $this.setHistoryColor(color.join('-'), 2);
                } else {
                    // 返回设置的颜色值
                    $this.options.onChange(color[0]);
                    var color_16_tag = /^#[0-9a-fA-F]{6}$|^#[0-9a-fA-F]{3}$/;
                    // 如果是rgba格式的
                    if (!color_16_tag.test(color[0])){
                        var opacity =  color[0].split(',').pop().replace('\)','');
                        $('.CL-g .p2 input').val(color[0]);
                        $('.CL-g .p1').css('background-color', color[0]);
                        $('.CL-h .p3').css('left', parseInt(opacity*174)+'px');
                    }else{
                        $('.CL-g .p2 input').val(color[0]);
                        $('.CL-g .p1').css('background-color', color[0]);
                        $('.CL-h .p3').css('left', '174px');
                    }
                    // $this.setHistoryColor(color[0], 1);
                }
            }
            // 颜色选中效果
            $('.CL-checked-color').remove();
            if (!$(this).hasClass('p0')){
                $(this).html('<i class="fa fa-check CL-checked-color" aria-hidden="true"></i>')
            }
        });



        // 点击导出颜色按钮
        $('.CL-i p.p1').unbind().click(function () {
            var group_id = $('.CL-f').attr('data-groupid');
            var downcolor_form = document.downloadColor;
            if ($('.CL-f .ps').length == 0 ){
                layer.msg('当前可导出颜色为空',{time:1500});
                return false;
            }
            downcolor_form.action = api_domain + '/editorapi/Palette/exportColor';
            downcolor_form.group_id.value = group_id;
            downcolor_form.submit();
        });

        // 点击导入颜色展示导入颜色弹窗
        $('.CL-i .p2').unbind().click(function () {
            layer.open({
                type: 1,
                title: ['导入颜色', 'font-size:15px;text-align:center;color:#666;padding:0;letter-spacing:1px;'],
                area: ['640px', '320px'],
                skin: 'Cl-import-layer',
                closeBtn: 2,
                move: false,
                shade: 0.6,
                btn: ['取消', '确定'],
                content: $('.Cl-import').html(),
                success: function (layero, index) {
                    var group_select = $('.Cl-import-group');
                    var select_id = $('.CL-f').attr('data-groupid');
                    index_ajax({}, api_domain + '/editorapi/Palette/group', 'POST', true, function (result) {
                        result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                        if (result.code == 0) {
                            var str = '';
                            $.each(result.data, function (index, item) {
                                if (item.status == 1) {
                                    if (item.id == select_id) {
                                        str += '<option data-id="' + item.id + '" data-type="group" data-color="' + item.colors + '" selected>' + item.name + '</option>'
                                    } else {
                                        str += '<option data-id="' + item.id + '" data-type="group" data-color="' + item.colors + '">' + item.name + '</option>'
                                    }
                                }
                            });
                            group_select.html(str);

                            $this.options.form.render('select');
                            var old_color = $('.Cl-import-group option:selected').attr('data-color').split(';');
                            $('.Cl-group-numb span').text(45 - old_color.length);
                        } else {
                            layer.msg(result.msg, { time: 1500 });
                        }
                    });
                },
                btn2: function (index, layero) {
                    // 分组名称
                    var group_id = $('.Cl-import-group option:selected').attr('data-id'),
                        // 需要添加的颜色值
                        color_value = $('.Cl-import-color').val().replace(/\ +/g, "").split(';'),
                        flag = true,
                        last_length = parseInt($('.Cl-group-numb span').text());

                    if (color_value == '') {
                        layer.msg('导入的颜色代码不可为空', { time: 1500 });
                        return false;
                    }

                    if (color_value.length > last_length) {
                        layer.msg('一个分组中最多添加45个颜色', { time: 1500 });
                        return false;
                    }
                    $.each(color_value, function (index, item) {
                        var color_reg = /^#[0-9a-fA-F]{6}$|^#[0-9a-fA-F]{3}$|^[rR][gG][Bb]\(\d{0,3},\s?\d{0,3},\s?\d{0,3}\)$|^[rR][gG][Bb][Aa]?[\(]([\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?),){2}[\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?),?[\s]*(0\.\d{1,}|1\.\d{1,}|1|0)?[\)]{1}$/ig
                        if (!color_reg.test(item)) {
                            layer.msg('颜色值含有错误格式', { time: 1500 });
                            flag = false;
                            return false;
                        }
                    });

                    // 如果没有报错信息
                    if (flag) {
                        index_ajax({ group_id: group_id, color: color_value.join(';') }, api_domain + '/editorapi/Palette/importColor', 'POST', true, function (result) {
                            result = (typeof (result) == 'string') ? $.parseJSON(result) : result;
                            if (result.code == 0) {
                                layer.msg('已导入分组颜色', { time: 1500 });
                                // 渲染分组颜色数据
                                $this.getColorGroup(group_id);
                            } else {
                                layer.msg(result.msg, { time: 1500 });
                            }
                        });
                    } else {
                        return false;
                    }
                }
            });
        });

        // 监控导入颜色中分组更改该分组下的剩余数量
        $this.options.form.on('select(Cl-import-group)', function (data) {
            var old_color = $('.Cl-import-group option:selected').attr('data-color').split(';');
            $('.Cl-group-numb span').text(45 - old_color.length);
        });


        // 添加分组
        $(document).off('click','.Cl-group-add').on('click', '.Cl-group-add', function () {
            var add_index = parseInt($(this).prev().attr('data-oldindex')) + 1;
            var type = $(this).attr('data-isok');
            var this_length = $('.Cl-group-li').length;
            if (getUser().group_id == 2 && this_length > 15) {
                layer.msg('当前等级可添加数量已达上限', { time: 1500 })
                return false;
            }
            if (getUser().group_id == 3 && this_length > 40) {
                layer.msg('当前等级可添加数量已达上限', { time: 1500 })
                return false;
            }
            if (getUser().group_id == 3 && this_length > 100) {
                layer.msg('当前等级可添加数量已达上限', { time: 1500 })
                return false;
            }
            if (type == 'false') {
                layer.msg('分组名不可重复', { time: 1500 });
                return false;
            }
            var str = '<li class="Cl-group-li Cl-group-new active"  data-groupId="0" data-oldindex="' + add_index + '">' +
                '<p class="p1" style = "display:none;" ></p>' +
                '<p class="p2"><input type="text" onblur="this.value=this.value.slice(0,6)"></p>' +
                '<span class="del"><i class="fa fa-minus-circle"></i></span>' +
                '</li>';
            $(this).before(str);
            GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer)
            $('.Cl-group-new input').focus();
            // 更改弹窗左下角选中个数
            var choose_numb = $('.Cl-group-foot .p1 span');
            choose_numb.text(parseInt(choose_numb.text()) + 1);
        });

        // 删除分组
        $(document).off('click','.Cl-group-li>span').on('click', '.Cl-group-li>span', function () {
            var parent_demo = $(this).parents('li');
            var group_id = parent_demo.attr('data-groupid');
            // 请求删除分组接口
            if (!parent_demo.hasClass('Cl-group-new')) {
                index_ajax({ group_id: group_id }, api_domain + '/editorapi/Palette/deleteGroup', 'post', true, function (result) {
                    result = (typeof result == 'string') ? $.parseJSON(result) : result;
                    if (result.code == 0) {
                        parent_demo.remove();
                        // 计算分组删除后的弹窗高度
                        GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer);
                    } else {
                        layer.msg(result.msg, { time: 1500 });
                    }
                });
            } else {
                parent_demo.remove();
                $('.Cl-group-add').attr('data-isok', 'true');
                GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer);
            }
            var choose_numb = $('.Cl-group-foot .p1 span');
            choose_numb.text(parseInt(choose_numb.text()) - 1);

            
            return false;
        });

        // 当分组输入框失去焦点的时候
        $(document).off('blur','.Cl-group-li input').on('blur', '.Cl-group-li input', function () {
            var that = $(this),
                label_name = that.val().slice(0, 6),
                parent_demo = that.parent().parent(),
                group_id = parent_demo.attr('data-groupid'),
                this_state = true,
                this_index = parent_demo.index(),
                text_demo = that.parent(),
                choose_numb = $('.Cl-group-foot .p1 span');
            // 老分组修改后分组名称为空
            if (label_name == '' && !parent_demo.hasClass('Cl-group-new')) {
                layer.msg('分组名称不能为空', { time: 1500 });
                return false;
            }
            // 创建新分组，但是分组名称为空
            if (label_name == '' && parent_demo.hasClass('Cl-group-new')) {
                parent_demo.remove();
                GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer);

                choose_numb.text(parseInt(choose_numb.text()) - 1);
                return false;
            }

            // 创建新分组并设置分组名称
            if (label_name != '') {
                $.each($('.Cl-group-li .p1'), function (index, item) {
                    if (this_index != index) {
                        if ($(item).text() == label_name) {
                            this_state = false;
                            return false;
                        }
                    }
                })

                if (!this_state) {
                    layer.msg('分组名已存在', { time: 1500 });
                    text_demo.hide().prev().show().text(label_name);
                    // 做标记
                    $('.Cl-group-add').attr('data-isok', 'false');
                    return false;
                }

                if (parent_demo.hasClass('Cl-group-new')) {
                    // 如果是新添加的分组
                    index_ajax({ group_name: label_name }, api_domain + '/editorapi/Palette/addgroup', 'post', true, function (result) {
                        result = (typeof result == 'string') ? $.parseJSON(result) : result;
                        if (result.code == 0) {
                            text_demo.hide().prev().show().text(label_name).parents('.Cl-group-new').removeClass('Cl-group-new').attr('data-groupid', result.data);
                        } else {
                            parent_demo.remove();
                            choose_numb.text(parseInt(choose_numb.text()) - 1);
                            GroupMheight('#Cl-group-drag', '.layer-Cl-group', Cl_group_layer);
                            layer.msg(result.msg, { time: 1500 });
                        }
                    });
                } else {
                    // 修改分组名称
                    index_ajax({ group_id: group_id, group_name: label_name }, api_domain + '/editorapi/Palette/editGroup', 'post', true, function (result) {
                        result = (typeof result == 'string') ? $.parseJSON(result) : result;
                        if (result.code == 0) {
                            text_demo.hide().prev().show().text(label_name);
                        } else {
                            layer.msg(result.msg, { time: 1500 });
                        }
                    });
                }
                $('.Cl-group-add').attr('data-isok', 'true');
                return false;
            }

            
        });
        // 绑定修改名称enter事件
        $(document).off('keydown','.Cl-group-li input').on("keydown", '.Cl-group-li input', function (event) {
            var keyCode = event.keyCode || event.which;
            if (keyCode == "13") {
                $(this).blur();
                event.preventDefault();
            }
            
        });


        // 双击分组名称修改分组名称
        $(document).off('dblclick','.Cl-group-li>p.p1').on('dblclick', '.Cl-group-li>p.p1', function () {
            $(this).hide().next().show().find('input').val($(this).text()).focus();
            return false;
        });


        // 单击分组时选中该分组
        $(document).off('click','.Cl-group-li').on('click', '.Cl-group-li', function () {
            var that = $(this);
            var choose_demo = $('.Cl-group-foot .p1 span');
            if (that.hasClass('Cl-group-add')) {
                return false;
            }
            if (that.hasClass('active')) {
                that.removeClass('active');
                choose_demo.text(parseInt(choose_demo.text()) - 1);
            } else {
                that.addClass('active');
                choose_demo.text(parseInt(choose_demo.text()) + 1);
            }

            
            return false;
        });


        // 分组管理完成
        $(document).off('click','.Cl-group-foot>p.sure ').on('click', '.Cl-group-foot>p.sure', function () {
            var null_name = $('.Cl-group-null');
            if (null_name.length > 0) {
                layer.msg('分组名称不可为空', { time: 1500 });
                return false;
            }
            var group_ids = [],
                isMove = 0;
            var choosed_length = $('.Cl-group-li.active').length;
            if (choosed_length > 15) {
                layer.msg('最多选择15个分组', { time: 1500 });
                return false;
            }
            // 存起来name 值看是否有重名的名称
            var name_arr = [];
            $.each($('.Cl-group-li'), function (index, item) {
                if (!$(item).hasClass('Cl-group-add')) {
                    var id = $(item).attr('data-groupid'),
                        status = ($(item).hasClass('active')) ? 1 : 0,
                        name = $(item).find('.p1').text();
                    group_ids.push({ id: id, status: status });
                    name_arr.push(name);
                }
            });

            // 验证是否有重复分组名
            if (isRepeat(name_arr)) {
                layer.msg('分组名称不可重复', { time: 1500 });
                return false;
            }
            if (group_ids.length != 0){
                index_ajax({ json: JSON.stringify(group_ids) }, api_domain + '/editorapi/Palette/editGroups', 'post', true, function (result) {
                    result = (typeof result == 'string') ? $.parseJSON(result) : result;
                    if (result.code == 0) {
                        layer.msg('分组保存成功', { time: 1500 });
                        $this.getColorGroup('');
                        $('.CL-e>div>p>span').text('系统色');
                        $this.getStateColor(1);
                        layer.close(Cl_group_layer);
                    } else {
                        layer.msg(result.msg, { time: 1500 });
                    }
                });
            }else{
                $this.getColorGroup('');
                layer.close(Cl_group_layer);
            }
            

        });




    }
}




var palette = function (opts) {
    return new colorRender(opts);
};


window.palette = $.palette = palette;
