/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Element;

public class JCEMapper {
    private static final Logger LOG = LoggerFactory.getLogger(JCEMapper.class);
    private static Map<String, Algorithm> algorithmsMap = new ConcurrentHashMap<String, Algorithm>();
    private static String providerName;

    public static void register(String string, Algorithm algorithm) {
        JavaUtils.checkRegisterPermission();
        algorithmsMap.put(string, algorithm);
    }

    public static void registerDefaultAlgorithms() {
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#md5", new Algorithm("", "MD5", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmlenc#ripemd160", new Algorithm("", "RIPEMD160", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2000/09/xmldsig#sha1", new Algorithm("", "SHA-1", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#sha224", new Algorithm("", "SHA-224", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmlenc#sha256", new Algorithm("", "SHA-256", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#sha384", new Algorithm("", "SHA-384", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmlenc#sha512", new Algorithm("", "SHA-512", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#whirlpool", new Algorithm("", "WHIRLPOOL", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-224", new Algorithm("", "SHA3-224", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-256", new Algorithm("", "SHA3-256", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-384", new Algorithm("", "SHA3-384", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-512", new Algorithm("", "SHA3-512", "MessageDigest"));
        algorithmsMap.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", new Algorithm("DSA", "SHA1withDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2009/xmldsig11#dsa-sha256", new Algorithm("DSA", "SHA256withDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-md5", new Algorithm("RSA", "MD5withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", new Algorithm("RSA", "RIPEMD160withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", new Algorithm("RSA", "SHA1withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", new Algorithm("RSA", "SHA224withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", new Algorithm("RSA", "SHA256withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", new Algorithm("RSA", "SHA384withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", new Algorithm("RSA", "SHA512withRSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", new Algorithm("RSA", "SHA1withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", new Algorithm("RSA", "SHA224withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", new Algorithm("RSA", "SHA256withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", new Algorithm("RSA", "SHA384withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", new Algorithm("RSA", "SHA512withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", new Algorithm("RSA", "SHA3-224withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", new Algorithm("RSA", "SHA3-256withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", new Algorithm("RSA", "SHA3-384withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", new Algorithm("RSA", "SHA3-512withRSAandMGF1", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", new Algorithm("EC", "SHA1withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", new Algorithm("EC", "SHA224withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", new Algorithm("EC", "SHA256withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", new Algorithm("EC", "SHA384withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", new Algorithm("EC", "SHA512withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", new Algorithm("EC", "RIPEMD160withECDSA", "Signature"));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-md5", new Algorithm("", "HmacMD5", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", new Algorithm("", "HMACRIPEMD160", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", new Algorithm("", "HmacSHA1", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224", new Algorithm("", "HmacSHA224", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", new Algorithm("", "HmacSHA256", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", new Algorithm("", "HmacSHA384", "Mac", 0, 0));
        algorithmsMap.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", new Algorithm("", "HmacSHA512", "Mac", 0, 0));
    }

    public static String translateURItoJCEID(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.jceName;
        }
        return null;
    }

    public static String getAlgorithmClassFromURI(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.algorithmClass;
        }
        return null;
    }

    public static int getKeyLengthFromURI(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.keyLength;
        }
        return 0;
    }

    public static int getIVLengthFromURI(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.ivLength;
        }
        return 0;
    }

    public static String getJCEKeyAlgorithmFromURI(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.requiredKey;
        }
        return null;
    }

    public static String getJCEProviderFromURI(String string) {
        Algorithm algorithm = JCEMapper.getAlgorithm(string);
        if (algorithm != null) {
            return algorithm.jceProvider;
        }
        return null;
    }

    private static Algorithm getAlgorithm(String string) {
        LOG.debug("Request for URI {}", string);
        if (string != null) {
            return algorithmsMap.get(string);
        }
        return null;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String string) {
        JavaUtils.checkRegisterPermission();
        providerName = string;
    }

    public static class Algorithm {
        final String requiredKey;
        final String jceName;
        final String algorithmClass;
        final int keyLength;
        final int ivLength;
        final String jceProvider;

        public Algorithm(Element element) {
            this.requiredKey = element.getAttributeNS(null, "RequiredKey");
            this.jceName = element.getAttributeNS(null, "JCEName");
            this.algorithmClass = element.getAttributeNS(null, "AlgorithmClass");
            this.jceProvider = element.getAttributeNS(null, "JCEProvider");
            this.keyLength = element.hasAttribute("KeyLength") ? Integer.parseInt(element.getAttributeNS(null, "KeyLength")) : 0;
            this.ivLength = element.hasAttribute("IVLength") ? Integer.parseInt(element.getAttributeNS(null, "IVLength")) : 0;
        }

        public Algorithm(String string, String string2) {
            this(string, string2, null, 0, 0);
        }

        public Algorithm(String string, String string2, String string3) {
            this(string, string2, string3, 0, 0);
        }

        public Algorithm(String string, String string2, int n) {
            this(string, string2, null, n, 0);
        }

        public Algorithm(String string, String string2, String string3, int n, int n2) {
            this(string, string2, string3, n, n2, null);
        }

        public Algorithm(String string, String string2, String string3, int n, int n2, String string4) {
            this.requiredKey = string;
            this.jceName = string2;
            this.algorithmClass = string3;
            this.keyLength = n;
            this.ivLength = n2;
            this.jceProvider = string4;
        }
    }
}

