/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class YamlStringEscapeUtils {
    public static String escapeString(String str) {
        return YamlStringEscapeUtils.escapeJavaStyleString(str, false, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            YamlStringEscapeUtils.escapeJavaStyleString(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\ufffd') {
                out.write("\\u" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch > '\ud7ff' && ch < '\ue000') {
                out.write("\\u" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch > '~' && ch != '\u0085' && ch < '\u00a0') {
                out.write("\\u00" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + CharSequenceTranslator.hex(ch));
                            break;
                        }
                        out.write("\\u000" + CharSequenceTranslator.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block11;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block11;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block11;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block11;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static String unescapeString(String str) {
        return StringEscapeUtils.unescapeJava(str);
    }
}

