/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidNavigatorViewException;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.help.SearchView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;

public class JHelpSearchNavigator
extends JHelpNavigator {
    private MergingSearchEngine search;
    private static final boolean debug = false;

    public JHelpSearchNavigator(NavigatorView navigatorView) {
        super(navigatorView, null);
    }

    public JHelpSearchNavigator(NavigatorView navigatorView, HelpModel helpModel) {
        super(navigatorView, helpModel);
    }

    public JHelpSearchNavigator(HelpSet helpSet, String string, String string2, URL uRL) throws InvalidNavigatorViewException {
        super(new SearchView(helpSet, string, string2, JHelpSearchNavigator.createParams(uRL)));
    }

    @Override
    public String getUIClassID() {
        return "HelpSearchNavigatorUI";
    }

    public SearchEngine getSearchEngine() {
        if (this.search == null) {
            this.search = new MergingSearchEngine(this.getNavigatorView());
        }
        return this.search;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.search = new MergingSearchEngine(searchEngine);
    }

    protected String getDefaultQueryEngine() {
        return HelpUtilities.getDefaultQueryEngine();
    }

    @Override
    public boolean canMerge(NavigatorView navigatorView) {
        if (navigatorView instanceof SearchView && this.getNavigatorName().equals(navigatorView.getName())) {
            JHelpSearchNavigator.debug("canMerge: true");
            return true;
        }
        JHelpSearchNavigator.debug("canMerge: false");
        return false;
    }

    @Override
    public void merge(NavigatorView navigatorView) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.merge invoked");
        JHelpSearchNavigator.debug("  params: " + navigatorView.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.merge(navigatorView);
        JHelpSearchNavigator.debug("merge: " + navigatorView);
        this.getUI().merge(navigatorView);
    }

    @Override
    public void remove(NavigatorView navigatorView) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.remove invoked");
        JHelpSearchNavigator.debug("  params: " + navigatorView.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.remove(navigatorView);
        JHelpSearchNavigator.debug("remove: " + navigatorView);
        this.getUI().remove(navigatorView);
    }

    private static void debug(String string) {
    }
}

