/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHello;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.ServerHello;

abstract class HelloCookieManager {
    HelloCookieManager() {
    }

    abstract byte[] createCookie(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2) throws IOException;

    abstract boolean isCookieValid(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2, byte[] var3) throws IOException;

    static class Builder {
        final SecureRandom secureRandom;
        private volatile T13HelloCookieManager t13HelloCookieManager;

        Builder(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HelloCookieManager valueOf(ProtocolVersion protocolVersion) {
            if (protocolVersion.useTLS13PlusSpec()) {
                if (this.t13HelloCookieManager != null) {
                    return this.t13HelloCookieManager;
                }
                Builder builder = this;
                synchronized (builder) {
                    if (this.t13HelloCookieManager == null) {
                        this.t13HelloCookieManager = new T13HelloCookieManager(this.secureRandom);
                    }
                }
                return this.t13HelloCookieManager;
            }
            return null;
        }
    }

    private static final class T13HelloCookieManager
    extends HelloCookieManager {
        final SecureRandom secureRandom;
        private int cookieVersion;
        private final byte[] cookieSecret;
        private final byte[] legacySecret;

        T13HelloCookieManager(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            this.cookieVersion = secureRandom.nextInt();
            this.cookieSecret = new byte[64];
            this.legacySecret = new byte[64];
            secureRandom.nextBytes(this.cookieSecret);
            System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] createCookie(ServerHandshakeContext serverHandshakeContext, ClientHello.ClientHelloMessage clientHelloMessage) throws IOException {
            byte[] byArray;
            int n;
            Object object = this;
            synchronized (object) {
                n = this.cookieVersion;
                byArray = this.cookieSecret;
                if ((this.cookieVersion & 0xFFFFFF) == 0) {
                    System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
                    this.secureRandom.nextBytes(this.cookieSecret);
                }
                ++this.cookieVersion;
            }
            object = JsseJce.getMessageDigest(serverHandshakeContext.negotiatedCipherSuite.hashAlg.name);
            byte[] byArray2 = clientHelloMessage.getHeaderBytes();
            ((MessageDigest)object).update(byArray2);
            byte[] byArray3 = ((MessageDigest)object).digest(byArray);
            serverHandshakeContext.handshakeHash.update();
            byte[] byArray4 = serverHandshakeContext.handshakeHash.digest();
            byte[] byArray5 = new byte[]{(byte)(serverHandshakeContext.negotiatedCipherSuite.id >> 8 & 0xFF), (byte)(serverHandshakeContext.negotiatedCipherSuite.id & 0xFF), (byte)(n >> 24 & 0xFF)};
            byte[] byArray6 = Arrays.copyOf(byArray5, byArray5.length + byArray3.length + byArray4.length);
            System.arraycopy(byArray3, 0, byArray6, byArray5.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray6, byArray5.length + byArray3.length, byArray4.length);
            return byArray6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isCookieValid(ServerHandshakeContext serverHandshakeContext, ClientHello.ClientHelloMessage clientHelloMessage, byte[] byArray) throws IOException {
            byte[] byArray2;
            if (byArray == null || byArray.length <= 32) {
                return false;
            }
            int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            CipherSuite cipherSuite = CipherSuite.valueOf(n);
            if (cipherSuite == null || cipherSuite.hashAlg == null || cipherSuite.hashAlg.hashLength == 0) {
                return false;
            }
            int n2 = cipherSuite.hashAlg.hashLength;
            if (byArray.length != 3 + n2 * 2) {
                return false;
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray, 3, 3 + n2);
            byte[] byArray4 = Arrays.copyOfRange(byArray, 3 + n2, byArray.length);
            Object object = this;
            synchronized (object) {
                byArray2 = (byte)(this.cookieVersion >> 24 & 0xFF) == byArray[2] ? this.cookieSecret : this.legacySecret;
            }
            object = JsseJce.getMessageDigest(cipherSuite.hashAlg.name);
            byte[] byArray5 = clientHelloMessage.getHeaderBytes();
            ((MessageDigest)object).update(byArray5);
            byte[] byArray6 = ((MessageDigest)object).digest(byArray2);
            if (!Arrays.equals(byArray6, byArray3)) {
                return false;
            }
            byte[] byArray7 = ServerHello.hrrReproducer.produce(serverHandshakeContext, clientHelloMessage);
            serverHandshakeContext.handshakeHash.push(byArray7);
            byte[] byArray8 = new byte[4 + n2];
            byArray8[0] = SSLHandshake.MESSAGE_HASH.id;
            byArray8[1] = 0;
            byArray8[2] = 0;
            byArray8[3] = (byte)(n2 & 0xFF);
            System.arraycopy(byArray4, 0, byArray8, 4, n2);
            serverHandshakeContext.handshakeHash.push(byArray8);
            return true;
        }
    }
}

