/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLAlgorithmDecomposer;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.util.DisabledAlgorithmConstraints;

final class SSLAlgorithmConstraints
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.tls.disabledAlgorithms", new SSLAlgorithmDecomposer());
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms", new SSLAlgorithmDecomposer(true));
    private final AlgorithmConstraints userSpecifiedConstraints;
    private final AlgorithmConstraints peerSpecifiedConstraints;
    private final boolean enabledX509DisabledAlgConstraints;
    static final AlgorithmConstraints DEFAULT = new SSLAlgorithmConstraints(null);
    static final AlgorithmConstraints DEFAULT_SSL_ONLY = new SSLAlgorithmConstraints((SSLSocket)null, false);

    SSLAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.userSpecifiedConstraints = algorithmConstraints;
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = true;
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, boolean bl) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(sSLSocket);
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = bl;
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, boolean bl) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(sSLEngine);
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = bl;
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, String[] stringArray, boolean bl) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(sSLSocket);
        this.peerSpecifiedConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        this.enabledX509DisabledAlgConstraints = bl;
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, String[] stringArray, boolean bl) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(sSLEngine);
        this.peerSpecifiedConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        this.enabledX509DisabledAlgConstraints = bl;
    }

    private static AlgorithmConstraints getUserSpecifiedConstraints(SSLEngine sSLEngine) {
        if (sSLEngine != null) {
            HandshakeContext handshakeContext;
            if (sSLEngine instanceof SSLEngineImpl && (handshakeContext = ((SSLEngineImpl)sSLEngine).conContext.handshakeContext) != null) {
                return handshakeContext.sslConfig.userSpecifiedAlgorithmConstraints;
            }
            return sSLEngine.getSSLParameters().getAlgorithmConstraints();
        }
        return null;
    }

    private static AlgorithmConstraints getUserSpecifiedConstraints(SSLSocket sSLSocket) {
        if (sSLSocket != null) {
            HandshakeContext handshakeContext;
            if (sSLSocket instanceof SSLSocketImpl && (handshakeContext = ((SSLSocketImpl)sSLSocket).conContext.handshakeContext) != null) {
                return handshakeContext.sslConfig.userSpecifiedAlgorithmConstraints;
            }
            return sSLSocket.getSSLParameters().getAlgorithmConstraints();
        }
        return null;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerSpecifiedConstraints != null) {
            bl = this.peerSpecifiedConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.userSpecifiedConstraints != null) {
            bl = this.userSpecifiedConstraints.permits(set, string, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, Key key) {
        boolean bl = true;
        if (this.peerSpecifiedConstraints != null) {
            bl = this.peerSpecifiedConstraints.permits(set, key);
        }
        if (bl && this.userSpecifiedConstraints != null) {
            bl = this.userSpecifiedConstraints.permits(set, key);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, key);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, key);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerSpecifiedConstraints != null) {
            bl = this.peerSpecifiedConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.userSpecifiedConstraints != null) {
            bl = this.userSpecifiedConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        return bl;
    }

    private static class SupportedSignatureAlgorithmConstraints
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] stringArray) {
            this.supportedAlgorithms = stringArray != null ? (String[])stringArray.clone() : null;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int n = string.indexOf("and");
            if (n > 0) {
                string = string.substring(0, n);
            }
            for (String string2 : this.supportedAlgorithms) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(set, string, algorithmParameters);
        }
    }
}

