name = "Binoculars"

description = [[
Binoculars can now be used to reveal a portion of map, and are craftable in the Cartography tab. The default recipe is 1 Marble, 2 Cut Reeds, and 2 Nitre, and makes 2 Binoculars with each craft.

They are less effective during dusk, and can't be used during the night or in the caves, unless the user has night vision.
]]

author = "wildcheri, davicr"

version = "1.1"

api_version = 10

all_clients_require_mod = true
dst_compatible = true

server_filter_tags = { "binoculars" }

icon_atlas = "images/modicon.xml"
icon = "modicon.tex"

forumthread = ""

configuration_options = {
	{
		name = "recipe",
		label = "Crafting Recipe",
		hover = "Set the crafting recipe for Binoculars.",
		options =
		{
			{description = "Easy", data = [[return{ Ingredient("marble", 1), Ingredient("cutreeds", 1) }]], hover = "1 Marble, 1 Cut Reeds"},
			{description = "Normal", data = [[return{ Ingredient("marble", 1), Ingredient("cutreeds", 2), Ingredient("nitre", 2) }]], hover = "1 Marble, 2 Cut Reeds, 2 Nitre"},
			{description = "Hard", data = [[return{ Ingredient("marble", 1), Ingredient("cutreeds", 2), Ingredient("moonglass", 1) }]], hover = "1 Marble, 2 Cut Reeds, 1 Moon Shard"},
		},
		default = [[return{ Ingredient("marble", 1), Ingredient("cutreeds", 2), Ingredient("nitre", 2) }]],
	},
	{
		name = "num",
		label = "Number Per Craft",
		hover = "Set how many Binoculars you get with each craft.",
		options =
		{
			{description = "1", data = 1},
			{description = "2", data = 2},
			{description = "3", data = 3},
			{description = "4", data = 4},
		},
		default = 2,
	},
}