local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local loadstring = GLOBAL.loadstring

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local AllRecipes = GLOBAL.AllRecipes
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH

STRINGS.RECIPE_DESC.TRINKET_38 = "Scope the horizon."
AddRecipe("trinket_38", loadstring(GetModConfigData("recipe"))(), RECIPETABS.CARTOGRAPHY, TECH.CARTOGRAPHY_TWO, nil, nil, true, GetModConfigData("num"))

local function UsableBinoculars(inst)
	inst:AddComponent("scoper")
end

AddPrefabPostInit("trinket_38", UsableBinoculars)

AddAction("USESCOPER", "Peer", function(act)
	local player = act.target or act.doer
	local hasnightvision = player.components.playervision and player.components.playervision:HasNightVision()
	if not (hasnightvision or
	GLOBAL.TheWorld.state.isday or
	GLOBAL.TheWorld.state.isdusk or
	GLOBAL.TheWorld.state.isfullmoon) then
		player.components.talker:Say(GLOBAL.GetString(player, "DESCRIBE_TOODARK"))
		return true
	end
	local x, y, z = player.Transform:GetWorldPosition()
	local angle = -player:GetRotation()
	return act.invobject.components.scoper:Look(player, x, y, z, angle)
end)

AddComponentAction("INVENTORY", "scoper", function(inst, doer, actions, right)
	table.insert(actions, ACTIONS.USESCOPER)
end)

AddStategraphActionHandler("wilson", ActionHandler(ACTIONS.USESCOPER, "dolongaction"))
AddStategraphActionHandler("wilson_client", ActionHandler(ACTIONS.USESCOPER, "dolongaction"))

local original_cartography_action = STRINGS.UI.CRAFTING.TABACTION["CARTOGRAPHY"]
AddClassPostConstruct("widgets/recipepopup", function(inst)
    local orig = inst.Refresh
    inst.Refresh = function(popup)
        if inst.recipe and inst.recipe.tab and inst.recipe.tab.str == "CARTOGRAPHY" then
            if inst.recipe.name == "trinket_38" then
                STRINGS.UI.CRAFTING.TABACTION["CARTOGRAPHY"] = STRINGS.UI.CRAFTING.BUILD
            else
                STRINGS.UI.CRAFTING.TABACTION["CARTOGRAPHY"] = original_cartography_action
            end
        end
        orig(popup)
    end
end)