local Scoper = Class(function(self, inst)
    self.inst = inst
	self.range = 200
	self.arc = 30
end)

function Scoper:SetRange(range)
    self.range = range
end

function Scoper:SetArc(arc)
    self.arc = arc
end

function Scoper:Look(player, x, y, z, angle, range, arc)
    local range = range or self.range
    local arc = arc or self.arc
	local angle = angle - 15
	local hasnightvision = player.components.playervision and player.components.playervision:HasNightVision()
	if not TheWorld.state.isday then
		if TheWorld.state.isdusk then
			range = range * (hasnightvision and 1 or 5/6)
		else
			range = range * (hasnightvision and 2/3 or 1/3)
		end
	end
    local arclength = 0.5 * range * arc * DEGREES
    for i = 1, range, 10 do
        for j = 0, arclength, 4 do
            local a = angle + (j / (0.5 * range * DEGREES))
            local c = math.cos(a * DEGREES)
            local s = math.sin(a * DEGREES)
            local x0, z0 = x + i * c, z + i * s
            local cx, cy, cz = TheWorld.Map:GetTileCenterPoint(x0, 0, z0)
            if cx and cy and cz then
                player.player_classified.MapExplorer:RevealArea(cx, cy, cz)
            end
        end
    end
    if self.inst.components.stackable and self.inst.components.stackable:IsStack() then
        self.inst.components.stackable:Get():Remove()
    else
        self.inst:Remove()
    end
    return true
end

return Scoper