
// ********************************************************************************
// This is a part of the Pioneer Rec System Voice Card DLL.
// Copyright (C) 2005-2009 PioneerAudio CO., LTD
// All rights reserved.
//
// This source code is only used by PioneerAudio Voice Card Customer
// --------------------------------------------------------------------------------
// ȷѶƼ޹˾¼濨USBеDLLһ
// Ȩ (C) 2005-2009 ȷѶƼ޹˾
//
// ȨȷѶƼ޹˾ƷĿͻʹãֻȷѶ
//     Ƽ޹˾Ʒһʹ
// ********************************************************************************
//
// ļƣBfVoice.h
// ļţ32/32
// ļ汾5.18.2.68
// ڣ2004-05-16
// ԱPetra Yang
// ޸ڣ2009-06-18
// ޸ԱPetra Yang
// ޸ݣԶƺ
//
// ********************************************************************************


#ifndef		BF_VOICE_INCLUDE
#define		BF_VOICE_INCLUDE

#define		MAX_INDEX_BUFFER_NUM				0x0100
#define		MAX_INDEX_FILE_NUM					0x0100
#define		MAX_FILE_NAME_NUM					0x0100

#define		MAX_CARD_NUM						0x0010
#define		MAX_CHANNEL_NUM						0x0080
#define		MAX_RESOURCE_NUM					0x0040
#define		MAX_SERIAL_NUM						0x0020
#define		MAX_DTMF_NUM						0x0040
#define		MAX_CID_NUM							0x0080
#define		MAX_FSK_NUM							0x0400

#define     MAX_CONFERENCE_GROUP_NUM			0x0010
#define     MAX_CONFERENCE_RESOURCE_NUM			0x0020
#define     MAX_CONFERENCE_GROUP_RESOURCE_NUM	0x0010

// Define Error const
#define     BF_OK								0x0000
#define     BF_ERROR							0xFFFF

// Define Last Error Code
#define     BF_ERROR_GENERAL					0xFFFF
#define		BF_ERROR_NO_INITIALIZE_CARD			0xFFFE
#define		BF_ERROR_CHANNEL_NO_ERROR			0xFFFD
#define		BF_ERROR_NO_OPEN_CHANNEL			0xFFFC
#define		BF_ERROR_OPEN_FILE					0xFFFB
#define		BF_ERROR_READ_FILE					0xFFFA
#define		BF_ERROR_WRITE_FILE					0xFFF9
#define		BF_ERROR_CHANNEL_IS_PLAYING			0xFFF8
#define		BF_ERRER_START_PLAY_VOICE			0xFFF7
#define		BF_ERROR_CHANNEL_IS_RECORDING		0xFFF6
#define		BF_ERRER_START_RECORD_VOICE			0xFFF5
#define		BF_ERROR_NO_INITIALIZE_FAX			0xFFF4
#define		BF_ERROR_NO_BIND_RESOURCE			0xFFF3
#define		BF_ERROR_BIND_RESOURCE_TYPE_ERROR	0xFFF2
#define		BF_ERROR_RESOURCE_NO_INITIALIZE		0xFFF1
#define		BF_ERROR_FILE_FORMAT				0xFFF0


// Define Card Type Const
#define     CARD_TYPE_NONE						0x0000
#define     CARD_TYPE_PCI_VOICE_08				0x0001
#define     CARD_TYPE_PCI_VOICE_08_FAX_04		0x0002
#define     CARD_TYPE_PCI_VOICE_08_FAX_08		0x0003
#define     CARD_TYPE_PCI_RECORD_16				0x0004
#define     CARD_TYPE_USB_VOICE_02				0x0005
#define     CARD_TYPE_PCI_RECORD_08				0x0006
#define		CARD_TYPE_PCI_RESERVE_VOICE_CARD	0x0007
#define		CARD_TYPE_PCI_VOICE_16				0x0008
#define		CARD_TYPE_PCI_NEW_VOICE_08_FAX_04	0x0009
#define		CARD_TYPE_PCI_NEW_VOICE_08_FAX_08	0x000A

#define		CARD_TYPE_PCI_DOUBLE_VOICE_08		0x000B
#define		CARD_TYPE_PCI_DOUBLE_VOICE_16		0x000C

#define     CARD_TYPE_PCI_RECORD_04				0x000D



// Define Channel Type Const
#define     CHANNEL_TYPE_NONE					0x0000
#define     CHANNEL_TYPE_USER					0x0001
#define     CHANNEL_TYPE_TRUNK					0x0002
#define     CHANNEL_TYPE_RECORD					0x0003
#define     CHANNEL_TYPE_SPECIAL				0x0004
#define     CHANNEL_TYPE_TRUNK_RECORD			0x0004


// Define Resource Type Const
#define     RESOURCE_TYPE_NONE					0x0000
#define     RESOURCE_TYPE_FAX					0x0001
#define     RESOURCE_TYPE_VOIP					0x0002
#define     RESOURCE_TYPE_CODEC					0x0004
#define     RESOURCE_TYPE_FAX_VOIP				0x0003
#define     RESOURCE_TYPE_FAX_CODEC				0x0005
#define     RESOURCE_TYPE_VOIP_CODEC			0x0006
#define     RESOURCE_TYPE_FAX_VOIP_CODEC		0x0007

#define		CONFERENCE_MODE_NONE				0x0000
#define		CONFERENCE_MODE_TALK				0x0001
#define		CONFERENCE_MODE_LISTEN				0x0002
#define		CONFERENCE_MODE_RECORD				0x0003

#define		VOICE_TYPE_A_LAW					0x0000
#define		VOICE_TYPE_G726_32K					0x0001
#define		VOICE_TYPE_G726_16K					0x0002
#define		VOICE_TYPE_DIALOGIC_ADPCM			0x0003
#define		VOICE_TYPE_LINEAR_8BIT				0x0004		//8-bit unsigned
#define		VOICE_TYPE_LINEAR_16BIT				0x0005		//16-bit unsigned

#define		VOICE_FILE_TYPE_NORMAL				0x0000
#define		VOICE_FILE_TYPE_WAVE				0x0001


#define		FAX_RESOLUTION_LOW					0x0000
#define		FAX_RESOLUTION_FINE					0x0001

#define     STOP_NOT_DTMF						0x00
#define     STOP_ANY_DTMF						0x01

// Define DSP and PC Message
#define     MESSAGE_HAVE_CID_FSK				0x0000
#define     MESSAGE_HAVE_CID_DTMF				0x0001
#define     MESSAGE_HAVE_DTMF					0x0002
#define     MESSAGE_PLAY_VOICE_END				0x0003
#define     MESSAGE_PLAY_VOICE_EXIT				0x0004
#define     MESSAGE_RECORD_VOICE_END			0x0005
#define     MESSAGE_RECORD_VOICE_EXIT			0x0006
#define     MESSAGE_GENERATE_SIGNAL_END			0x0007
#define     MESSAGE_GENERATE_SIGNAL_EXIT		0x0008
#define     MESSAGE_GENERATE_DTMF_END			0x0009
#define     MESSAGE_SEND_FSK_END				0x000A
#define     MESSAGE_HAVE_DIAL_TONE				0x000B
#define     MESSAGE_HAVE_BUSY_TONE				0x000C
#define     MESSAGE_HAVE_BACK_TONE				0x000D
#define     MESSAGE_HAVE_TONE_DATA				0x000E
#define     MESSAGE_HAVE_HELLO_VOICE			0x000F
#define     MESSAGE_HAVE_SILENCE_DATA			0x0010
#define     MESSAGE_HAVE_BACK_TONE_HALT         0x0011
#define     MESSAGE_HAVE_SPECIAL_SIGNAL         0x0012
#define     MESSAGE_HAVE_FSK_DATA               0x0013
#define     MESSAGE_HAVE_TIME_OUT               0x0014

#define     MESSAGE_PLAY_CIRCLE_FIRST_END		0x0015
#define     MESSAGE_PLAY_CIRCLE_SECOND_END		0x0016
#define     MESSAGE_RECORD_CIRCLE_FIRST_END		0x0017
#define     MESSAGE_RECORD_CIRCLE_SECOND_END	0x0018

#define     MESSAGE_AUTO_DIAL_NO_DIAL_TONE		0x0019
#define     MESSAGE_AUTO_DIAL_NONE_LISTEN		0x001A
#define     MESSAGE_AUTO_DIAL_HAVE_BUSY			0x001B
#define     MESSAGE_AUTO_DIAL_HOOK_OFF			0x001C
#define     MESSAGE_AUTO_DIAL_HOOK_OFF_BY_HELLO	0x001D
#define     MESSAGE_AUTO_DIAL_HOOK_OFF_BY_POLE	0x001E

#define     MESSAGE_AUTO_DIAL_HOOK_OFF_BY_FAX	0x001F
#define		MESSAGE_DETECT_HAVE_ASTERISK		0x0020

#define     MESSAGE_HAVE_AUX_TIME_OUT           0x0021


#define     MESSAGE_USER_HOOK_OFF				0x1001
#define     MESSAGE_USER_HOOK_ON				0x1002
#define     MESSAGE_USER_PICK_UP				0x1003
#define     MESSAGE_USER_RING_END				0x1004

#define     MESSAGE_TRUNK_RING					0x2000
#define     MESSAGE_TRUNK_POLE					0x2001
#define     MESSAGE_TRUNK_PICK_UP_END			0x2002
#define     MESSAGE_TRUNK_RING_END				0x2003

#define     MESSAGE_RECORD_OPEN_CIRCLE			0x3001
#define     MESSAGE_RECORD_NO_OPEN_CIRCLE		0x3002
#define     MESSAGE_RECORD_HOOK_OFF				0x3004
#define     MESSAGE_RECORD_HOOK_ON				0x3005
#define     MESSAGE_RECORD_RING					0x3006
#define     MESSAGE_RECORD_RING_END				0x3007

#define     MESSAGE_FAX_SEND_OK					0x5000
#define     MESSAGE_FAX_SEND_ERROR				0x5001
#define     MESSAGE_FAX_RECEIVE_OK				0x5002
#define     MESSAGE_FAX_RECEIVE_ERROR			0x5003
#define     MESSAGE_FAX_REMOTE_TEL_NO			0x5004
#define     MESSAGE_FAX_INFORMATION				0x5005

#define     MESSAGE_FAX_SEND_PAGE_END			0x500A
#define     MESSAGE_FAX_RECEIVE_PAGE_END		0x500B

#define     MESSAGE_FAX_SEND_PAGE_START			0x500C
#define     MESSAGE_FAX_RECEIVE_PAGE_START		0x500D



// Define Channle Status
#define     CHANNEL_STATUS_IDLE					0x0001
#define     CHANNEL_STATUS_OPEN					0x0002		// 1-Open, 0-Close
#define     CHANNEL_STATUS_PLAY					0x0004
#define     CHANNEL_STATUS_RECORD				0x0008
#define     CHANNEL_STATUS_GENERATE_DTMF		0x0010
#define     CHANNEL_STATUS_SEND_FSK				0x0020
#define     CHANNEL_STATUS_GENERATE_SIGNAL      0x0040
#define     CHANNEL_STATUS_DETECT_SIGNAL		0x0080
#define     CHANNEL_STATUS_SEND_FAX				0x0100
#define     CHANNEL_STATUS_RECEIVE_FAX			0x0200
#define     CHANNEL_STATUS_VOIP					0x0400
#define     CHANNEL_STATUS_AUTO_DIAL_OUT		0x0800

// Define struct for all voice card
typedef struct _BF_MESSAGE_INFO{
		unsigned short		MessageCode;
		unsigned short		ChannelNo;
        unsigned short		Parameter[6];
} BF_MESSAGE_INFO, *PBF_MESSAGE_INFO;

typedef struct _BF_TONE_INFO{
		unsigned short		DialToneMinTotalTime;		// Max Signal All times By MilliSecond, default :2500

		unsigned short		BusyToneMaxTotalTime;		// Max Signal All times By MilliSecond, default :1500
		unsigned short		BusyToneMinTotalTime;		// Min Signal All times By MilliSecond, default :500
		unsigned short		BusyToneRatio;				// Ratio(%)(On Times/All Times), default :50
		unsigned short		BusyToneErrorBetweenTwo;	// Error between Ratio (%), default :10
		unsigned short		BusyToneTotalTimes;			// Total Times, default :3

		unsigned short		BackToneMaxTotalTime;		// Max Signal All times By MilliSecond, default :6000
		unsigned short		BackToneMinTotalTime;		// Min Signal All times By MilliSecond, default :4000
		unsigned short		BackToneRatio;				// Ratio(%)(On Times/All Times), default :20
		unsigned short		BackToneErrorBetweenTwo;	// Error between Ratio (%), default :10
		unsigned short		BackToneTotalTimes;			// Total Times, default :2
}BF_TONE_INFO, *PBF_TONE_INFO;

typedef struct _BF_FAX_INFORMATION{
		unsigned short      SignalRate;
		unsigned short      Resolution;
		unsigned short      TwoDimensional;
		unsigned short      RecordWidth;
		unsigned short      RecordLength;
}BF_FAX_INFORMATION, *PBF_FAX_INFORMATION;


#ifdef __cplusplus
extern "C" {
#endif

unsigned short WINAPI BF_InitializeSystem(void);
unsigned short WINAPI BF_CloseSystem(void);
unsigned short WINAPI BF_GetTotalCard(void);
unsigned short WINAPI BF_GetCardSerialNo(unsigned short CardNo, unsigned char *SerialNo);
unsigned short WINAPI BF_SetCardUserID(unsigned short CardNo,unsigned char *Password,unsigned short PasswordLength,unsigned char *UserID);
unsigned short WINAPI BF_GetCardUserID(unsigned short CardNo,unsigned char *Password,unsigned short PasswordLength,unsigned char *UserID);

unsigned short WINAPI BF_GetTotalChannel(void);
unsigned short WINAPI BF_GetChannelType(unsigned short ChannelNo);
unsigned short WINAPI BF_GetChannelStatus(unsigned short ChannelNo);

unsigned short WINAPI BF_OpenChannel(unsigned short ChannelNo);
unsigned short WINAPI BF_OpenSpecialChannel(unsigned short ChannelNo);
unsigned short WINAPI BF_StopChannelOperate(unsigned short ChannelNo);
unsigned short WINAPI BF_CloseChannel(unsigned short ChannelNo);

unsigned short WINAPI BF_CheckMessage(unsigned short WaitTime, PBF_MESSAGE_INFO pMessageBuffer);
unsigned short WINAPI BF_GetMessage(unsigned short WaitTime, PBF_MESSAGE_INFO pMessageBuffer);
unsigned short WINAPI BF_PostMessage(PBF_MESSAGE_INFO pMessageBuffer);

unsigned short WINAPI BF_ListenChannel(unsigned short ChannelNo, unsigned short SourceChannel);
unsigned short WINAPI BF_UnListenChannel(unsigned short ChannelNo);

unsigned short WINAPI BF_LinkChannel(unsigned short FirstChannelNo, unsigned short SecondChannelNo);
unsigned short WINAPI BF_UnLinkChannel(unsigned short FirstChannelNo, unsigned short SecondChannelNo);

unsigned short WINAPI BF_UserRingOn(unsigned short ChannelNo,unsigned short RingOnTime,unsigned short RingOffTime,unsigned short TotalTimes);
unsigned short WINAPI BF_UserRingOff(unsigned short ChannelNo);
unsigned short WINAPI BF_SetUserPickUpTime(unsigned short TimeByMilliSecond);

unsigned short WINAPI BF_TrunkHookOff(unsigned short ChannelNo);
unsigned short WINAPI BF_TrunkHookOn(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectTrunkPolarity(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectTrunkPolarity(unsigned short ChannelNo);
unsigned short WINAPI BF_StartTrunkPickUp(unsigned short ChannelNo,unsigned short TimeByMilliSecond);
unsigned short WINAPI BF_StopTrunkPickUp(unsigned short ChannelNo);

unsigned short WINAPI BF_RecordAgcOn(unsigned short ChannelNo);
unsigned short WINAPI BF_RecordAgcOff(unsigned short ChannelNo);

unsigned short WINAPI BF_StartTimeOut(unsigned short ChannelNo, unsigned short TimeBySecond);
unsigned short WINAPI BF_StopTimeOut(unsigned short ChannelNo);
unsigned short WINAPI BF_SetTimeOutValue(unsigned short ChannelNo, unsigned short TimeBySecond);

unsigned short WINAPI BF_SetVoiceBufferNum(unsigned long MaxVoiceBufferNum);

unsigned short WINAPI BF_StartPlayFile(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartPlayBuffer(unsigned short ChannelNo,char *Buffer,unsigned long Offset,unsigned long Length,char StopChar);

unsigned short WINAPI BF_InitPlayIndexFile(unsigned short ChannelNo);
unsigned short WINAPI BF_AddPlayIndexFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_StartPlayIndexFile(unsigned short ChannelNo,char StopChar);
unsigned short WINAPI BF_InitPlayIndexBuffer(void);
unsigned short WINAPI BF_AddPlayIndexBuffer(char *Buffer,unsigned long Length);
unsigned short WINAPI BF_StartPlayIndexBuffer(unsigned short ChannelNo,unsigned short *IndexTable,unsigned short IndexCount,char StopChar);

//TotalLength ̶Ϊ BF_MaxVoiceBufferNum
unsigned short WINAPI BF_StartPlayCircleBuffer(unsigned short ChannelNo,char *Buffer,unsigned long TotalLength,char StopChar);

unsigned short WINAPI BF_StopPlayVoice(unsigned short ChannelNo);
unsigned short WINAPI BF_GetPlayLength(unsigned short ChannelNo, unsigned long *PlayLength);

unsigned short WINAPI BF_StartRecordFile(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordBuffer(unsigned short ChannelNo,char *Buffer,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordCircleBuffer(unsigned short ChannelNo,char *Buffer,unsigned long TotalLength,char StopChar);
unsigned short WINAPI BF_StopRecordVoice(unsigned short ChannelNo);
unsigned short WINAPI BF_GetRecordLength(unsigned short ChannelNo, unsigned long *RecordLength);

unsigned short WINAPI BF_StartPlayAdpcmFile(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordAdpcmFile(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);

unsigned short WINAPI BF_SetVoiceType(unsigned short ChannelNo, unsigned short VoiceType);
unsigned short WINAPI BF_SetPlayVoiceType(unsigned short ChannelNo, unsigned short VoiceType);
unsigned short WINAPI BF_SetRecordVoiceType(unsigned short ChannelNo, unsigned short VoiceType);
unsigned short WINAPI BF_StartPlayFileByVoiceType(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordFileByVoiceType(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);

unsigned short WINAPI BF_SetPlayVoiceFileType(unsigned short ChannelNo, unsigned short FileType);
unsigned short WINAPI BF_SetRecordVoiceFileType(unsigned short ChannelNo, unsigned short FileType);
unsigned short WINAPI BF_StartPlayFileByFileType(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordFileByFileType(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);

unsigned short WINAPI BF_StartDetectDTMF(unsigned short ChannelNo, unsigned short SmartLevel);
unsigned short WINAPI BF_StopDetectDTMF(unsigned short ChannelNo);
unsigned short WINAPI BF_ClearDTMFBuffer(unsigned short ChannelNo);
unsigned short WINAPI BF_GetDTMFKey(unsigned short ChannelNo,unsigned short DTMFCount,char *DTMFKey);
unsigned short WINAPI BF_CheckHitDTMF(unsigned short ChannelNo);
unsigned short WINAPI BF_GenerateDTMFString(unsigned short ChannelNo, char *DTMFString);

unsigned short WINAPI BF_AutoDialOut(unsigned short ChannelNo,char *DTMFString);
unsigned short WINAPI BF_AutoDialOutWithHello(unsigned short ChannelNo,char *DTMFString);
unsigned short WINAPI BF_AutoDialOutWithPole(unsigned short ChannelNo,char *DTMFString);

unsigned short WINAPI BF_AutoDialOutWithoutDialToneWithHello(unsigned short ChannelNo,unsigned short WaitTimeBySecond,char *DTMFString);
unsigned short WINAPI BF_AutoDialOutWithHelloNoColorRing(unsigned short ChannelNo,char *DTMFString);

unsigned short WINAPI BF_StartGenerateSignal(unsigned short ChannelNo,unsigned short Frequency0,unsigned short Frequency1,unsigned short OnTime,unsigned short OffTime,unsigned short TotalTimes,char StopChar);
unsigned short WINAPI BF_StopGenerateSignal(unsigned short ChannelNo);

unsigned short WINAPI BF_SetDetectToneInfo(unsigned short ChannelNo,PBF_TONE_INFO ToneInfo);
unsigned short WINAPI BF_SetDetectToneFrequency(unsigned short ChannelNo, unsigned short Frequency);
unsigned short WINAPI BF_SetDetectDialToneFrequency(unsigned short ChannelNo, unsigned short Frequency);
unsigned short WINAPI BF_SetDetectBackToneFrequency(unsigned short ChannelNo, unsigned short Frequency);
unsigned short WINAPI BF_SetDetectBusyToneFrequency(unsigned short ChannelNo, unsigned short Frequency);

unsigned short WINAPI BF_StartDetectDialTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectDialTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectBackTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectBackToneStop(unsigned short ChannelNo,unsigned short StopTimeByMs);
unsigned short WINAPI BF_StopDetectBackToneStop(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectBackTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectBusyTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectBusyTone(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectToneData(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectToneData(unsigned short ChannelNo);

unsigned short WINAPI BF_StartDetectHelloVoice(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectHelloVoice(unsigned short ChannelNo);
//ȱʡֵ 0x12
unsigned short WINAPI BF_SetDetectHelloVoiceThreshold(unsigned short ChannelNo, unsigned short ThresholdValue);

unsigned short WINAPI BF_StartDetectSilence(unsigned short ChannelNo,unsigned short ThresholdValue);
unsigned short WINAPI BF_StopDetectSilence(unsigned short ChannelNo);

unsigned short WINAPI BF_SetSpecialSignalFrequency(unsigned short ChannelNo, unsigned short Frequency);
unsigned short WINAPI BF_StartDetectSpecialSignal(unsigned short ChannelNo,unsigned short TimeByMilliSecond);
unsigned short WINAPI BF_StopDetectSpecialSignal(unsigned short ChannelNo);

unsigned short WINAPI BF_StartDetectCallerID(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectCallerID(unsigned short ChannelNo);
unsigned short WINAPI BF_GetRawFskCallerID(unsigned short ChannelNo, char *CallerIDString);
unsigned short WINAPI BF_GetFskCallerID(unsigned short ChannelNo,char *DateTime,char *TelNo,char *Name);

unsigned short WINAPI BF_SendFskCallerID(unsigned short ChannelNo,unsigned char *DateTime,unsigned char *TelNo);

unsigned short WINAPI BF_StartDetectDtmfCallerID(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectDtmfCallerID(unsigned short ChannelNo);
unsigned short WINAPI BF_GetDtmfCallerID(unsigned short ChannelNo,char *TelNo);
// DtmfCallerIDType :: 0-"B" head, "C" tail, 1-Ring Count, 2-Hook off
unsigned short WINAPI BF_SetDtmfCallerIDType(unsigned short ChannelNo, unsigned short DtmfCallerIDType, unsigned short DtmfCallerIDRingCount);

unsigned short WINAPI BF_StartSendFsk(unsigned short ChannelNo,unsigned short SeizureFlag,char *Buffer,unsigned short Count);
unsigned short WINAPI BF_StopSendFsk(unsigned short ChannelNo);
unsigned short WINAPI BF_StartDetectFsk(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectFsk(unsigned short ChannelNo);
unsigned short WINAPI BF_GetFskData(unsigned short ChannelNo,char *Buffer,unsigned short Count);


unsigned short WINAPI BF_ConferenceAddMember(unsigned short ChannelNo,unsigned short Mode,unsigned short Group);
unsigned short WINAPI BF_ConferenceDelMember(unsigned short ChannelNo,unsigned short Mode,unsigned short Group);

unsigned short WINAPI BF_ConferenceAddMemberWithGain(unsigned short ChannelNo,unsigned short Group, short Gain);


unsigned short WINAPI BF_InitTTS(void);
unsigned short WINAPI BF_CloseTTS(void);
unsigned short WINAPI BF_TTSFileToFile(char *TextFileName, char *VoiceFileName);
unsigned short WINAPI BF_TTSBufferToBuffer(char *TextBuffer,unsigned long TextCount,char *VoiceBuffer,unsigned long *VoiceCount);
unsigned short WINAPI BF_TTSBufferToFile(char *TextBuffer,unsigned long TextCount,char *VoiceFileName);


unsigned short WINAPI BF_AlawToWave(char *AlawFileName, char *WaveFileName);
unsigned short WINAPI BF_WaveToAlaw(char *WaveFileName, char *AlawFileName);
unsigned short WINAPI BF_AlawToAdpcm(char *AlawFileName, char *AdpcmFileName);
unsigned short WINAPI BF_AdpcmToAlaw(char *AdpcmFileName, char *AlawFileName);

unsigned short WINAPI BF_G711ToG726(char *G711FileName,char *G726FileName,unsigned short G726VoiceType);
unsigned short WINAPI BF_G726ToG711(char *G726FileName,unsigned short G726VoiceType,char *G711FileName);


unsigned short WINAPI BF_ReadVoicePacket(unsigned short ChannelNo, char *Buffer);
unsigned short WINAPI BF_WriteVoicePacket(unsigned short ChannelNo, char *Buffer);



unsigned short WINAPI BF_GetTotalResource(void);
unsigned short WINAPI BF_GetResourceType(unsigned short ResourceNo);

unsigned short WINAPI BF_OpenResource(unsigned short ResourceNo,unsigned short ResourceType);
unsigned short WINAPI BF_CloseResource(unsigned short FaxChannelNo);

unsigned short WINAPI BF_BindResource(unsigned short ChannelNo, unsigned short ResourceNo);
unsigned short WINAPI BF_FreeResource(unsigned short ChannelNo, unsigned short ResourceNo);



unsigned short WINAPI BF_InitFaxFunction(void);
unsigned short WINAPI BF_CloseFaxFunction(void);
unsigned short WINAPI BF_SetFaxLocalTelNo(unsigned short ChannelNo,unsigned char *LocalTelNo);
unsigned short WINAPI BF_GetFaxRemoteTelNo(unsigned short ChannelNo,unsigned char *RemoteTelNo);
unsigned short WINAPI BF_GetFaxInformation(unsigned short ChannelNo, PBF_FAX_INFORMATION FaxInformation);
unsigned short WINAPI BF_GetFaxPageNo(unsigned short ChannelNo);
// One Line Max byte is 106
// Must use 0x0A to end the current line, Buffer content cann't have 0x0D
unsigned short WINAPI BF_SendFaxTxtBuffer(unsigned short ChannelNo, char *TxtBuffer, unsigned short BufferCount);
unsigned short WINAPI BF_SendFaxTxtFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_SendBitFaxFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_SendTiffFaxFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_ReceiveBitFaxFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_ReceiveTiffFaxFile(unsigned short ChannelNo, char *FileName);
unsigned short WINAPI BF_StopFaxOperate(unsigned short ChannelNo);
// Send three BitFax File Function, Max File Num is Three, connected by "+"
unsigned short WINAPI BF_SendMultiBitFaxFile(unsigned short ChannelNo,char *Directory,char *FileName);
// Call Function BF_SetFaxResolution must before BF_Send/ReceiveFax... and after BF_OpenResource
unsigned short WINAPI BF_SetFaxResolution(unsigned short ChannelNo,unsigned short FaxResolution);
unsigned short WINAPI BF_GetFaxResolution(unsigned short ChannelNo,unsigned short *FaxResolution);

unsigned short WINAPI BF_SetFaxSendHeaderFlag(unsigned short ChannelNo, unsigned short FaxSendHeaderFlag);
unsigned short WINAPI BF_SetFaxHeader(unsigned short ChannelNo,char *FaxFrom,char *FaxTo,char *FaxNo,char *FaxSubject,char *DateTime);

//ҳ1ʼʼҳԵڽֹҳ
unsigned short WINAPI BF_SendBitFaxFileWithPageNo(unsigned short ChannelNo, unsigned short StartPageNo, unsigned short EndPageNo, char *FileName);
//ҳ1ʼʼҳԵڽֹҳ
unsigned short WINAPI BF_SendTiffFaxFileWithPageNo(unsigned short ChannelNo, unsigned short StartPageNo, unsigned short EndPageNo, char *FileName);

unsigned short WINAPI BF_TiffToBitFax(char *TiffFile,char *BitFaxFile);
unsigned short WINAPI BF_BitFaxToTiff(char *BitFaxFile,char *TiffFile);

unsigned short WINAPI BF_SetFaxMaxRate(unsigned short ChannelNo, unsigned short FaxMaxRate);


// Next Functions Only Used By VoIP Card
unsigned short WINAPI BF_StartVoipOperate(unsigned short ChannelNo);
unsigned short WINAPI BF_StopVoipOperate(unsigned short ChannelNo);
unsigned short WINAPI BF_ReadVoipPacket(unsigned short ChannelNo, unsigned char *Buffer);
unsigned short WINAPI BF_WriteVoipPacket(unsigned short ChannelNo, unsigned char *Buffer);

unsigned short WINAPI BF_SetRecordVolumeGain(unsigned short ChannelNo, unsigned short VolumeGain);
unsigned short WINAPI BF_GetRecordVolumeGain(unsigned short ChannelNo, unsigned short *VolumeGain);
unsigned short WINAPI BF_SetPlayVolumeGain(unsigned short ChannelNo, unsigned short VolumeGain);
unsigned short WINAPI BF_GetPlayVolumeGain(unsigned short ChannelNo, unsigned short *VolumeGain);

unsigned short WINAPI BF_LinkVoiceAndVoIP(unsigned short ChannelNo, unsigned short ResourceNo);
unsigned short WINAPI BF_UnLinkVoiceAndVoIP(unsigned short ChannelNo, unsigned short ResourceNo);

// 0-G723 6.3Kbit/s; 1-G729 8Kbit/s
unsigned short WINAPI BF_SetVoipCodecType(unsigned short ResourceNo, unsigned short CodecType);



unsigned short WINAPI BFTTS_SysInit();
void WINAPI BFTTS_SysRelease();

//ֵvocЧ
unsigned short WINAPI BFTTS_TextFiletoVoiceFile(char * szTextFileName, char * szVoiceFileName);

//szVoiceBufferҪȷ
//ֵvocЧ
unsigned short WINAPI BFTTS_TextFiletoVoiceBuffer(char * szTextFileName, char * szVoiceBuffer);

//ֵvocЧ
unsigned short WINAPI BFTTS_TextBuffertoVoiceFile(char * szTextBuffer, char * szVoiceFileName);

//szVoiceBufferҪȷ
//ֵvocЧ
unsigned short WINAPI BFTTS_TextBuffertoVoiceBuffer(char * szTextBuffer, char * szVoiceBuffer);

//ٶȣȡֵΧ0-100ȱʡֵ50
unsigned short WINAPI BFTTS_SetSpeechSpeed(int nSpeed);

//ȡֵΧ0-100ȱʡֵ50
unsigned short WINAPI BFTTS_SetSpeechVolume(int nVolume);

//ȡֵΧ0-100ȱʡֵ50
unsigned short WINAPI BFTTS_SetSpeechPitchBaseLine(int nPitchBaseLine);

unsigned short WINAPI BF_StartPlayColorBackground(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar,short VoiceVolume);
unsigned short WINAPI BF_StopPlayColorBackground(unsigned short ChannelNo);


unsigned short WINAPI BF_GetLastErrorCode(void);
unsigned char * WINAPI BF_GetLastErrorString(void);


unsigned short WINAPI BF_SetGenerateDtmfTime(unsigned short ChannelNo, unsigned short OnTime, unsigned short OffTime);

unsigned short WINAPI BF_SetDetectBusyTone2Parameter(unsigned short ChannelNo,
		unsigned short		BusyToneMaxTotalTime,		// Max Signal All times By MilliSecond, default :1500
		unsigned short		BusyToneMinTotalTime,		// Min Signal All times By MilliSecond, default :500
		unsigned short		BusyToneRatio,				// Ratio(%)(On Times/All Times), default :50
		unsigned short		BusyToneErrorBetweenTwo,	// Error between Ratio (%), default :10
		unsigned short		BusyToneTotalTimes			// Total Times, default :3
);
unsigned short WINAPI BF_SetDetectDualBusyToneFrequency(unsigned short ChannelNo, unsigned short Frequency1, unsigned short Frequency2);


unsigned short WINAPI BF_StartMixVoice(unsigned short FirstChannelNo,unsigned short SecondChannelNo);
unsigned short WINAPI BF_StartMixVoiceWithGain(unsigned short FirstChannelNo,unsigned short SecondChannelNo,unsigned short FirstChannelGain,unsigned short SecondChannelGain);
unsigned short WINAPI BF_StopMixVoice(unsigned short FirstChannelNo,unsigned short SecondChannelNo);

//A-LawļMixFlag=0ѭϣMixFlag=1ѭ
unsigned short WINAPI BF_MixVoiceFile(char *FirstFileName, char *SecondFileName, char *TargetFileName, unsigned short MixFlag);


unsigned short WINAPI BF_StartDetectThreeAsrerisk(unsigned short ChannelNo);
unsigned short WINAPI BF_StopDetectThreeAsrerisk(unsigned short ChannelNo);



// ͬʱͶTiffļ
#define SEND_MULTI_FAX_FILE_TYPE_LAST		0	// һļ
#define SEND_MULTI_FAX_FILE_TYPE_VALID		1	// ǰļ
#define SEND_MULTI_FAX_FILE_TYPE_PASS		2	// Եǰļ
//#define SEND_MULTI_FAX_FILE_TYPE_COMPAGES	3	// һļĵһҳ

typedef struct _SEND_MULTI_FAX_INFO{
	char FileName[256];
	unsigned short StartPage;
	unsigned short EndPage;
	unsigned short Resolution;
	unsigned short Type;  	
}SEND_MULTI_FAX_INFO, *PSEND_MULTI_FAX_INFO;

unsigned short WINAPI BF_SendMultiTiffFaxFile(unsigned short ChannelNo,PSEND_MULTI_FAX_INFO FileInfo,unsigned short FileCount);

unsigned short WINAPI BF_GetFaxLength(unsigned short ChannelNo, unsigned long *FaxLength);



unsigned short WINAPI BF_TiffFileGetTotalPage(char *SourceFile, unsigned short *TotalPage);
unsigned short WINAPI BF_GetTiffFileFillOrder(char *TiffFileName, unsigned short *FillOrder);
unsigned short WINAPI BF_GetTiffFileResolution(char *TiffFileName, unsigned short *FaxResolution);

unsigned short WINAPI BF_TextFileToTiffFile(char *TextFile,char *TiffFile, unsigned short FaxResolution);
unsigned short WINAPI BF_TiffFileLowResolutionToHighResolution(char *SourceFile,char *TargetFile);
unsigned short WINAPI BF_TiffFileHighResolutionToLowResolution(char *SourceFile,char *TargetFile);
unsigned short WINAPI BF_TiffFileChangeFillOrder(char *SourceFile, char *TargetFile);
// λͼȲܴ864ұܱ32
unsigned short WINAPI BF_BmpFileToTiffFile(char *BmpFile, char *TiffFile);

// ӡ
unsigned short WINAPI BF_SetFaxPrinterFileName(char *FaxFileName);
unsigned short WINAPI BF_GetFaxPrinterFileName(char *FaxFileName);
unsigned short WINAPI BF_GetFaxPrinterPageNo(unsigned short *PageNo);
unsigned short WINAPI BF_GetFaxPrinterStartFlag(void);
unsigned short WINAPI BF_GetFaxPrinterEndFlag(void);
unsigned short WINAPI BF_SetFaxPrinterApplicationExe(char *ApplicationExe);



unsigned short WINAPI BF_StartPlayFileByFileTypeForConference(unsigned short GroupNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartRecordFileByFileTypeForConference(unsigned short GroupNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StopPlayVoiceForConference(unsigned short GroupNo);
unsigned short WINAPI BF_StopRecordVoiceForConference(unsigned short GroupNo);

unsigned short WINAPI BF_UserRingOnWithDtmfCallerID(unsigned short ChannelNo,unsigned char *TelNo,unsigned short RingCount);
unsigned short WINAPI BF_UserRingOnWithFskCallerID(unsigned short ChannelNo,unsigned char *DateTime,unsigned char *TelNo,unsigned short RingCount);

unsigned short WINAPI BF_StartPlayFileByFileTypeForMixVoice(unsigned short ChannelNo,char *FileName,unsigned long Offset,unsigned long Length,char StopChar);
unsigned short WINAPI BF_StartPlayIndexFileForMixVoice(unsigned short ChannelNo,char StopChar);
unsigned short WINAPI BF_StopPlayVoiceForMixVoice(unsigned short ChannelNo);


// Next For 2 Line USB
unsigned short WINAPI BF_ControlLed(unsigned short CardNo, unsigned short LedNo, unsigned short LightFlag);




// Only Record(R08, R16) Card function
unsigned short WINAPI BF_SetLineHookVoltage(unsigned short ChannelNo, unsigned short HookOnVoltage, unsigned short HookOffVoltage);
unsigned short WINAPI BF_GetLineCurrentVoltage(unsigned short ChannelNo, unsigned short *VoltageValue);
// 0-ԣ-
unsigned short WINAPI BF_GetLineVoltagePolarity(unsigned short ChannelNo, unsigned short *PolarityValue);
// 0-˳1-ߵ˳򣬼ժѹ
unsigned short WINAPI BF_SetChannelHookMode(unsigned short ChannelNo, unsigned short HookMode);


//USBһ¼
//=0, ʱļ; =1, DSPļֻͬһUSBеļʱļ
unsigned short WINAPI BF_SetChannelListenType(unsigned short ChannelNo, unsigned short ListenType);


unsigned short WINAPI BF_StartAuxTimeOut(unsigned short ChannelNo, unsigned short TimeBySecond);
unsigned short WINAPI BF_StopAuxTimeOut(unsigned short ChannelNo);

//0--G723, 1-G729
unsigned short WINAPI BF_InitializeSystemWithPara(unsigned short CodecType);


//ʼͨ͵ DLL 
unsigned short WINAPI BF_StartSendRecordData(unsigned short ChannelNo);
//ֹͣͨ͵ DLL 
unsigned short WINAPI BF_StopSendRecordData(unsigned short ChannelNo);
//ȡָͨ¼ַûָBF_ERROR
//DataCount ܴ BF_HalfVoiceBufferNum 0x400 
unsigned short WINAPI BF_GetRecordDataPoint(unsigned short ChannelNo, unsigned short DataCount, char *DataPoint);


unsigned short WINAPI BF_GetCardDspTimer(unsigned short CardNo, unsigned short *DspTimer);
unsigned short WINAPI BF_GetDriverIntrFlag(unsigned short CardNo, unsigned short *IntrFlag, unsigned short *DpcIntrFlag);


//˫ģģлоƬ8·16·Ч
unsigned short WINAPI BF_HardwareConferenceAddMember(unsigned short ChannelNo,unsigned short Group, unsigned short InputGain, unsigned short OutputGain);
unsigned short WINAPI BF_HardwareConferenceDelMember(unsigned short ChannelNo, unsigned short Group);

unsigned short WINAPI BF_HardwareConferenceChannel2GenerateSignal(unsigned short ChannelNo);


unsigned short WINAPI BF_ReadPlayRecordVoicePacket(unsigned short ChannelNo, char *Buffer);


unsigned short WINAPI BF_AbsoluteListenSlot(unsigned short CardNo, unsigned short TargetSlot, unsigned short SourceSlot);



unsigned short WINAPI BF_PlayVoiceAgcOnOff(unsigned short ChannelNo, unsigned short AgcOnOff);
unsigned short WINAPI BF_RecordVoiceAgcOnOff(unsigned short ChannelNo, unsigned short AgcOnOff);

//  AgcGainMinValue(ԽС)  AgcGainMaxValue(Խ)ʹСźŷŴ
// ȱʡֵ
//		AgcGainMinValue = 0.12
//		AgcGainMaxValue = 25.0
unsigned short WINAPI BF_SetAgcGainMinValue(unsigned short ChannelNo, double AgcGainMinValue);
unsigned short WINAPI BF_SetAgcGainMaxValue(unsigned short ChannelNo, double AgcGainMaxValue);



unsigned short WINAPI BF_GetProductVersionNumber(char *VersionNumber);
unsigned short WINAPI BF_GetSoftwareVersionNumber(char *VersionNumber);
unsigned short WINAPI BF_GetProductVendorID(char *VendorIDString);


#ifdef __cplusplus
}
#endif

#endif          // BF_VOICE_INCLUDE
