require "prefabutil"

local Assets =
{
  Asset("ANIM", "anim/coffee2_seeds.zip"),
	Asset("ATLAS", "images/inventoryimages/coffee2_seeds.xml"),
	Asset("IMAGE", "images/inventoryimages/coffee2_seeds.tex")
}


local prefabs =
		{
			"coffee2",
			"coffee2_seeds"
		} 



local function fn(Sim)
       local inst = CreateEntity()
	    inst.entity:AddTransform()
	    inst.entity:AddAnimState()
      inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
	    inst.AnimState:SetBank("coffee2_seeds")
	    inst.AnimState:SetBuild("coffee2_seeds")
	    inst.AnimState:SetRayTestOnBB(true)
		  inst.AnimState:PlayAnimation("idle")

inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
      inst.components.edible.foodtype = "SEEDS"
      inst.components.edible.healthvalue = 0
      inst.components.edible.hungervalue = 0
      inst.components.edible.sanityvalue = 0
  
  MakeHauntableLaunch(inst)

    inst:AddComponent("inspectable")
    inst:AddComponent("perishable")
      inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
      inst.components.perishable:StartPerishing()
      inst.components.perishable.onperishreplacement = "spoiled_food"
      
    inst:AddComponent("cookable")
      inst.components.cookable.product = "seeds_cooked"
      
    inst:AddComponent("inventoryitem")
      inst.components.inventoryitem.imagename = "coffee2_seeds"
      inst.components.inventoryitem.atlasname = "images/inventoryimages/coffee2_seeds.xml"

	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = 40




	
	inst:AddComponent("bait")
	inst:AddComponent("plantable")
	inst.components.plantable.growtime = TUNING.SEEDS_GROW_TIME
	inst.components.plantable.product = "coffee2"
	
	
	return inst
end

return Prefab( "common/inventory/coffee2_seeds", fn, Assets)

			