function setInteractive(state)
  if entity.setInteractive then entity.setInteractive(state)
  else object.setInteractive(state) end
end

function configParameter(name,default)
  if entity.configParameter then
    return entity.configParameter(name,default)
  else
    return config.getParameter(name,default)
  end
end
------------------------- end of glad/cheerful api changes ---------------------------

function init(virtual)
  if not virtual then
--  printTable(0,_ENV)
    setInteractive(true)
  end
end

function onInteraction(args)
  if args ~= nil and args.sourceId ~= nil then
    local p = entity.position()
    local parameters = {}
--    local type = "gardenbotv80g"
--    if entity.configParameter("botspawner.type") ~= nil then
      local type = configParameter("botspawner.type","gardenbotv80g")
--    end
    parameters.persistent = true
--    parameters.damageTeam = 1
    parameters.ownerUuid = world.entityUniqueId(args.sourceId) or args.sourceId
    parameters.selfUuid = sb.makeUuid()
    parameters.level = getLevel()
    parameters.spawnPoint = {p[1], p[2]}
    world.spawnMonster(type, {p[1], p[2] +0.5}, parameters)
--    entity.smash()
    world.breakObject(entity.id(),true)
  end
end

function getLevel()
  if world.getProperty("ship.fuel") ~= nil then return 10 end
  if world.threatLevel then return world.threatLevel() end  -- pleased giraffe
  return 1
end

--------------------------------------------------------------------------------

--prints tables
function printTable(indent, value)
    local tabs = "";
    for i=1,indent,1 do
        tabs = tabs.."    ";
    end
    table.sort(value)
    for k,v in pairs(value) do
        sb.logInfo(tabs..getValueOutput(k,v));
        if type(v) == "table" then
            if tostring(k) == "utf8" then
                sb.logInfo("    "..tabs.."SKIPPING UTF8")-- SINCE IT SEEMS TO HAVE NO END AND JUST BE FILLED WITH TABLES OF TABLES
            else
                if tableLen(v) == 0 then
                    sb.logInfo("    "..tabs.."EMPTY TABLE")
                else
                    printTable(indent+1,v);
                 
                end
            end
            sb.logInfo(" ");
        end
    end
 
end

function tableLen(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end

--Required for printTable
function getValueOutput(key ,value)
    if type(value) == "table" then
        return "table : "..key;
    elseif type(value) == "function" then
        return "function : "..key.."()"
    elseif type(value) == "string" then
        return "string : "..key.." - \""..tostring(value).."\"";
    else
        return type(value).." : "..key.." - "..tostring(value);
    end
end