require "/scripts/status.lua"

delegate.create("gardenbot")
--------------------------------------------------------------------------------
gardenbot = {}
profilerApi = {}
--------------------------------------------------------------------------------
function isGardenbot() return true end
--------------------------------------------------------------------------------
function isPleasedGiraffe() 
if self.isPleasedGiraffe == nil then 
if world.spawnTreasure and world.objectSpaces then self.isPleasedGiraffe = true 
else self.isPleasedGiraffe = false end end

return self.isPleasedGiraffe
end
--------------------------------------------------------------------------------
function isGladGiraffe() 
end
--------------------------------------------------------------------------------
function gardenbot.init(args)
--  printTable(0,_ENV)
  if storage.uuid == nil then storage.uuid = config.getParameter("selfUuid",sb.makeUuid()) end
  if storage.ownerUid == nil then storage.ownerUid = config.getParameter("ownerUuid",nil) end -- player spawned
  monster.setDeathParticleBurst("deathPoof")
  setAnimationState("movement", "idle")
  monster.setAggressive(config.getParameter("aggressive"),false)
  status.addEphemeralEffect("monsterrelease")
  
  self.damageSources = ControlMap:new(config.getParameter("damageSources", {}))
  monster.setDamageTeam({type = "friendly"})--{type ="passive" }
  self.playerCheckTime = 0
  
  local bname = monster.type()
  self.displayName = string.sub(bname,string.find(bname,"v"),-1)
  monster.setName(self.displayName)
  monster.setDisplayNametag(true)

  self.inv = inventoryManager.create()

  if storage.efficiency == nil then storage.efficiency = 0.75 end
  self.ignore = {beakseed = true, talonseed = true, seedpile = true}
  self.ignoreIds = {}
  storage.seedMemory = {}
  storage.failedMemory = {}
  local harvest = config.getParameter("gardenSettings.gatherables")
  if harvest ~= nil then
    self.harvest = {}
    self.harvestMatch = {}
    self.harvestType = {}
    for _,v in ipairs(harvest) do
      if type(v) == "string" then self.harvest[string.lower(v)] = true end
      if type(v) == "table" then
        for h,t in pairs(v) do
          if t == "match" then table.insert(self.harvestMatch, h) end
          if t == "type" then self.harvestType[string.lower(h)] = true end
        end
      end
    end
  end
  self.searchType = config.getParameter("gardenSettings.searchType")
  self.searchDistance = config.getParameter("gardenSettings.searchDistance")
  
  self.spawnPoint = config.getParameter("spawnPoint") or mcontroller.position()
  self.lastMoveDirection = util.randomDirection()
  self.shielded = false
  
  script.setUpdateDelta(10)
  self.isCodeProfiling = type(profilerApi.init) == "function" and false
  if self.isCodeProfiling then profilerApi.init() end
  storage.blockstats = nil and {} or storage.blockstats
  
  --[[
  -- replacement for old monsterDamaged() broadcast message - does same thing differently
  self.damageListener = damageListener("damageTaken",function(notifications)
    for _,notification in pairs(notifications) do
      if (notification.damage and notification.damage > 0) --and notification.sourceEntityId > 0 
      --and self.targetId == nil 
      and notification.targetEntityId ~= entity.id() and notification.sourceEntityId ~= entity.id()  then
--      and world.callScriptedEntity(notification.sourceEntityId,"isGardenbot") == true
--        self.state.pickState(notification.targetEntityId)
        monster.say(util.tableToString(notifications))
        return
      end
    end  
  end)
 --]] 
end
--------------------------------------------------------------------------------
function gardenbot.update()
--  self.damageListener:update()
  if self.playerCheckTime < 0 then
    self.playerCheckTime = 1
    local players = world.entityQuery(mcontroller.position(), 5, {
      includedTypes = { "player" },
      boundMode = "Position"
    })

    if #players > 0 then
      if storage.ownerUid then -- is owned by a player
        for _,eid in ipairs(players) do
          if world.entityUniqueId(eid) == storage.ownerUid then
            monster.setDamageTeam({type = "passive"})
      --      monster.say(string.format("%s\n%s",entity.damageTeam().type,entity.damageTeam().team))
          end
        end
      end
    elseif entity.damageTeam().type ~= "friendly" then
      monster.setDamageTeam({type = "friendly"})
      self.targetId = nil
    end
  else
    self.playerCheckTime = self.playerCheckTime - 1--script.updateDt()
  end
  
end
--------------------------------------------------------------------------------
function gardenbot.damage(args)
--sb.logInfo("\ndamage args: %s",args)
--monster.say(util.tableToString(args))
  if args.sourceId >= 0 or world.isNpc(args.sourceId) or world.isMonster(args.sourceId) then -- not a player, hax hp
    status.setResource("health", status.stat("maxHealth"))
  elseif args.sourceId < 0 and args.sourceKind == "bugnet" then
    status.setResourcePercentage("health", 0)
  end


  if status.resource("health") <= 0 and not self.dead then -- lpk: also check dead to fix dupe exploit ;(
--  debugfunctables()
--  printTable(0,_ENV)
--  if storage.blockstats ~= nil then sb.logInfo("\nBlockStats: %s",storage.blockstats) end
  if self.isCodeProfiling then profilerApi.logData() end
    local spawner = nil
    if monster.type() then spawner = monster.type() .. "spawner" end
    if spawner ~= nil then self.inv.add({name = spawner, count = 1}) end
    self.inv.drop({all = true, position = mcontroller.position()})
    self.dead = true
    if animator.hasSound("dead") then animator.playSound("dead") end
  else
  self.state.pickState(args.sourceId) -- not dead, attack back
  end
end
--------------------------------------------------------------------------------
function debugfunctables()
if not self.debug then return end
util.debugLog("\nroot: \n%s",root)
util.debugLog("\nsb: \n%s",sb)
--util.debugLog("\nuniverse: \n%s",universe)
util.debugLog("\nworld: \n%s",world)
util.debugLog("\nentity: \n%s",entity)
util.debugLog("\nmcontroller: \n%s",mcontroller)
util.debugLog("\nstatus: \n%s",status)

end
--------------------------------------------------------------------------------
function shouldDie()
  return self.dead
end
--------------------------------------------------------------------------------
function cooldown(base)
if base == nil then base = config.getParameter("gardenSettings.cooldown", 15) end
if type(base) ~= "number" then return 1 end
return (base + math.random(base))/2
end
--------------------------------------------------------------------------------
function setDamageSources(enabled)
--self.damageSources:clear()
if enabled then
  -- local td = config.getParameter("touchDamage",{})
  -- local ds = {}
  -- ds.poly = mcontroller.collisionPoly()
  -- ds.team = entity.damageTeam()
  -- ds.damage = td.damage * root.evalFunction("monsterLevelPowerMultiplier", monster.level())
  -- ds.damageSourceKind = td.damageSourceKind
  -- ds.statusEffects = td.statusEffects
  -- monster.say(string.format("%s",util.tableToString(ds)))
--  monster.setDamageSources(ds)
  local partSources = {}
  for part,ds in pairs(config.getParameter("damageParts", {})) do
    local damageArea = animator.partPoly(part, "damageArea")
    if damageArea then
      ds.poly = damageArea
      table.insert(partSources, ds)
    end
  end
  
  local ds = config.getParameter("touchDamage",{})
  if ds.damage then 
  ds.knockback = ds.damage
  if ds.damageSourceKind == "electric" then table.insert(ds.statusEffects,"electrified") end
  table.insert(partSources, ds) 
  end

  local damageSources = util.mergeLists(partSources, self.damageSources:values())
  damageSources = util.map(damageSources, function(ds)
    ds.damage = ds.damage * root.evalFunction("monsterLevelPowerMultiplier", monster.level())  /2--* status.stat("powerMultiplier")
    if ds.knockback and type(ds.knockback) == "table" then
      ds.knockback[1] = ds.knockback[1] * mcontroller.facingDirection()
    end

    local team = entity.damageTeam()
    ds.team = { type = ds.damageTeamType or team.type, team = ds.damageTeam or team.team }
    
    return ds
  end)
  --monster.say(string.format("%s",damageSources.damage))
  monster.setDamageSources(damageSources)
else
  monster.setDamageSources({})
end
end
--------------------------------------------------------------------------------
function canReachTarget(target, ignoreLOS)
  local position = nil
  local pad = 1.2
  if type(target) == "number" then
    position = world.entityPosition(target)
    pad = pad + config.getParameter("gardenSettings.interactRange") / 2
  elseif type(target) == "table" then
    position = target
  end
  if position == nil then return nil end
  local collision = false
  local ep = mcontroller.position()

  local ctype
  if isPleasedGiraffe() then    ctype = {"Null","Block","Dynamic"}
  else   ctype = "Any"  end
  local blocks = world.collisionBlocksAlongLine(ep, position, ctype, 2)
  collision = blocks[1] ~= nil
  if string.find(self.searchType, 'lumber$') then collision = #blocks == 2 end --lpk: why?
  local fovHeight = config.getParameter("gardenSettings.fovHeight",2)/2
  local min = nil
  local max = nil
  ep[2] = ep[2] + mcontroller.boundBox()[2] + fovHeight-- lpk: fix for lumber foot pos
  --Target to the left
  if ep[1] > position[1] then
    min = {position[1]+pad, ep[2] - fovHeight}
    max = {ep[1]-pad, ep[2] + fovHeight}
  --Target to the right
  else
    min = {ep[1]+pad, ep[2] - fovHeight}
    max = {position[1]-pad, ep[2] + fovHeight}
  end
--util.debugRect({min[1],min[2],max[1],max[2]},"#ff00ff")
  local oIds = world.objectQuery(min, max, { callScript = "config.getParameter", callScriptArgs = {"category"}, callScriptResult = "gardenfence" })
  if oIds[1] ~= nil then
     return false,world.entityPosition(oIds[1])
  end
  return ignoreLOS == true or not collision
end
--------------------------------------------------------------------------------
function distanceSort(a, b)
  local position = mcontroller.position()
  local da = world.magnitude(position, world.entityPosition(a))
  local db = world.magnitude(position, world.entityPosition(b))
  return da < db
end
--------------------------------------------------------------------------------
function isOre(modName)
oreList = {
"aegisalt","coal","copper","corefragment","crystal","diamond","durasteel","gold","iron",
"lead","moonstone","platinum","plutonium","prisilite","rubium","silver","solarium",
"sulphur","titanium","trianglium","tungsten","uranium","violium","ferozium","erchius"
}
  for i,v in ipairs(oreList) do
    if v == modName then return true end
  end
  return false
end

function dropNameFromMod(modName)
oreMap = {
"aegisaltore","coalore","copperore","corefragmentore","crystal","diamond","durasteelore","goldore","ironore", 
"lead","moonstoneore","platinumore","plutoniumore","prisiliteore","rubiumore","silverore","solariumore",
"sulphur","titaniumore","triangliumore","tungstenore","uraniumore","violiumore","feroziumore"
}
  if modName == "erchius" then return "solidfuel" end
  for i,v in ipairs(oreMap) do
    if string.find(v,modName) then return v end
  end
  return "perfectlygenericitem" -- should never get here, but if it happens...
end

--------------------------------------------------------------------------------
function touchingFenceDirection(mcPos,moveDir)
  --lpk: called by move, check for fence here, returns a direction
  -- for some reason profiling makes this not work?!wtfh
  local outDir = util.toDirection(moveDir)   
  local b,t = canReachTarget(vec2.add(mcPos, {outDir*1.5, 0}))
  if not b and t ~= nil then -- hit garden fence
    local distance = world.distance(t, mcPos)
    outDir = -util.toDirection(distance[1]) -- bounce
	  local passDir = util.toDirection(distance[1]) -- passthru to homebin maybe?
    local binPos = self.spawnPoint-- use spawn if no homebin
	  if self.homeBin ~= nil and world.entityExists(self.homeBin) then
	    binPos = world.entityPosition(self.homeBin)
	  end
	  local binDist = world.distance(binPos, mcPos)
	  local binDir = util.toDirection(binDist[1])
	  if binDir == passDir then 
		  outDir = passDir 
	  end  
--	if mcontroller.onGround() then
--    mcontroller.setVelocity({moveDir * world.gravity(mcontroller.position()),0})
--  end
  if self.debug then
    world.debugText("%s",outDir,vec2.add(t,{-0.5,3}),"yellow")
    util.debugRect({t[1],t[2],t[1]+1,t[2]+3},"yellow")
  end
  end
 return outDir * math.abs(moveDir)
end
--------------------------------------------------------------------------------

function maybeKickPetball() -- kick ball instead of damaging it, not that bot did dmg anyway >.>
  if self.targetId and world.entityExists(self.targetId) 
  and world.monsterType(self.targetId) == "petball" then
    world.callScriptedEntity(self.targetId, "punt", mcontroller.facingDirection())
    return true
  end
  return false
end
--------------------------------------------------------------------------------
function chatNearbyPlayerOrBot()
-- report current inventory to players ?
-- binary art for bots - icons built into hobo etc.
  --  entity.say("01000101") "ð«""ԑ(þ)Ӟ"

  -- entity.say doesnt work, may have to spawn a temp item like gardenplot that only does say then breaks
end

--------------------------------------------------------------------------------
-- movement funcs, mostly cribbed from groundmovement.lua
--------------------------------------------------------------------------------
-- NOTE: this will be inaccurate if called more than once per tick
function checkStuck()
  local newPos = mcontroller.position()
  if newPos[1] == self.stuckPosition[1] and newPos[2] == self.stuckPosition[2] then
    self.stuckCount = self.stuckCount + 1
  else
    self.stuckCount = 0
    self.stuckPosition = newPos
  end

  return self.stuckCount
end

--------------------------------------------------------------------------------
function calculateSeparationMovement()
  local entityIds = world.entityQuery(mcontroller.position(), 0.5, { includedTypes = {"monster"}, withoutEntityId = entity.id(), order = "nearest" })
  if #entityIds > 0 then
    if monster.type() == world.monsterType(entityIds[1]) then
      local separationMovement = world.distance(mcontroller.position(), world.entityPosition(entityIds[1]))
      return util.toDirection(separationMovement[1])
    end
  end
  return 0
end

--------------------------------------------------------------------------------
function travelTime(distance) -- lpk: modded to accept a pos also
  if type(distance) == "table" then return travelTimeToPos(distance) end
  local runSpeed = mcontroller.baseParameters().walkSpeed
  return math.abs(distance / runSpeed)
end

function travelTimeToPos(pos)
  local toTarget = world.distance(pos, mcontroller.position())
  local distance = world.magnitude(toTarget)
  local runSpeed = mcontroller.baseParameters().walkSpeed
  return math.abs(distance / runSpeed)
end
--------------------------------------------------------------------------------
-- estimate the maximum jump duration
function jumpTime()
  return (2 * mcontroller.baseParameters().airJumpProfile.jumpSpeed) / (world.gravity(mcontroller.position()) * 1.5)
end

--------------------------------------------------------------------------------
-- estimate the maximum jump height
function jumpHeight()
  return (mcontroller.baseParameters().airJumpProfile.jumpSpeed * jumpTime()) / 4
end

--------------------------------------------------------------------------------
function faceTarget()
  if self.onGround then
    mcontroller.controlFace(self.toTarget[1])
  end
end

--------------------------------------------------------------------------------
function controlFace(direction)
  if self.onGround then
    mcontroller.controlFace(direction)
  end
end

--------------------------------------------------------------------------------
function isBlocked(direction)
  local direction = direction or mcontroller.facingDirection()
  local position = mcontroller.position()
  position[1] = position[1] + direction

  if not world.resolvePolyCollision(mcontroller.collisionPoly(), position, 0.8) then
    return true
  end
  return false
end

--------------------------------------------------------------------------------
function willFall(direction)
  local direction = direction or mcontroller.facingDirection()
  local position = mcontroller.position()
  position[1] = position[1] + direction
  --Snap the position forward
  position[1] = direction > 0 and math.ceil(position[1]) or math.floor(position[1])

  local bounds = mcontroller.boundBox()

  local groundRegion = {
    math.floor(position[1] + bounds[1]), math.ceil(position[2] + bounds[2] - 1),
    math.ceil(position[1] + bounds[3]), math.ceil(position[2] + bounds[2])
  }
  if isPleasedGiraffe() then 
  if world.rectTileCollision(groundRegion, {"Null","Block","Dynamic","Platform"}) then return false end
  else
  if world.rectTileCollision(groundRegion, "Any") then return false end
  end
  return true
end
--------------------------------------------------------------------------------
-- lpk: generic~ish animation setter - some v87g specifics so shield animates correctly
function setAnimationState(base, state)
local anim = animator.animationState(base)
  if anim == state or (anim == "shieldStart" and state ~= "shieldEnd") or (anim == "shieldEnd" and state ~= "shieldStart") then return end
  if self.shielded and state == "shieldStart" then return end
  if self.shielded and state ~= "shieldEnd" then return end
  animator.setAnimationState(base,state)
end
--------------------------------------------------------------------------------
-- nearby monster was hurt, lets help kill it :D
-- function monsterDamaged(entityId, entitySeed, damageSourceId)
  -- if self.targetId == nil and damageSourceId > 0 and damageSourceId ~= entity.id()
  -- and world.callScriptedEntity(damageSourceId,"isGardenbot") == true then
-- -- no targ, damID not player, damID not self, damID is gbot
    -- self.state.pickState(entityId)
  -- end
-- end
function monsterDamaged(notifications) -- cheerful giraffe - 
    -- for _,notification in pairs(notifications) do
      -- if notification.damage > 0 and self.targetId == nil and notification.sourceEntityId ~= entity.id() 
      -- and world.callScriptedEntity(notification.sourceEntityId,"isGardenbot") == true then
        -- monster.say(util.tableToString(notification))
        -- return
      -- end
    -- end
end
--------------------------------------------------------------------------------

function itemCategory(item) -- lpk
--   world.logInfo("\n%s\n%s",item,root.itemConfig(item.name).config.category)
 if item.parameters and item.parameters.itemName then
    if item.parameters.itemName == "generatedgun" then return item.parameters.weaponType end
    if item.parameters.generated then return nil end
    return root.itemConfig(item.parameters.itemName).config.category
  end
  return root.itemConfig(item.name).config.category
end
      
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------

--prints tables
function printTable(indent, value)
    local tabs = "";
    for i=1,indent,1 do
        tabs = tabs.."    ";
    end
    table.sort(value)
    for k,v in pairs(value) do
        sb.logInfo(tabs..getValueOutput(k,v));
        if type(v) == "table" then
            if tostring(k) == "utf8" then
                sb.logInfo("    "..tabs.."SKIPPING UTF8")-- SINCE IT SEEMS TO HAVE NO END AND JUST BE FILLED WITH TABLES OF TABLES
            else
                if tableLen(v) == 0 then
                    sb.logInfo("    "..tabs.."EMPTY TABLE")
                else
                    printTable(indent+1,v);
                 
                end
            end
            sb.logInfo(" ");
        end
    end
 
end

function tableLen(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end

--Required for printTable
function getValueOutput(key ,value)
    if type(value) == "table" then
        return "table : "..key;
    elseif type(value) == "function" then
        return "function : "..key.."()"
    elseif type(value) == "string" then
        return "string : "..key.." - \""..tostring(value).."\"";
    else
        return type(value).." : "..key.." - "..tostring(value);
    end
end