--------------------------------------------------------------------------------
gatherState = {}
--------------------------------------------------------------------------------
function gatherState.enter()
  local position = mcontroller.position()
  local target = gatherState.findTargetPosition(position)
  if target ~= nil then
    return {
      targetId = target.targetId,
      targetPosition = target.targetPosition,
      timer = util.randomInRange(config.getParameter("gardenSettings.locateTime")),
      located = false
    }
  end
  return nil,2
end
--------------------------------------------------------------------------------
function gatherState.update(dt, stateData)
  stateData.timer = stateData.timer - dt
  if stateData.targetPosition == nil or not world.entityExists(stateData.targetId) then
    return true--,config.getParameter("gardenSettings.cooldown", 15)
  end
  
  stateData.targetPosition = world.entityPosition(stateData.targetId)
  local position = mcontroller.position()
  local toTarget = world.distance(stateData.targetPosition, position)
  local distance = world.magnitude(toTarget)
util.debugLine(mcontroller.position(),vec2.add(mcontroller.position(),toTarget),"red")
  if distance - 1 <= config.getParameter("gardenSettings.interactRange") then
--    entity.setFacingDirection(util.toDirection(toTarget[1]))
    mcontroller.controlFace(util.toDirection(toTarget[1]))
    setAnimationState("movement", "work")
    if not stateData.located then
      stateData.located = true
      stateData.timer = util.randomInRange(config.getParameter("gardenSettings.depositTime"))
    elseif stateData.timer < 0 then
      local r = world.takeItemDrop(stateData.targetId, entity.id())
      if r ~= nil then
        if r.name == "sapling" then gatherState.saplingHueShift(r) end
        self.inv.add({name = r.name, count = r.count, parameters = r.parameters})
        if storage.seedMemory and storage.seedMemory[r.name] ~= nil then self.lastSeed = r.name end
        if animator.hasSound("gather") then animator.playSound("gather") end
        return true
      end
    end
  else
    local dy = config.getParameter("gardenSettings.fovHeight") / 2
    move({toTarget[1], toTarget[2] + dy})
  end

  return stateData.timer < 0, 2
end
--------------------------------------------------------------------------------
function gatherState.saplingHueShift(it)
  if it.parameters ~= nil then 
  if it.parameters.foliageHueShift ~= nil then it.parameters.foliageHueShift = 0 end
  if it.parameters.stemHueShift ~= nil then it.parameters.stemHueShift = 0 end
  end
end
--------------------------------------------------------------------------------
function gatherState.findTargetPosition(position)
  local objectIds = {}
  if string.find(self.searchType, '^linear') then
    position[2] = position[2]+math.ceil(mcontroller.boundBox()[2]) -- lpk: adjust base position
    local p1 = vec2.add({-self.searchDistance, -1}, position)
    local p2 = vec2.add({self.searchDistance, 0}, position)
--    util.debugRect({p1[1],p1[2],p2[1],p2[2]},"magenta")
    objectIds = world.itemDropQuery(p1, p2,{order = "nearest"})
  elseif string.find(self.searchType, '^radial') then
    objectIds = world.itemDropQuery(position, self.searchDistance,{order = "nearest"})
  end
--  if config.getParameter("gardenSettings.efficiency") then
--    table.sort(objectIds, distanceSort)
--  end
  for _,oId in pairs(objectIds) do
    if gatherState.canGather(world.entityName(oId)) then
      local oPos = world.entityPosition(oId)
      --local dy = config.getParameter("gardenSettings.fovHeight") / 2
      --oPos[2] = oPos[2] + dy
      --local tPos = {0, oPos[2]}
      --if oPos[1] < position[1] then
      --  tPos[1] = oPos[1] + config.getParameter("gardenSettings.interactRange")
      --else
      --  tPos[1] = oPos[1] - config.getParameter("gardenSettings.interactRange")
      --end
	  if canReachTarget(oId) or (not entity.entityInSight(oId) and world.magnitude(entity.distanceToEntity(oId)) < config.getParameter("gardenSettings.interactRange")) then
        return { targetId = oId, targetPosition = oPos }
	  end
    end
  end

  return nil
end

function gatherState.canGather(name)
  if name == nil then return false end
  if self.harvest[string.lower(name)] then return true end
  if self.harvestType[root.itemType(name)] then return true end
  for _,v in ipairs(self.harvestMatch) do
    local match = string.match(string.lower(name), v)
    if match ~= nil then return true end
  end
  if 1-math.random() > 0.5 then self.harvest[string.lower(name)] = true end --lpk: learn to gather it
  return false
end