--------------------------------------------------------------------------------
grassState = {}
--------------------------------------------------------------------------------
function grassState.enter()
  local position = mcontroller.position()
  local target = grassState.findPosition(position)
  if target ~= nil then
    return {
      targetPosition = target.position,
      grass = target.grass,
      timer = util.randomInRange(config.getParameter("gardenSettings.locateTime")),
      located = false
    }
  end
  return nil,config.getParameter("gardenSettings.cooldown", 15)
end
--------------------------------------------------------------------------------
function grassState.update(dt, stateData)
  stateData.timer = stateData.timer - dt
  if stateData.targetPosition == nil then
    return true
  end
  
  local position = mcontroller.position()
  local toTarget = world.distance(stateData.targetPosition, position)
  local distance = world.magnitude(toTarget)
util.debugLine(mcontroller.position(),vec2.add(mcontroller.position(),toTarget),"red")
  if distance < math.ceil(config.getParameter("gardenSettings.interactRange")) then
--    entity.setFacingDirection(util.toDirection(toTarget[1]))
    mcontroller.controlFace(util.toDirection(toTarget[1]))
    setAnimationState("movement", "work")
    if not stateData.located then
      stateData.located = true
      stateData.timer = util.randomInRange(config.getParameter("gardenSettings.plantTime"))
    elseif stateData.timer < 0 then
      if stateData.grass == nil then
        storage.grassMemory = world.mod(vec2.add({0, -1}, stateData.targetPosition), "foreground")
      else
        local modPos = vec2.add({0, -1}, stateData.targetPosition)
        local wmod = world.mod(modPos, "foreground")
        if wmod == nil -- nothing there
        or not world.damageTiles({modPos}, "foreground", position, "plantish", 1) then -- under tree?
          world.placeMod(modPos, "foreground", stateData.grass)
          storage.grassMemory = nil
        end
        if animator.hasSound("grass") then animator.playSound("grass") end
      end
      return true,1
    end
  else
    local dy = config.getParameter("gardenSettings.fovHeight") / 2
    move({toTarget[1], toTarget[2] + dy})
  end

  return stateData.timer < 0,config.getParameter("gardenSettings.cooldown", 15)
end
--------------------------------------------------------------------------------
function grassState.findPosition(position)
  position[2] = position[2]+math.ceil(mcontroller.boundBox()[2]) -- lpk: fix so lumbers can do grass too
  local basePosition = {
    math.floor(position[1] + 0.5),
    math.floor(position[2] + 0.5) - 1
  }
  
  for offset = 1, config.getParameter("gardenSettings.plantDistance", 10), 1 do
    for d = -1, 2, 2 do
      local targetPosition = vec2.add({ offset * d, 0 }, basePosition)
      local modName = world.mod(vec2.add({0, -1}, targetPosition), "foreground")
--  world.debugText("%s",modName,vec2.add({0, -4+offset%3}, targetPosition),"white")
      local success = false
      if (storage.grassMemory and (modName == nil or (modName ~= storage.grassMemory and not string.find(modName,"tilled") and not isOre(modName))) ) then
        local m1 = world.material(targetPosition, "foreground")
        local m2 = world.material(vec2.add({0, -1}, targetPosition), "foreground")
        success = not m1 and m2 == storage.matMemory
        if not success then
          self.grassTries = not self.grassTries and 30 or self.grassTries - 1
          if self.grassTries < 1 then
            storage.matMemory = nil
            storage.grassMemory = nil
            return nil
          end
        end
      elseif (storage.grassMemory == nil and modName and string.find(modName, "grass")) then
        success = true
        storage.matMemory = world.material(vec2.add({0, -1}, targetPosition), "foreground")
        self.grassTries = 30 -- # of times to try
      end
      if success and canReachTarget(targetPosition) then
        return { position = targetPosition, grass = storage.grassMemory}
      end
    end
  end
  return nil
end