--------------------------------------------------------------------------------
returnState = {}
--------------------------------------------------------------------------------
--function returnState.enter()
-- return returnState.enterWith({ignoreDistance = false})
--end


function returnState.enterWith(args)
if type(args) ~= "table" or args.ignoreDistance == nil then return nil end
    if self.homeBin ~= nil or self.spawnPoint ~= nil then
      local position = mcontroller.position()
      local range = config.getParameter("gardenSettings.wanderRange") or 60
      local hPos = nil
      if self.homeBin ~= nil and world.entityExists(self.homeBin) then
        hPos = world.entityPosition(self.homeBin) 
        hPos[2] = hPos[2] - mcontroller.boundBox()[2] -- adjust for height
      else
        hPos = self.spawnPoint
      end
      local toTarget = world.distance(hPos, position)
      local distance = world.magnitude(toTarget)
      --if (type(args) == "table" and args.ignoreDistance) then world.logInfo("FORCED RETURN TO HOME") end
      if (type(args) == "table" and args.ignoreDistance) or distance > range then
        return {
          targetPosition = hPos,
          timer = travelTime(distance)--(config.getParameter("gardenSettings.returnTime", 15)
        }
      end
    end
  return nil,config.getParameter("gardenSettings.cooldown", 15)
end
--------------------------------------------------------------------------------
function returnState.update(dt, stateData)
  if mcontroller.liquidMovement() then dt = dt/2 end
  stateData.timer = stateData.timer - dt
  if stateData.targetPosition == nil then
    return true,config.getParameter("gardenSettings.cooldown", 15)
  end

  local position = mcontroller.position()
  local toTarget = world.distance(stateData.targetPosition, position)
  local distance = world.magnitude(toTarget)
util.debugLine(mcontroller.position(),vec2.add(mcontroller.position(),toTarget),"red")
  if distance < 3 * config.getParameter("gardenSettings.interactRange") then
    stateData.timer = -1
    self.ignoreIds = {}
    setAnimationState("movement", "idle")
  else
    if self.stuckCount > 50 or (stateData.timer < 0 and not canReachTarget(stateData.targetPosition)) then
      local p = stateData.targetPosition
      local r1 = mcontroller.boundBox()
      world.loadRegion({p[1]+r1[1], p[2]+r1[2],p[1]+r1[3],p[2]+r1[4]})
      mcontroller.setPosition({p[1], p[2]})-- + 0.5 + math.abs(mcontroller.boundBox()[2])})
      status.addEphemeralEffect("beamin",0.25)
      mcontroller.setVelocity({0,-1 * world.gravity(mcontroller.position())})
      setAnimationState("movement", "idle")
    else
      move({toTarget[1], toTarget[2]})
    end
  end

  return stateData.timer <= -1,config.getParameter("gardenSettings.cooldown", 15)
end