delegate.create("simplegardenbot")
--------------------------------------------------------------------------------
simplegardenbot = {}
grassState = {}
tillState = {}
mineState = {}
waterState = {}
returnState = {}
idleState = {}
--------------------------------------------------------------------------------
function simplegardenbot.init(args)
  self.sensors = sensors.create()
  self.state = stateMachine.create({
    "gatherState",
    "plantState",
    "harvestState",
    "depositState",
    "grassState",
    "tillState",
    "mineState",
    "waterState",
    "moveState",
    "attackState",
    "idleState",
    "returnState"
  })
  self.state.leavingState = function(stateName)
    setAnimationState("movement", "idle")
  end
  
  self.state.stateCooldown("plantState",cooldown()/2)-- lpk: add some delay before cpu intensive states can trigger
  self.state.stateCooldown("harvestState",cooldown())
  self.state.stateCooldown("depositState",cooldown()*2)
  
  self.inState = ""
  self.debug = true
  
  self.stuckCount = 0
  self.stuckPosition = {}

end
--------------------------------------------------------------------------------
-- function update(dt)
-- world.loadRegion({mcontroller.position()[1]-5, mcontroller.position()[2]-5,mcontroller.position()[1]+5,mcontroller.position()[2]+5})
-- self.dt = dt
-- simplegardenbot.main()
-- end

function simplegardenbot.update()
local p1,r1 = mcontroller.position(),mcontroller.boundBox()
world.loadRegion({p1[1]+r1[1], p1[2]+r1[2],p1[1]+r1[3],p1[2]+r1[4]})
	self.dt = script.updateDt()
  self.inState = self.state.stateDesc()
  self.state.update(self.dt)--entity.dt())
  self.sensors.clear()
  if self.debug then
    world.debugText("%s",self.inState,vec2.add(mcontroller.position(),{-3,1.5}),"white")
--    world.debugText("e%% %s",storage.efficiency*100,vec2.add(mcontroller.position(),{-3,0.5}),"white")
  end
  if self.displayName and self.displayName ~= "" then
    local newname = string.format("%s\n%s %%",self.displayName,storage.efficiency*100)
    monster.setName(newname)
  end
end
--------------------------------------------------------------------------------
function move(direction)
  if type(direction) == "table" then direction = direction[1] end
  local mcPos = mcontroller.position()

 --lpk: all the states call move, check for forced direction here
 -- if willFall(direction) then direction = -direction end  -- try not to fall
  direction = touchingFenceDirection(mcPos,direction)-- fence last
 
  setAnimationState("movement", "move")
  local run = self.inState ~= "moveState"--util.toDirection(direction) == mcontroller.facingDirection() and not self.inState == "moveState"
  mcontroller.controlMove(direction, run)
  mcontroller.controlFace(direction)
  checkStuck()
  self.lastMoveDirection = util.toDirection(direction)
  if self.stuckCount > config.getParameter("stuckCountMax",15) and self.inState ~= "returnState" then
    self.state.pickState({ignoreDistance=true})
  end
end
--------------------------------------------------------------------------------
moveState = {}
--------------------------------------------------------------------------------
function moveState.enter()
  local direction = mcontroller.facingDirection()
  local timer = util.randomInRange(config.getParameter("moveTimeRange"))
  return {
    timer = timer,--entity.randomizeParameterRange("moveTimeRange"),
    direction = direction
  }
end
--------------------------------------------------------------------------------
function moveState.update(dt, stateData)
  stateData.direction = self.lastMoveDirection

  if self.sensors.collisionSensors.collision.any(true) then
    stateData.direction = -stateData.direction
  end

--[[  -- lpk: replaced in move()  
  local b,t = canReachTarget(vec2.add(mcontroller.position(), {stateData.direction, 0}))
  if not b and t ~= nil then
    local distance = world.distance(t, mcontroller.position())
    stateData.direction = -util.toDirection(distance[1])
  end
--]]
--  stateData.direction = touchingFenceDirection(mcontroller.position(),stateData.direction)
--[[
  if mcontroller.onGround() and
     not self.sensors.nearGroundSensor.collisionTrace.any(true) and
     self.sensors.midGroundSensor.collisionTrace.any(true) then
    mcontroller.controlDown()
  end
--]]
  move(stateData.direction)

  stateData.timer = stateData.timer - dt
  if stateData.timer <= 0 then
    return true, 1.0
  end

  return false
end
--------------------------------------------------------------------------------
attackState = {}
--------------------------------------------------------------------------------
function attackState.enter()
if os.time() ~= self.lastAttackTime then self.lastAttackTime = os.time() else return nil end
  local findDist = config.getParameter("attackSearchRadius",10)

--  if util.trackTarget(findDist,findDist/2,nil) then --  also targets player boo :"(
  if attackState.findValidTarget(mcontroller.position(),findDist) then
--world.logInfo("attacking: %s",self.targetId)
    return { timer = config.getParameter("attackTargetHoldTime",5) } 
  end
  
  return nil --config.getParameter("gardenSettings.cooldown", 15)
end

--------------------------------------------------------------------------------
function targInLOS(targID)
  local targPos = world.entityPosition(targID)
  local blocksInLos 
  if isPleasedGiraffe() then
  blocksInLos = world.collisionBlocksAlongLine(mcontroller.position(), targPos, {"Null","Block","Dynamic"})
  else
  blocksInLos = world.collisionBlocksAlongLine(mcontroller.position(), targPos, "Dynamic")
  end
  return #blocksInLos == 0
end

function attackState.isValidTarget(mId)
  if math.random() < 0.1 and world.callScriptedEntity(mId,"isGardenbot") ~= true then 
    local wed = world.entityDamageTeam(mId)
    local dtt = wed.type or nil
    if dtt == nil then -- check same damageTeam, assign as passive
      if wed.team and entity.damageTeam().team == wed.team then dtt = "friendly" end
    end
    if dtt ~= "friendly" and dtt ~= "passive" and dtt ~= "ghostly" and dtt ~= nil then 
      return true
    end 
    if world.monsterType(mId) == "petball" then return true end
  end
  return false
end --

function attackState.findValidTarget(pos,dist)
  local monsterIds = world.entityQuery(pos, dist, { withoutEntityId = entity.id(),includedTypes = {"monster"}, order = "nearest" })

  if #monsterIds > 0 then
    for i,mId in ipairs(monsterIds) do
--      if (entity.isValidTarget(mId) and (attackState.isValidTarget(mId))) and targInLOS(mId) then
      if ((attackState.isValidTarget(mId))) and targInLOS(mId) then
        attackState.setAggressive(mId)
--	    util.trackExistingTarget()
        return true
	    end
    end
  end
   
  return false
end
--------------------------------------------------------------------------------
function attackState.enterWith(targetId)
  if type(targetId) ~= "number" then return nil end -- lpk: fix trying to use returnState params
  if targetId == 0 then return nil end
  if world.isMonster(targetId) and world.callScriptedEntity(targetId,"isGardenbot") == true then return nil end

  attackState.setAggressive(targetId)

  return { timer = config.getParameter("attackTargetHoldTime") }
end
--------------------------------------------------------------------------------
function attackState.update(dt, stateData)
  util.trackExistingTarget()

  if self.attackHoldTimer ~= nil then
    self.attackHoldTimer = self.attackHoldTimer - dt
    if self.attackHoldTimer > 0 then
      return false
    else
      self.attackHoldTimer = nil
    end
  end

  if self.targetId == nil then
    stateData.timer = 0--stateData.timer - dt
  else--if not canReachTarget(self.targetId) then -- bounce on fences like angry dog
    stateData.timer = stateData.timer - dt
--  else
--    stateData.timer = config.getParameter("attackTargetHoldTime",5)
  end

  if stateData.timer <= 0 then
    attackState.setAttackEnabled(false)
    attackState.setAggressive(nil)
    return true
  end

  if self.targetPosition ~= nil then
    local toTarget = world.distance(self.targetPosition, mcontroller.position())

    if world.magnitude(toTarget) < config.getParameter("attackDistance") then
      attackState.setAttackEnabled(true)
      stateData.timer = config.getParameter("attackTargetHoldTime",5)
      if animator.hasSound("attack") then animator.playSound("attack") end
      maybeKickPetball()
    else
      attackState.setAttackEnabled(false)
      move(util.toDirection(toTarget[1]))
    end
  end
  
  return false
end
--------------------------------------------------------------------------------
function attackState.setAttackEnabled(enabled)
  if enabled then
    setAnimationState("movement", "attack")
    self.attackHoldTimer = config.getParameter("attackHoldTime")
  else
    setAnimationState("movement", "aggro")
  end

  setDamageSources(enabled)
  monster.setDamageOnTouch(enabled)
end
--------------------------------------------------------------------------------
function attackState.setAggressive(targetId)
  self.targetId = targetId

  if targetId ~= nil then
    setAnimationState("movement", "aggro")
    monster.setAggressive(true)
  else
    setAnimationState("movement", "idle")
    monster.setAggressive(false)
  end
end