--------------------------------------------------------------------------------
tillState = {}
--------------------------------------------------------------------------------
function tillState.enter()
  local position = mcontroller.position()
  local target = tillState.findPosition(position)
  if target ~= nil then
    return {
      targetPosition = target.position,
      till = target.till,
--      timer = entity.randomizeParameterRange("gardenSettings.locateTime"),
      timer = util.randomInRange(config.getParameter("gardenSettings.locateTime")),
      located = false
    }
  end
  return nil,config.getParameter("gardenSettings.cooldown", 15)
end
--------------------------------------------------------------------------------
function tillState.update(dt, stateData)
  stateData.timer = stateData.timer - dt
  if stateData.targetPosition == nil then
    return true
  end
  
  local position = mcontroller.position()
  local toTarget = world.distance(stateData.targetPosition, position)
  local distance = world.magnitude(toTarget)
util.debugLine(mcontroller.position(),vec2.add(mcontroller.position(),toTarget),"red")
  if distance < math.ceil(config.getParameter("gardenSettings.interactRange")) then
--    entity.setFacingDirection(util.toDirection(toTarget[1]))
    mcontroller.controlFace(util.toDirection(toTarget[1]))
    setAnimationState("movement", "work")
    if not stateData.located then
      stateData.located = true
      stateData.timer = util.randomInRange(config.getParameter("gardenSettings.plantTime"))
    elseif stateData.timer < 0 then
      local modPos = vec2.add({0, -1}, stateData.targetPosition)
      local modName = world.mod(modPos, "foreground")
      if stateData.till == nil then
        if isPleasedGiraffe() and modName == "tilled" then modName = "tilleddry" end
        storage.tillMemory = modName
      else        
        if (modName == nil or not string.find(modName,"tilled"))-- nothing there or already tilled
        or not world.damageTiles({modPos}, "foreground", position, "plantish", 1) then -- under tree?
          world.placeMod(modPos, "foreground", stateData.till)
--          storage.tillMemory = nil
        end
        if animator.hasSound("till") then animator.playSound("till") end
      end
      return true, 1
    end
  else
    local dy = config.getParameter("gardenSettings.fovHeight") / 2
    move({toTarget[1], toTarget[2] + dy})
  end

  return stateData.timer < 0,config.getParameter("gardenSettings.cooldown", 15)
end
--------------------------------------------------------------------------------
function tillState.findPosition(position)
  position[2] = position[2]+math.ceil(mcontroller.boundBox()[2]) -- lpk: fix so lumbers can do till too
  local basePosition = {
    math.floor(position[1] + 0.5),
    math.floor(position[2] + 0.5) - 1
  }
  local isTillable = function(mname)
  return type(mname) == "string" and (string.find(mname,"dirt") or mname == "mud" or mname == "clay")
  end
  
  for offset = 1, config.getParameter("gardenSettings.plantDistance", 10), 1 do
    for d = -1, 2, 2 do
      local targetPosition = vec2.add({ offset * d, 0 }, basePosition)
      local modName = world.mod(vec2.add({0, -1}, targetPosition), "foreground")
--  world.debugText("%s",modName,vec2.add({0, -4+offset%3}, targetPosition),"white")
      local m2 = world.material(vec2.add({0, -1}, targetPosition), "foreground")
      local success = false
      if (storage.tillMemory and (modName == nil or (modName ~= storage.tillMemory and string.find(modName, "grass")))) then
        local m1 = world.material(targetPosition, "foreground")
        success = not m1 and isTillable(m2)--m2 == storage.matMemory
      elseif (storage.tillMemory == nil and modName and string.find(modName, "tilled")) then
        success = true
--        storage.matMemory = m2--world.material(vec2.add({0, -1}, targetPosition), "foreground")
      elseif (storage.tillMemory == nil and modName == nil and m2 and isTillable(m2) 
        and not world.tileIsOccupied(targetPosition)
        and world.damageTiles({vec2.add({0, -1}, targetPosition)}, "foreground", position, "tilling", 0.1)) then
          storage.tillMemory = isPleasedGiraffe() and "tilleddry" or "tilled"
          success = true
        
      end
      if success and canReachTarget(targetPosition) then
        return { position = targetPosition, till = storage.tillMemory}
      end
    end
  end
  return nil
end